/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetDeploymentStatsAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;

public class RestGetTrainedModelDeploymentStatsAction
extends BaseRestHandler {
    public String getName() {
        return "ml_get_trained_models_deployment_stats_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_ml/trained_models/{" + StartTrainedModelDeploymentAction.Request.MODEL_ID.getPreferredName() + "}/deployment/_stats"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String modelId = restRequest.param(StartTrainedModelDeploymentAction.Request.MODEL_ID.getPreferredName());
        GetDeploymentStatsAction.Request request = new GetDeploymentStatsAction.Request(modelId);
        request.setAllowNoMatch(restRequest.paramAsBoolean("allow_no_match", request.isAllowNoMatch()));
        return channel -> client.execute((ActionType)GetDeploymentStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

