/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.InferTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class RestInferTrainedModelDeploymentAction
extends BaseRestHandler {
    public String getName() {
        return "xpack_ml_infer_trained_models_deployment_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_ml/trained_models/{" + TrainedModelConfig.MODEL_ID.getPreferredName() + "}/deployment/_infer"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String deploymentId = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        if (!restRequest.hasContent()) {
            throw ExceptionsHelper.badRequestException((String)"requires body", (Object[])new Object[0]);
        }
        InferTrainedModelDeploymentAction.Request.Builder request = InferTrainedModelDeploymentAction.Request.parseRequest((String)deploymentId, (XContentParser)restRequest.contentParser());
        if (restRequest.hasParam(InferTrainedModelDeploymentAction.Request.TIMEOUT.getPreferredName())) {
            TimeValue inferTimeout = restRequest.paramAsTime(InferTrainedModelDeploymentAction.Request.TIMEOUT.getPreferredName(), InferTrainedModelDeploymentAction.Request.DEFAULT_TIMEOUT);
            request.setInferenceTimeout(inferTimeout);
        }
        return channel -> client.execute((ActionType)InferTrainedModelDeploymentAction.INSTANCE, (ActionRequest)request.build(), (ActionListener)new RestToXContentListener(channel));
    }
}

