/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditor;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.autoscaling.NativeMemoryCapacity;
import org.elasticsearch.xpack.ml.job.JobNodeSelector;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public abstract class AbstractJobPersistentTasksExecutor<Params extends PersistentTaskParams>
extends PersistentTasksExecutor<Params> {
    private static final Logger logger = LogManager.getLogger(AbstractJobPersistentTasksExecutor.class);
    protected final MlMemoryTracker memoryTracker;
    protected final IndexNameExpressionResolver expressionResolver;
    protected final Cache<String, Long> auditedJobCapacity = CacheBuilder.builder().setExpireAfterWrite(TimeValue.timeValueMinutes((long)30L)).build();
    protected volatile int maxConcurrentJobAllocations;
    protected volatile int maxMachineMemoryPercent;
    protected volatile int maxLazyMLNodes;
    protected volatile boolean useAutoMemoryPercentage;
    protected volatile long maxNodeMemory;
    protected volatile int maxOpenJobs;

    public static List<String> verifyIndicesPrimaryShardsAreActive(ClusterState clusterState, IndexNameExpressionResolver expressionResolver, boolean allowMissing, String ... indicesOfInterest) {
        String[] indices = expressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), indicesOfInterest);
        ArrayList<String> unavailableIndices = new ArrayList<String>(indices.length);
        for (String index : indices) {
            if (!clusterState.metadata().hasIndex(index)) {
                if (allowMissing) continue;
                unavailableIndices.add(index);
                continue;
            }
            IndexRoutingTable routingTable = clusterState.getRoutingTable().index(index);
            if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    protected AbstractJobPersistentTasksExecutor(String taskName, String executor, Settings settings, ClusterService clusterService, MlMemoryTracker memoryTracker, IndexNameExpressionResolver expressionResolver) {
        super(taskName, executor);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.expressionResolver = Objects.requireNonNull(expressionResolver);
        this.maxConcurrentJobAllocations = (Integer)MachineLearning.CONCURRENT_JOB_ALLOCATIONS.get(settings);
        this.maxMachineMemoryPercent = (Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings);
        this.maxLazyMLNodes = (Integer)MachineLearning.MAX_LAZY_ML_NODES.get(settings);
        this.maxOpenJobs = (Integer)MachineLearning.MAX_OPEN_JOBS_PER_NODE.get(settings);
        this.useAutoMemoryPercentage = (Boolean)MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT.get(settings);
        this.maxNodeMemory = ((ByteSizeValue)MachineLearning.MAX_ML_NODE_SIZE.get(settings)).getBytes();
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.CONCURRENT_JOB_ALLOCATIONS, this::setMaxConcurrentJobAllocations);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_MACHINE_MEMORY_PERCENT, this::setMaxMachineMemoryPercent);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_LAZY_ML_NODES, this::setMaxLazyMLNodes);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_OPEN_JOBS_PER_NODE, this::setMaxOpenJobs);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT, this::setUseAutoMemoryPercentage);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_ML_NODE_SIZE, this::setMaxNodeSize);
    }

    protected String getUniqueId(String jobId) {
        return this.getTaskName() + "-" + jobId;
    }

    protected void auditRequireMemoryIfNecessary(String jobId, AbstractAuditor<?> auditor, PersistentTasksCustomMetadata.Assignment assignment, JobNodeSelector jobNodeSelector, boolean isMemoryTrackerRecentlyRefreshed) {
        if (assignment.equals((Object)JobNodeSelector.AWAITING_LAZY_ASSIGNMENT)) {
            if (isMemoryTrackerRecentlyRefreshed) {
                Tuple<NativeMemoryCapacity, Long> capacityAndFreeMemory = jobNodeSelector.perceivedCapacityAndMaxFreeMemory(this.maxMachineMemoryPercent, this.useAutoMemoryPercentage, this.maxOpenJobs);
                Long previouslyAuditedFreeMemory = (Long)this.auditedJobCapacity.get((Object)this.getUniqueId(jobId));
                if (!((Long)capacityAndFreeMemory.v2()).equals(previouslyAuditedFreeMemory)) {
                    auditor.info(jobId, Messages.getMessage((String)"Job requires at least [{0}] free memory on a machine learning capable node to run; [{1}] are available. The current total capacity for ML [total: {2}, largest node: {3}].", (Object[])new Object[]{ByteSizeValue.ofBytes((long)this.memoryTracker.getJobMemoryRequirement(this.getTaskName(), jobId)), ByteSizeValue.ofBytes((long)((Long)capacityAndFreeMemory.v2())), ByteSizeValue.ofBytes((long)((NativeMemoryCapacity)capacityAndFreeMemory.v1()).getTier()), ByteSizeValue.ofBytes((long)((NativeMemoryCapacity)capacityAndFreeMemory.v1()).getNode())}));
                    this.auditedJobCapacity.put((Object)this.getUniqueId(jobId), (Object)((Long)capacityAndFreeMemory.v2()));
                }
            }
        } else {
            this.auditedJobCapacity.invalidate((Object)this.getUniqueId(jobId));
        }
    }

    protected abstract String[] indicesOfInterest(Params var1);

    protected abstract String getJobId(Params var1);

    protected boolean allowsMissingIndices() {
        return true;
    }

    public Optional<PersistentTasksCustomMetadata.Assignment> getPotentialAssignment(Params params, ClusterState clusterState, boolean isMemoryTrackerRecentlyRefreshed) {
        if (MlMetadata.getMlMetadata((ClusterState)clusterState).isUpgradeMode()) {
            return Optional.of(MlTasks.AWAITING_UPGRADE);
        }
        if (MlMetadata.getMlMetadata((ClusterState)clusterState).isResetMode()) {
            return Optional.of(MlTasks.RESET_IN_PROGRESS);
        }
        String jobId = this.getJobId(params);
        Optional<PersistentTasksCustomMetadata.Assignment> missingIndices = this.checkRequiredIndices(jobId, clusterState, this.indicesOfInterest(params));
        if (missingIndices.isPresent()) {
            return missingIndices;
        }
        Optional<PersistentTasksCustomMetadata.Assignment> staleMemory = this.checkMemoryFreshness(jobId, isMemoryTrackerRecentlyRefreshed);
        if (staleMemory.isPresent()) {
            return staleMemory;
        }
        return Optional.empty();
    }

    void setMaxConcurrentJobAllocations(int maxConcurrentJobAllocations) {
        this.maxConcurrentJobAllocations = maxConcurrentJobAllocations;
    }

    void setMaxMachineMemoryPercent(int maxMachineMemoryPercent) {
        this.maxMachineMemoryPercent = maxMachineMemoryPercent;
    }

    void setMaxLazyMLNodes(int maxLazyMLNodes) {
        this.maxLazyMLNodes = maxLazyMLNodes;
    }

    void setMaxOpenJobs(int maxOpenJobs) {
        this.maxOpenJobs = maxOpenJobs;
    }

    void setUseAutoMemoryPercentage(boolean useAutoMemoryPercentage) {
        this.useAutoMemoryPercentage = useAutoMemoryPercentage;
    }

    void setMaxNodeSize(ByteSizeValue maxNodeSize) {
        this.maxNodeMemory = maxNodeSize.getBytes();
    }

    public Optional<PersistentTasksCustomMetadata.Assignment> checkRequiredIndices(String jobId, ClusterState clusterState, String ... indicesOfInterest) {
        List<String> unavailableIndices = AbstractJobPersistentTasksExecutor.verifyIndicesPrimaryShardsAreActive(clusterState, this.expressionResolver, this.allowsMissingIndices(), indicesOfInterest);
        if (unavailableIndices.size() != 0) {
            String reason = "Not opening [" + jobId + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
            logger.debug(reason);
            return Optional.of(new PersistentTasksCustomMetadata.Assignment(null, reason));
        }
        return Optional.empty();
    }

    public Optional<PersistentTasksCustomMetadata.Assignment> checkMemoryFreshness(String jobId, boolean isMemoryTrackerRecentlyRefreshed) {
        boolean scheduledRefresh;
        if (!isMemoryTrackerRecentlyRefreshed && (scheduledRefresh = this.memoryTracker.asyncRefresh())) {
            String reason = "Not opening job [" + jobId + "] because job memory requirements are stale - refresh requested";
            logger.debug(reason);
            return Optional.of(new PersistentTasksCustomMetadata.Assignment(null, reason));
        }
        return Optional.empty();
    }
}

