/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.AbstractGeoTileGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;

public class BoundedGeoTileGridTiler
extends AbstractGeoTileGridTiler {
    private final boolean crossesDateline;
    private final long maxTiles;
    private final int minX;
    private final int maxX;
    private final int minY;
    private final int maxY;

    public BoundedGeoTileGridTiler(int precision, GeoBoundingBox bbox) {
        super(precision);
        boolean bl = this.crossesDateline = bbox.right() < bbox.left();
        if (bbox.bottom() > GeoTileUtils.NORMALIZED_LATITUDE_MASK || bbox.top() < GeoTileUtils.NORMALIZED_NEGATIVE_LATITUDE_MASK) {
            this.maxY = -1;
            this.minY = -1;
            this.maxX = -1;
            this.minX = -1;
            this.maxTiles = 0L;
        } else {
            int minY;
            int minX = GeoTileUtils.getXTile((double)bbox.left(), (long)this.tiles);
            Rectangle minTile = GeoTileUtils.toBoundingBox((int)minX, (int)(minY = GeoTileUtils.getYTile((double)bbox.top(), (long)this.tiles)), (int)precision);
            this.minX = minTile.getMaxX() == bbox.left() ? minX + 1 : minX;
            this.minY = minTile.getMinY() == bbox.top() ? minY + 1 : minY;
            int maxX = GeoTileUtils.getXTile((double)bbox.right(), (long)this.tiles);
            int maxY = GeoTileUtils.getYTile((double)bbox.bottom(), (long)this.tiles);
            Rectangle maxTile = GeoTileUtils.toBoundingBox((int)maxX, (int)maxY, (int)precision);
            this.maxX = maxTile.getMinX() == bbox.right() ? maxX : maxX + 1;
            this.maxY = maxTile.getMaxY() == bbox.bottom() ? maxY : maxY + 1;
            this.maxTiles = this.crossesDateline ? (this.tiles + (long)this.maxX - (long)this.minX) * (long)(this.maxY - this.minY) : (long)(this.maxX - this.minX) * (long)(this.maxY - this.minY);
        }
    }

    @Override
    protected boolean validTile(int x, int y, int z) {
        int splits = 1 << this.precision - z;
        int yMin = y * splits;
        if (this.maxY > yMin && this.minY < yMin + splits) {
            int xMin = x * splits;
            if (this.crossesDateline) {
                return this.maxX > xMin || this.minX < xMin + splits;
            }
            return this.maxX > xMin && this.minX < xMin + splits;
        }
        return false;
    }

    @Override
    protected long getMaxCells() {
        return this.maxTiles;
    }

    @Override
    protected int setValuesForFullyContainedTile(int xTile, int yTile, int zTile, GeoShapeCellValues values, int valuesIndex) {
        int splits = 1 << this.precision - zTile;
        int minY = Math.max(this.minY, yTile * splits);
        int maxY = Math.min(this.maxY, yTile * splits + splits);
        if (this.crossesDateline) {
            int j;
            int i;
            int eastMinX = xTile * splits;
            int westMinX = Math.max(this.minX, xTile * splits);
            int eastMaxX = Math.min(westMinX, Math.min(this.maxX, xTile * splits + splits));
            int westMaxX = xTile * splits + splits;
            for (i = eastMinX; i < eastMaxX; ++i) {
                for (j = minY; j < maxY; ++j) {
                    assert (this.validTile(i, j, this.precision));
                    values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)this.precision, (long)i, (long)j));
                }
            }
            for (i = westMinX; i < westMaxX; ++i) {
                for (j = minY; j < maxY; ++j) {
                    assert (this.validTile(i, j, this.precision));
                    values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)this.precision, (long)i, (long)j));
                }
            }
        } else {
            int minX = Math.max(this.minX, xTile * splits);
            int maxX = Math.min(this.maxX, xTile * splits + splits);
            for (int i = minX; i < maxX; ++i) {
                for (int j = minY; j < maxY; ++j) {
                    assert (this.validTile(i, j, this.precision));
                    values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)this.precision, (long)i, (long)j));
                }
            }
        }
        return valuesIndex;
    }
}

