/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.graph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.graph.action.GraphExploreAction;
import org.elasticsearch.xpack.graph.GraphInfoTransportAction;
import org.elasticsearch.xpack.graph.GraphUsageTransportAction;
import org.elasticsearch.xpack.graph.action.TransportGraphExploreAction;
import org.elasticsearch.xpack.graph.rest.action.RestGraphAction;

public class Graph
extends Plugin
implements ActionPlugin {
    public static final LicensedFeature.Momentary GRAPH_FEATURE = LicensedFeature.momentary(null, (String)"graph", (License.OperationMode)License.OperationMode.PLATINUM);
    protected final boolean enabled;

    public Graph(Settings settings) {
        this.enabled = (Boolean)XPackSettings.GRAPH_ENABLED.get(settings);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ActionPlugin.ActionHandler usageAction = new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.GRAPH, GraphUsageTransportAction.class);
        ActionPlugin.ActionHandler infoAction = new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.GRAPH, GraphInfoTransportAction.class);
        if (!this.enabled) {
            return Arrays.asList(usageAction, infoAction);
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)GraphExploreAction.INSTANCE, TransportGraphExploreAction.class), usageAction, infoAction);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new RestGraphAction());
    }
}

