/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageResponse;
import org.elasticsearch.xpack.core.common.IteratingActionListener;

public class TransportXPackUsageAction
extends TransportMasterNodeAction<XPackUsageRequest, XPackUsageResponse> {
    private final NodeClient client;
    private final List<XPackUsageFeatureAction> usageActions;

    @Inject
    public TransportXPackUsageAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client) {
        super("cluster:monitor/xpack/usage", transportService, clusterService, threadPool, actionFilters, XPackUsageRequest::new, indexNameExpressionResolver, XPackUsageResponse::new, "management");
        this.client = client;
        this.usageActions = this.usageActions();
    }

    protected List<XPackUsageFeatureAction> usageActions() {
        return XPackUsageFeatureAction.ALL;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageResponse> listener) {
        ActionListener usageActionListener = listener.delegateFailure((l, usages) -> l.onResponse((Object)new XPackUsageResponse((List<XPackFeatureSet.Usage>)usages)));
        AtomicReferenceArray featureSetUsages = new AtomicReferenceArray(this.usageActions.size());
        AtomicInteger position = new AtomicInteger(0);
        BiConsumer<XPackUsageFeatureAction, ActionListener> consumer = (featureUsageAction, iteratingListener) -> {
            XPackUsageRequest childRequest = new XPackUsageRequest();
            childRequest.setParentTask(request.getParentTask());
            this.client.executeLocally((ActionType)featureUsageAction, (ActionRequest)childRequest, iteratingListener.delegateFailure((l, usageResponse) -> {
                featureSetUsages.set(position.getAndIncrement(), usageResponse.getUsage());
                l.onResponse(Collections.emptyList());
            }));
        };
        IteratingActionListener<List, XPackUsageFeatureAction> iteratingActionListener = new IteratingActionListener<List, XPackUsageFeatureAction>(usageActionListener, consumer, this.usageActions, this.threadPool.getThreadContext(), ignore -> {
            ArrayList<XPackFeatureSet.Usage> usageList = new ArrayList<XPackFeatureSet.Usage>(featureSetUsages.length());
            for (int i = 0; i < featureSetUsages.length(); ++i) {
                usageList.add((XPackFeatureSet.Usage)featureSetUsages.get(i));
            }
            return usageList;
        }, ignore -> true);
        iteratingActionListener.run();
    }

    protected ClusterBlockException checkBlock(XPackUsageRequest request, ClusterState state) {
        return null;
    }
}

