/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common.stats;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class EnumCounters<E extends Enum<E>>
implements Writeable {
    private final AtomicLongArray counters;
    private final E[] enums;

    public EnumCounters(Class<E> enumClass) {
        this.counters = new AtomicLongArray(((Enum[])enumClass.getEnumConstants()).length);
        this.enums = (Enum[])enumClass.getEnumConstants();
    }

    public EnumCounters(StreamInput in, Class<E> enumClass) throws IOException {
        int size = in.readVInt();
        this.enums = (Enum[])enumClass.getEnumConstants();
        long[] vals = new long[this.enums.length];
        for (int i = 0; i < size; ++i) {
            long val = in.readVLong();
            if (i >= vals.length) continue;
            vals[i] = val;
        }
        this.counters = new AtomicLongArray(vals);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.counters.length());
        for (int i = 0; i < this.counters.length(); ++i) {
            out.writeVLong(this.counters.get(i));
        }
    }

    public void set(E name) {
        this.counters.set(((Enum)name).ordinal(), 0L);
    }

    public void inc(E name) {
        this.counters.incrementAndGet(((Enum)name).ordinal());
    }

    public void inc(E name, long count) {
        this.counters.addAndGet(((Enum)name).ordinal(), count);
    }

    public long get(E name) {
        return this.counters.get(((Enum)name).ordinal());
    }

    public long size() {
        return this.counters.length();
    }

    public boolean hasCounters() {
        return this.size() > 0L;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (E e : this.enums) {
            map.put(((Enum)e).name().toLowerCase(Locale.ROOT), this.counters.get(((Enum)e).ordinal()));
        }
        return map;
    }

    public static <E extends Enum<E>> EnumCounters<E> merge(Class<E> enumClass, List<EnumCounters<E>> counters) {
        EnumCounters<Enum> result = new EnumCounters<Enum>(enumClass);
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        for (EnumCounters<Enum> enumCounters : counters) {
            for (Enum e : enums) {
                result.inc(e, enumCounters.get(e));
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumCounters that = (EnumCounters)o;
        return Arrays.equals(this.toArray(), that.toArray()) && Arrays.equals(this.enums, that.enums);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.toArray());
        result = 31 * result + Arrays.hashCode(this.enums);
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        boolean first = true;
        for (E e : this.enums) {
            buf.append(((Enum)e).name().toLowerCase(Locale.ROOT)).append(": ").append(this.get(e));
            if (!first) continue;
            buf.append(", ");
            first = false;
        }
        buf.append("]");
        return buf.toString();
    }

    private long[] toArray() {
        long[] res = new long[this.enums.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.counters.get(i);
        }
        return res;
    }
}

