/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.deprecation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentLocation;

public class LoggingDeprecationAccumulationHandler
implements DeprecationHandler {
    private final List<String> deprecations = new ArrayList<String>();

    public void logRenamedField(String parserName, Supplier<XContentLocation> location, String oldName, String currentName) {
        LoggingDeprecationHandler.INSTANCE.logRenamedField(parserName, location, oldName, currentName);
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        this.deprecations.add(LoggerMessageFormat.format((String)"{}Deprecated field [{}] used, expected [{}] instead", (Object[])new Object[]{prefix, oldName, currentName}));
    }

    public void logReplacedField(String parserName, Supplier<XContentLocation> location, String oldName, String replacedName) {
        LoggingDeprecationHandler.INSTANCE.logReplacedField(parserName, location, oldName, replacedName);
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        this.deprecations.add(LoggerMessageFormat.format((String)"{}Deprecated field [{}] used, replaced by [{}]", (Object[])new Object[]{prefix, oldName, replacedName}));
    }

    public void logRemovedField(String parserName, Supplier<XContentLocation> location, String removedName) {
        LoggingDeprecationHandler.INSTANCE.logRemovedField(parserName, location, removedName);
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        this.deprecations.add(LoggerMessageFormat.format((String)"{}Deprecated field [{}] used, unused and will be removed entirely", (Object[])new Object[]{prefix, removedName}));
    }

    public List<String> getDeprecations() {
        return Collections.unmodifiableList(this.deprecations);
    }
}

