/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class Step {
    private final StepKey key;
    private final StepKey nextStepKey;

    public Step(StepKey key, StepKey nextStepKey) {
        this.key = key;
        this.nextStepKey = nextStepKey;
    }

    public final StepKey getKey() {
        return this.key;
    }

    public StepKey getNextStepKey() {
        return this.nextStepKey;
    }

    public abstract boolean isRetryable();

    public int hashCode() {
        return Objects.hash(this.key, this.nextStepKey);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Step other = (Step)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.nextStepKey, other.nextStepKey);
    }

    public String toString() {
        return this.key + " => " + this.nextStepKey;
    }

    public static final class StepKey
    implements Writeable,
    ToXContentObject {
        private final String phase;
        private final String action;
        private final String name;
        public static final ParseField PHASE_FIELD = new ParseField("phase", new String[0]);
        public static final ParseField ACTION_FIELD = new ParseField("action", new String[0]);
        public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
        private static final ConstructingObjectParser<StepKey, Void> PARSER = new ConstructingObjectParser("stepkey", a -> new StepKey((String)a[0], (String)a[1], (String)a[2]));

        public StepKey(String phase, String action, String name) {
            this.phase = phase;
            this.action = action;
            this.name = name;
        }

        public StepKey(StreamInput in) throws IOException {
            this.phase = in.readString();
            this.action = in.readString();
            this.name = in.readString();
        }

        public static StepKey parse(XContentParser parser) {
            return (StepKey)PARSER.apply(parser, null);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.phase);
            out.writeString(this.action);
            out.writeString(this.name);
        }

        public String getPhase() {
            return this.phase;
        }

        public String getAction() {
            return this.action;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.phase, this.action, this.name);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StepKey other = (StepKey)obj;
            return Objects.equals(this.phase, other.phase) && Objects.equals(this.action, other.action) && Objects.equals(this.name, other.name);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(PHASE_FIELD.getPreferredName(), this.phase);
            builder.field(ACTION_FIELD.getPreferredName(), this.action);
            builder.field(NAME_FIELD.getPreferredName(), this.name);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), PHASE_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ACTION_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        }
    }
}

