/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.allocation;

import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.xpack.core.ml.utils.MemoryTrackedTaskState;

public enum RoutingState implements MemoryTrackedTaskState
{
    STARTING,
    STARTED,
    STOPPING,
    FAILED,
    STOPPED;


    public static RoutingState fromString(String value) {
        return RoutingState.valueOf(value.toUpperCase(Locale.ROOT));
    }

    public boolean isNoneOf(RoutingState ... candidates) {
        return Arrays.stream(candidates).noneMatch(candidate -> this == candidate);
    }

    public boolean isAnyOf(RoutingState ... candidates) {
        return Arrays.stream(candidates).anyMatch(candidate -> this == candidate);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public boolean consumesMemory() {
        return this.isNoneOf(FAILED, STOPPED);
    }

    @Override
    public boolean isAllocating() {
        return this == STARTING;
    }
}

