/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class ApiKey
implements ToXContentObject,
Writeable {
    private final String name;
    private final String id;
    private final Instant creation;
    private final Instant expiration;
    private final boolean invalidated;
    private final String username;
    private final String realm;
    private final Map<String, Object> metadata;
    static final ConstructingObjectParser<ApiKey, Void> PARSER = new ConstructingObjectParser("api_key", args -> new ApiKey((String)args[0], (String)args[1], Instant.ofEpochMilli((Long)args[2]), args[3] == null ? null : Instant.ofEpochMilli((Long)args[3]), (Boolean)args[4], (String)args[5], (String)args[6], args[7] == null ? null : (Map)args[7]));

    public ApiKey(String name, String id, Instant creation, Instant expiration, boolean invalidated, String username, String realm, @Nullable Map<String, Object> metadata) {
        this.name = name;
        this.id = id;
        this.creation = Instant.ofEpochMilli(creation.toEpochMilli());
        this.expiration = expiration != null ? Instant.ofEpochMilli(expiration.toEpochMilli()) : null;
        this.invalidated = invalidated;
        this.username = username;
        this.realm = realm;
        this.metadata = metadata == null ? Map.of() : metadata;
    }

    public ApiKey(StreamInput in) throws IOException {
        this.name = in.getVersion().onOrAfter(Version.V_7_5_0) ? in.readOptionalString() : in.readString();
        this.id = in.readString();
        this.creation = in.readInstant();
        this.expiration = in.readOptionalInstant();
        this.invalidated = in.readBoolean();
        this.username = in.readString();
        this.realm = in.readString();
        this.metadata = in.getVersion().onOrAfter(Version.V_8_0_0) ? in.readMap() : Map.of();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Instant getCreation() {
        return this.creation;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealm() {
        return this.realm;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        return builder.endObject();
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("id", this.id).field("name", this.name).field("creation", this.creation.toEpochMilli());
        if (this.expiration != null) {
            builder.field("expiration", this.expiration.toEpochMilli());
        }
        builder.field("invalidated", this.invalidated).field("username", this.username).field("realm", this.realm).field("metadata", this.metadata == null ? Map.of() : this.metadata);
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
            out.writeOptionalString(this.name);
        } else {
            out.writeString(this.name);
        }
        out.writeString(this.id);
        out.writeInstant(this.creation);
        out.writeOptionalInstant(this.expiration);
        out.writeBoolean(this.invalidated);
        out.writeString(this.username);
        out.writeString(this.realm);
        if (out.getVersion().onOrAfter(Version.V_8_0_0)) {
            out.writeMap(this.metadata);
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.creation, this.expiration, this.invalidated, this.username, this.realm, this.metadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiKey other = (ApiKey)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.id, other.id) && Objects.equals(this.creation, other.creation) && Objects.equals(this.expiration, other.expiration) && Objects.equals(this.invalidated, other.invalidated) && Objects.equals(this.username, other.username) && Objects.equals(this.realm, other.realm) && Objects.equals(this.metadata, other.metadata);
    }

    public static ApiKey fromXContent(XContentParser parser) throws IOException {
        return (ApiKey)PARSER.parse(parser, null);
    }

    public String toString() {
        return "ApiKey [name=" + this.name + ", id=" + this.id + ", creation=" + this.creation + ", expiration=" + this.expiration + ", invalidated=" + this.invalidated + ", username=" + this.username + ", realm=" + this.realm + ", metadata=" + this.metadata + "]";
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("creation", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("invalidated", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("username", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("realm", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("metadata", new String[0]));
    }
}

