/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckExpectedIssuer
extends AbstractMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(CheckExpectedIssuer.class);
    @NonnullAfterInit
    private Function<MessageContext, String> issuerLookupStrategy;
    @NonnullAfterInit
    private Function<MessageContext, String> expectedIssuerLookupStrategy;

    public void setIssuerLookupStrategy(@Nonnull Function<MessageContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Message context issuer lookup strategy cannot be null");
    }

    public void setExpectedIssuerLookupStrategy(@Nonnull Function<MessageContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.expectedIssuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Message context expected issuer lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.issuerLookupStrategy == null) {
            throw new ComponentInitializationException("Message context issuer lookup strategy cannot be null");
        }
        if (this.expectedIssuerLookupStrategy == null) {
            throw new ComponentInitializationException("Message context expected issuer lookup strategy cannot be null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        String issuer = this.issuerLookupStrategy.apply(messageContext);
        if (issuer == null) {
            throw new MessageHandlerException("Message context did not contain an issuer");
        }
        String expectedIssuer = this.expectedIssuerLookupStrategy.apply(messageContext);
        if (expectedIssuer == null) {
            throw new MessageHandlerException("Message context did not contain an expected issuer");
        }
        this.log.debug("Saw issuer '{}', expected issuer '{}'", (Object)issuer, (Object)expectedIssuer);
        if (!Objects.equals(issuer, expectedIssuer)) {
            throw new MessageHandlerException("Message context issuer did not match expected issuer");
        }
    }
}

