/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule.support;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.Strings;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.DayTimes;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.Month;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.MonthTimes;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.Times;

public class YearTimes
implements Times {
    public static final EnumSet<Month> DEFAULT_MONTHS = EnumSet.of(Month.JANUARY);
    public static final int[] DEFAULT_DAYS = new int[]{1};
    public static final DayTimes[] DEFAULT_TIMES = new DayTimes[]{new DayTimes()};
    private final EnumSet<Month> months;
    private final int[] days;
    private final DayTimes[] times;

    public YearTimes() {
        this(DEFAULT_MONTHS, DEFAULT_DAYS, DEFAULT_TIMES);
    }

    public YearTimes(EnumSet<Month> months, int[] days, DayTimes[] times) {
        this.months = months.isEmpty() ? DEFAULT_MONTHS : months;
        this.days = days.length == 0 ? DEFAULT_DAYS : days;
        Arrays.sort(this.days);
        this.times = times.length == 0 ? DEFAULT_TIMES : times;
        this.validate();
    }

    void validate() {
        for (int day : this.days) {
            if (day >= 1 && day <= 32) continue;
            throw Exceptions.illegalArgument((String)"invalid month day [{}]", (Object[])new Object[]{day});
        }
        for (DayTimes dayTimes : this.times) {
            dayTimes.validate();
        }
    }

    public EnumSet<Month> months() {
        return this.months;
    }

    public int[] days() {
        return this.days;
    }

    public DayTimes[] times() {
        return this.times;
    }

    public Set<String> crons() {
        HashSet<String> crons = new HashSet<String>();
        for (DayTimes times : this.times) {
            String hrsStr = Strings.join(",", times.hour);
            String minsStr = Strings.join(",", times.minute);
            String daysStr = Strings.join(",", this.days);
            daysStr = daysStr.replace("32", "L");
            String monthsStr = org.elasticsearch.common.Strings.collectionToCommaDelimitedString(this.months);
            String expression = "0 " + minsStr + " " + hrsStr + " " + daysStr + " " + monthsStr + " ?";
            crons.add(expression);
        }
        return crons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YearTimes that = (YearTimes)o;
        return Arrays.equals(this.days, that.days) && this.months.equals(that.months) && Sets.newHashSet((Object[])this.times).equals(Sets.newHashSet((Object[])that.times));
    }

    public int hashCode() {
        int result = this.months.hashCode();
        result = 31 * result + Arrays.hashCode(this.days);
        result = 31 * result + Arrays.hashCode(this.times);
        return result;
    }

    public String toString() {
        return String.format(Locale.ROOT, "months [%s], days [%s], times [%s]", org.elasticsearch.common.Strings.collectionToCommaDelimitedString(this.months), Strings.join(",", this.days), org.elasticsearch.common.Strings.arrayToCommaDelimitedString((Object[])this.times));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MONTH_FIELD.getPreferredName(), this.months);
        builder.array(DAY_FIELD.getPreferredName(), this.days);
        builder.startArray(TIME_FIELD.getPreferredName());
        for (DayTimes dayTimes : this.times) {
            dayTimes.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static YearTimes parse(XContentParser parser, XContentParser.Token token) throws IOException, ElasticsearchParseException {
        DayTimes[] dayTimesArray;
        int[] days;
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse year times. expected an object, but found [{}]", new Object[]{token});
        }
        HashSet<Month> monthsSet = new HashSet<Month>();
        HashSet<Integer> daysSet = new HashSet<Integer>();
        HashSet<DayTimes> timesSet = new HashSet<DayTimes>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (MONTH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token.isValue()) {
                    monthsSet.add(YearTimes.parseMonthValue(parser, token));
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        monthsSet.add(YearTimes.parseMonthValue(parser, token));
                    }
                    continue;
                }
                throw new ElasticsearchParseException("invalid year month value for [{}] field. expected string/number value or an array of string/number values, but found [{}]", new Object[]{currentFieldName, token});
            }
            if (DAY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token.isValue()) {
                    daysSet.add(MonthTimes.parseDayValue(parser, token));
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        daysSet.add(MonthTimes.parseDayValue(parser, token));
                    }
                    continue;
                }
                throw new ElasticsearchParseException("invalid year day value for [{}] field. expected string/number value or an array of string/number values, but found [{}]", new Object[]{currentFieldName, token});
            }
            if (!TIME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) continue;
            if (token != XContentParser.Token.START_ARRAY) {
                try {
                    timesSet.add(DayTimes.parse(parser, token));
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("invalid time value for field [{}] - [{}]", (Throwable)pe, new Object[]{currentFieldName, token});
                }
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                try {
                    timesSet.add(DayTimes.parse(parser, token));
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("invalid time value for field [{}] - [{}]", (Throwable)pe, new Object[]{currentFieldName, token});
                }
            }
        }
        EnumSet<Month> months = monthsSet.isEmpty() ? DEFAULT_MONTHS : EnumSet.copyOf(monthsSet);
        int[] nArray = days = daysSet.isEmpty() ? DEFAULT_DAYS : CollectionUtils.toArray(daysSet);
        if (timesSet.isEmpty()) {
            DayTimes[] dayTimesArray2 = new DayTimes[1];
            dayTimesArray = dayTimesArray2;
            dayTimesArray2[0] = new DayTimes(0, 0);
        } else {
            dayTimesArray = timesSet.toArray(new DayTimes[timesSet.size()]);
        }
        DayTimes[] times = dayTimesArray;
        return new YearTimes(months, days, times);
    }

    static Month parseMonthValue(XContentParser parser, XContentParser.Token token) throws IOException {
        if (token == XContentParser.Token.VALUE_STRING) {
            return Month.resolve(parser.text());
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return Month.resolve(parser.intValue());
        }
        throw new ElasticsearchParseException("invalid year month value. expected a string or a number value, but found [{}]", new Object[]{token});
    }

    public static class Builder {
        private final Set<Month> months = new HashSet<Month>();
        private final Set<Integer> days = new HashSet<Integer>();
        private final Set<DayTimes> times = new HashSet<DayTimes>();

        private Builder() {
        }

        public Builder in(Month ... months) {
            Collections.addAll(this.months, months);
            return this;
        }

        public Builder on(int ... days) {
            Arrays.stream(days).forEach(this.days::add);
            return this;
        }

        public Builder at(int hour, int minute) {
            this.times.add(new DayTimes(hour, minute));
            return this;
        }

        public Builder atRoundHour(int ... hours) {
            this.times.add(new DayTimes(hours, new int[]{0}));
            return this;
        }

        public Builder atNoon() {
            this.times.add(DayTimes.NOON);
            return this;
        }

        public Builder atMidnight() {
            this.times.add(DayTimes.MIDNIGHT);
            return this;
        }

        public YearTimes build() {
            return new YearTimes(EnumSet.copyOf(this.months), CollectionUtils.toArray(this.days), this.times.toArray(new DayTimes[this.times.size()]));
        }
    }
}

