/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.rest;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.rollup.action.DeleteRollupJobAction;

public class RestDeleteRollupJobAction
extends BaseRestHandler {
    public static final ParseField ID = new ParseField("id", new String[0]);

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.DELETE, (String)"/_rollup/job/{id}").replaces(RestRequest.Method.DELETE, "/_xpack/rollup/job/{id}/", RestApiVersion.V_7).build());
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String id = restRequest.param(ID.getPreferredName());
        DeleteRollupJobAction.Request request = new DeleteRollupJobAction.Request(id);
        return channel -> client.execute((ActionType)DeleteRollupJobAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener<DeleteRollupJobAction.Response>(channel){

            protected RestStatus getStatus(DeleteRollupJobAction.Response response) {
                if (response.getNodeFailures().size() > 0 || response.getTaskFailures().size() > 0) {
                    return RestStatus.INTERNAL_SERVER_ERROR;
                }
                return RestStatus.OK;
            }
        });
    }

    public String getName() {
        return "delete_rollup_job";
    }
}

