/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.admin.cluster.settings.SettingsUpdater;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterUpdateSettingsAction
extends TransportMasterNodeAction<ClusterUpdateSettingsRequest, ClusterUpdateSettingsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterUpdateSettingsAction.class);
    private final AllocationService allocationService;
    private final ClusterSettings clusterSettings;

    @Inject
    public TransportClusterUpdateSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterSettings clusterSettings) {
        super("cluster:admin/settings/update", false, transportService, clusterService, threadPool, actionFilters, ClusterUpdateSettingsRequest::new, indexNameExpressionResolver, ClusterUpdateSettingsResponse::new, "same");
        this.allocationService = allocationService;
        this.clusterSettings = clusterSettings;
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterUpdateSettingsRequest request, ClusterState state) {
        HashSet<String> clearedBlockAndArchivedSettings = new HashSet<String>();
        if (this.checkClearedBlockAndArchivedSettings(request.transientSettings(), clearedBlockAndArchivedSettings) && this.checkClearedBlockAndArchivedSettings(request.persistentSettings(), clearedBlockAndArchivedSettings) && (clearedBlockAndArchivedSettings.contains(Metadata.SETTING_READ_ONLY_SETTING.getKey()) || clearedBlockAndArchivedSettings.contains(Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.getKey()))) {
            return null;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private boolean checkClearedBlockAndArchivedSettings(Settings settings, Set<String> clearedBlockAndArchivedSettings) {
        for (String key : settings.keySet()) {
            if (Metadata.SETTING_READ_ONLY_SETTING.getKey().equals(key)) {
                if (Metadata.SETTING_READ_ONLY_SETTING.get(settings).booleanValue()) {
                    return false;
                }
            } else if (Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.getKey().equals(key)) {
                if (Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(settings).booleanValue()) {
                    return false;
                }
            } else if (key.startsWith("archived.")) {
                if (settings.get(key) != null) {
                    return false;
                }
            } else {
                return false;
            }
            clearedBlockAndArchivedSettings.add(key);
        }
        return true;
    }

    @Override
    protected void masterOperation(Task task, final ClusterUpdateSettingsRequest request, ClusterState state, final ActionListener<ClusterUpdateSettingsResponse> listener) {
        final SettingsUpdater updater = new SettingsUpdater(this.clusterSettings);
        this.clusterService.submitStateUpdateTask("cluster_update_settings", new AckedClusterStateUpdateTask(Priority.IMMEDIATE, request, listener){
            private volatile boolean changed;
            {
                super(priority, request2, listener2);
                this.changed = false;
            }

            @Override
            protected ClusterUpdateSettingsResponse newResponse(boolean acknowledged) {
                return new ClusterUpdateSettingsResponse(acknowledged, updater.getTransientUpdates(), updater.getPersistentUpdate());
            }

            @Override
            public void onAllNodesAcked(@Nullable Exception e) {
                if (this.changed) {
                    this.reroute(true);
                } else {
                    super.onAllNodesAcked(e);
                }
            }

            @Override
            public void onAckTimeout() {
                if (this.changed) {
                    this.reroute(false);
                } else {
                    super.onAckTimeout();
                }
            }

            private void reroute(final boolean updateSettingsAcked) {
                if (!TransportClusterUpdateSettingsAction.this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
                    logger.debug("Skipping reroute after cluster update settings, because node is no longer master");
                    listener.onResponse(new ClusterUpdateSettingsResponse(updateSettingsAcked, updater.getTransientUpdates(), updater.getPersistentUpdate()));
                    return;
                }
                TransportClusterUpdateSettingsAction.this.clusterService.submitStateUpdateTask("reroute_after_cluster_update_settings", new AckedClusterStateUpdateTask(Priority.URGENT, request, listener){

                    @Override
                    public boolean mustAck(DiscoveryNode discoveryNode) {
                        return updateSettingsAcked;
                    }

                    @Override
                    protected ClusterUpdateSettingsResponse newResponse(boolean acknowledged) {
                        return new ClusterUpdateSettingsResponse(updateSettingsAcked && acknowledged, updater.getTransientUpdates(), updater.getPersistentUpdate());
                    }

                    @Override
                    public void onNoLongerMaster(String source) {
                        logger.debug("failed to preform reroute after cluster settings were updated - current node is no longer a master");
                        listener.onResponse(new ClusterUpdateSettingsResponse(updateSettingsAcked, updater.getTransientUpdates(), updater.getPersistentUpdate()));
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        logger.debug(() -> new ParameterizedMessage("failed to perform [{}]", (Object)source), (Throwable)e);
                        listener.onFailure(new ElasticsearchException("reroute after update settings failed", (Throwable)e, new Object[0]));
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        return TransportClusterUpdateSettingsAction.this.allocationService.reroute(currentState, "reroute after cluster update settings");
                    }
                });
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.debug(() -> new ParameterizedMessage("failed to perform [{}]", (Object)source), (Throwable)e);
                super.onFailure(source, e);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                ClusterState clusterState = updater.updateSettings(currentState, TransportClusterUpdateSettingsAction.this.clusterSettings.upgradeSettings(request.transientSettings()), TransportClusterUpdateSettingsAction.this.clusterSettings.upgradeSettings(request.persistentSettings()), logger);
                this.changed = clusterState != currentState;
                return clusterState;
            }
        });
    }
}

