/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFetcher;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesNodeRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesNodeResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.action.fieldcaps.RequestDispatcher;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportService;

public class TransportFieldCapabilitiesAction
extends HandledTransportAction<FieldCapabilitiesRequest, FieldCapabilitiesResponse> {
    public static final String ACTION_NODE_NAME = "indices:data/read/field_caps[n]";
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final FieldCapabilitiesFetcher fieldCapabilitiesFetcher;
    private final Predicate<String> metadataFieldPred;

    @Inject
    public TransportFieldCapabilitiesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndicesService indicesService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/field_caps", transportService, actionFilters, FieldCapabilitiesRequest::new);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.fieldCapabilitiesFetcher = new FieldCapabilitiesFetcher(indicesService);
        Set<String> metadataFields = indicesService.getAllMetadataFields();
        this.metadataFieldPred = metadataFields::contains;
        transportService.registerRequestHandler(ACTION_NODE_NAME, "search_coordination", FieldCapabilitiesNodeRequest::new, new NodeTransportHandler());
    }

    @Override
    protected void doExecute(Task task, FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        long nowInMillis = request.nowInMillis() == null ? System.currentTimeMillis() : request.nowInMillis();
        ClusterState clusterState = this.clusterService.state();
        Map<String, OriginalIndices> remoteClusterIndices = this.transportService.getRemoteClusterService().groupIndices(request.indicesOptions(), request.indices());
        OriginalIndices localIndices = remoteClusterIndices.remove("");
        String[] concreteIndices = localIndices == null ? Strings.EMPTY_ARRAY : this.indexNameExpressionResolver.concreteIndexNames(clusterState, localIndices);
        if (concreteIndices.length == 0 && remoteClusterIndices.isEmpty()) {
            listener.onResponse(new FieldCapabilitiesResponse(new String[0], Collections.emptyMap()));
            return;
        }
        this.checkIndexBlocks(clusterState, concreteIndices);
        Map<String, FieldCapabilitiesIndexResponse> indexResponses = Collections.synchronizedMap(new HashMap());
        FailureCollector indexFailures = new FailureCollector();
        CountDown completionCounter = new CountDown(1 + remoteClusterIndices.size());
        Runnable countDown = this.createResponseMerger(request, completionCounter, indexResponses, indexFailures, listener);
        RequestDispatcher requestDispatcher = new RequestDispatcher(this.clusterService, this.transportService, task, request, localIndices, nowInMillis, concreteIndices, this.threadPool.executor("search_coordination"), indexResponse -> indexResponses.putIfAbsent(indexResponse.getIndexName(), (FieldCapabilitiesIndexResponse)indexResponse), indexFailures::collect, countDown);
        requestDispatcher.execute();
        for (Map.Entry<String, OriginalIndices> remoteIndices : remoteClusterIndices.entrySet()) {
            String clusterAlias = remoteIndices.getKey();
            OriginalIndices originalIndices = remoteIndices.getValue();
            Client remoteClusterClient = this.transportService.getRemoteClusterService().getRemoteClusterClient(this.threadPool, clusterAlias);
            FieldCapabilitiesRequest remoteRequest = TransportFieldCapabilitiesAction.prepareRemoteRequest(request, originalIndices, nowInMillis);
            remoteClusterClient.fieldCaps(remoteRequest, ActionListener.wrap(response -> {
                for (FieldCapabilitiesIndexResponse resp : response.getIndexResponses()) {
                    String indexName = RemoteClusterAware.buildRemoteIndexName(clusterAlias, resp.getIndexName());
                    indexResponses.putIfAbsent(indexName, new FieldCapabilitiesIndexResponse(indexName, resp.get(), resp.canMatch()));
                }
                for (FieldCapabilitiesFailure failure : response.getFailures()) {
                    Exception ex = failure.getException();
                    indexFailures.collectRemoteException(ex, clusterAlias, failure.getIndices());
                }
                countDown.run();
            }, ex -> {
                indexFailures.collectRemoteException((Exception)ex, clusterAlias, originalIndices.indices());
                countDown.run();
            }));
        }
    }

    private void checkIndexBlocks(ClusterState clusterState, String[] concreteIndices) {
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        for (String index : concreteIndices) {
            clusterState.blocks().indexBlockedRaiseException(ClusterBlockLevel.READ, index);
        }
    }

    private Runnable createResponseMerger(FieldCapabilitiesRequest request, CountDown completionCounter, Map<String, FieldCapabilitiesIndexResponse> indexResponses, FailureCollector indexFailures, ActionListener<FieldCapabilitiesResponse> listener) {
        return () -> {
            if (completionCounter.countDown()) {
                List<FieldCapabilitiesFailure> failures = indexFailures.build(indexResponses.keySet());
                if (indexResponses.size() > 0) {
                    if (request.isMergeResults()) {
                        this.threadPool.executor("search_coordination").submit(ActionRunnable.supply(listener, () -> this.merge(indexResponses, request.includeUnmapped(), new ArrayList<FieldCapabilitiesFailure>(failures))));
                    } else {
                        listener.onResponse(new FieldCapabilitiesResponse(new ArrayList<FieldCapabilitiesIndexResponse>(indexResponses.values()), new ArrayList<FieldCapabilitiesFailure>(failures)));
                    }
                } else if (!indexFailures.isEmpty()) {
                    listener.onFailure(failures.iterator().next().getException());
                } else {
                    listener.onResponse(new FieldCapabilitiesResponse(Collections.emptyList(), Collections.emptyList()));
                }
            }
        };
    }

    private static FieldCapabilitiesRequest prepareRemoteRequest(FieldCapabilitiesRequest request, OriginalIndices originalIndices, long nowInMillis) {
        FieldCapabilitiesRequest remoteRequest = new FieldCapabilitiesRequest();
        remoteRequest.setMergeResults(false);
        remoteRequest.indicesOptions(originalIndices.indicesOptions());
        remoteRequest.indices(originalIndices.indices());
        remoteRequest.fields(request.fields());
        remoteRequest.runtimeFields(request.runtimeFields());
        remoteRequest.indexFilter(request.indexFilter());
        remoteRequest.nowInMillis(nowInMillis);
        return remoteRequest;
    }

    private FieldCapabilitiesResponse merge(Map<String, FieldCapabilitiesIndexResponse> indexResponses, boolean includeUnmapped, List<FieldCapabilitiesFailure> failures) {
        String[] indices = (String[])indexResponses.keySet().stream().sorted().toArray(String[]::new);
        HashMap<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder = new HashMap<String, Map<String, FieldCapabilities.Builder>>();
        for (FieldCapabilitiesIndexResponse response : indexResponses.values()) {
            this.innerMerge(responseMapBuilder, response);
        }
        HashMap responseMap = new HashMap();
        for (Map.Entry entry : responseMapBuilder.entrySet()) {
            Map typeMapBuilder = (Map)entry.getValue();
            if (includeUnmapped) {
                this.addUnmappedFields(indices, (String)entry.getKey(), typeMapBuilder);
            }
            boolean multiTypes = typeMapBuilder.size() > 1;
            HashMap<String, FieldCapabilities> typeMap = new HashMap<String, FieldCapabilities>();
            for (Map.Entry fieldEntry : typeMapBuilder.entrySet()) {
                typeMap.put((String)fieldEntry.getKey(), ((FieldCapabilities.Builder)fieldEntry.getValue()).build(multiTypes));
            }
            responseMap.put((String)entry.getKey(), Collections.unmodifiableMap(typeMap));
        }
        return new FieldCapabilitiesResponse(indices, Collections.unmodifiableMap(responseMap), failures);
    }

    private void addUnmappedFields(String[] indices, String field, Map<String, FieldCapabilities.Builder> typeMap) {
        HashSet<String> unmappedIndices = new HashSet<String>(Arrays.asList(indices));
        typeMap.values().forEach(b -> b.getIndices().forEach(unmappedIndices::remove));
        if (!unmappedIndices.isEmpty()) {
            FieldCapabilities.Builder unmapped = new FieldCapabilities.Builder(field, "unmapped");
            typeMap.put("unmapped", unmapped);
            for (String index : unmappedIndices) {
                unmapped.add(index, false, false, false, false, null, Collections.emptyMap());
            }
        }
    }

    private void innerMerge(Map<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder, FieldCapabilitiesIndexResponse response) {
        for (Map.Entry<String, IndexFieldCapabilities> entry : response.get().entrySet()) {
            String field = entry.getKey();
            boolean isMetadataField = response.getOriginVersion().onOrAfter(Version.V_7_13_0) ? entry.getValue().isMetadatafield() : this.metadataFieldPred.test(field);
            IndexFieldCapabilities fieldCap = entry.getValue();
            Map typeMap = responseMapBuilder.computeIfAbsent(field, f -> new HashMap());
            FieldCapabilities.Builder builder = typeMap.computeIfAbsent(fieldCap.getType(), key -> new FieldCapabilities.Builder(field, (String)key));
            builder.add(response.getIndexName(), isMetadataField, fieldCap.isSearchable(), fieldCap.isAggregatable(), fieldCap.isDimension(), fieldCap.getMetricType(), fieldCap.meta());
        }
    }

    private class NodeTransportHandler
    implements TransportRequestHandler<FieldCapabilitiesNodeRequest> {
        private NodeTransportHandler() {
        }

        @Override
        public void messageReceived(FieldCapabilitiesNodeRequest request, TransportChannel channel, Task task) throws Exception {
            ChannelActionListener listener = new ChannelActionListener(channel, TransportFieldCapabilitiesAction.ACTION_NODE_NAME, request);
            ActionListener.completeWith(listener, () -> {
                ArrayList<FieldCapabilitiesIndexResponse> allResponses = new ArrayList<FieldCapabilitiesIndexResponse>();
                HashMap<ShardId, Exception> allFailures = new HashMap<ShardId, Exception>();
                HashSet<ShardId> allUnmatchedShardIds = new HashSet<ShardId>();
                Map<String, List<ShardId>> groupedShardIds = request.shardIds().stream().collect(Collectors.groupingBy(ShardId::getIndexName));
                for (List<ShardId> shardIds : groupedShardIds.values()) {
                    HashMap<ShardId, Exception> failures = new HashMap<ShardId, Exception>();
                    HashSet<ShardId> unmatched = new HashSet<ShardId>();
                    for (ShardId shardId : shardIds) {
                        try {
                            FieldCapabilitiesIndexResponse response = TransportFieldCapabilitiesAction.this.fieldCapabilitiesFetcher.fetch(shardId, request.fields(), request.indexFilter(), request.nowInMillis(), request.runtimeFields());
                            if (response.canMatch()) {
                                unmatched.clear();
                                failures.clear();
                                allResponses.add(response);
                                break;
                            }
                            unmatched.add(shardId);
                        }
                        catch (Exception e) {
                            failures.put(shardId, e);
                        }
                    }
                    allUnmatchedShardIds.addAll(unmatched);
                    allFailures.putAll(failures);
                }
                return new FieldCapabilitiesNodeResponse(allResponses, allFailures, allUnmatchedShardIds);
            });
        }
    }

    private static final class FailureCollector {
        private final Map<String, Exception> failuresByIndex = Collections.synchronizedMap(new HashMap());

        private FailureCollector() {
        }

        List<FieldCapabilitiesFailure> build(Set<String> successfulIndices) {
            Map<Tuple, FieldCapabilitiesFailure> indexFailures = Collections.synchronizedMap(new HashMap());
            for (Map.Entry<String, Exception> failure : this.failuresByIndex.entrySet()) {
                String index = failure.getKey();
                Exception e = failure.getValue();
                if (successfulIndices.contains(index)) continue;
                Throwable cause = ExceptionsHelper.unwrapCause(e);
                Tuple groupingKey = new Tuple((Object)cause.getMessage(), (Object)cause.getClass().getName());
                indexFailures.compute(groupingKey, (k, v) -> v == null ? new FieldCapabilitiesFailure(new String[]{index}, e) : v.addIndex(index));
            }
            return new ArrayList<FieldCapabilitiesFailure>(indexFailures.values());
        }

        void collect(String index, Exception e) {
            this.failuresByIndex.putIfAbsent(index, e);
        }

        void collectRemoteException(Exception ex, String clusterAlias, String[] remoteIndices) {
            for (String failedIndex : remoteIndices) {
                this.collect(RemoteClusterAware.buildRemoteIndexName(clusterAlias, failedIndex), ex);
            }
        }

        boolean isEmpty() {
            return this.failuresByIndex.isEmpty();
        }
    }
}

