/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.IntConsumer;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.Murmur3HashFunction;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.support.filtering.FilterPath;

public abstract class IndexRouting {
    private final int routingNumShards;
    private final int routingFactor;

    public static IndexRouting fromIndexMetadata(IndexMetadata indexMetadata) {
        if (!indexMetadata.getRoutingPaths().isEmpty()) {
            if (indexMetadata.isRoutingPartitionedIndex()) {
                throw new IllegalArgumentException("routing_partition_size is incompatible with routing_path");
            }
            return new ExtractFromSource(indexMetadata.getRoutingNumShards(), indexMetadata.getRoutingFactor(), indexMetadata.getIndex().getName(), indexMetadata.getRoutingPaths());
        }
        if (indexMetadata.isRoutingPartitionedIndex()) {
            return new Partitioned(indexMetadata.getRoutingNumShards(), indexMetadata.getRoutingFactor(), indexMetadata.getRoutingPartitionSize());
        }
        return new Unpartitioned(indexMetadata.getRoutingNumShards(), indexMetadata.getRoutingFactor());
    }

    private IndexRouting(int routingNumShards, int routingFactor) {
        this.routingNumShards = routingNumShards;
        this.routingFactor = routingFactor;
    }

    public abstract int indexShard(String var1, @Nullable String var2, XContentType var3, BytesReference var4);

    public abstract int updateShard(String var1, @Nullable String var2);

    public abstract int deleteShard(String var1, @Nullable String var2);

    public abstract int getShard(String var1, @Nullable String var2);

    public abstract void collectSearchShards(String var1, IntConsumer var2);

    protected final int hashToShardId(int hash) {
        return Math.floorMod(hash, this.routingNumShards) / this.routingFactor;
    }

    private static int effectiveRoutingToHash(String effectiveRouting) {
        return Murmur3HashFunction.hash(effectiveRouting);
    }

    private static class ExtractFromSource
    extends IndexRouting {
        private final String indexName;
        private final FilterPath[] include;

        ExtractFromSource(int routingNumShards, int routingFactor, String indexName, List<String> routingPaths) {
            super(routingNumShards, routingFactor);
            this.indexName = indexName;
            this.include = FilterPath.compile(Set.copyOf(routingPaths));
        }

        @Override
        public int indexShard(String id, @Nullable String routing, XContentType sourceType, BytesReference source) {
            int n;
            block11: {
                if (routing != null) {
                    throw new IllegalArgumentException(this.error("indexing with a specified routing"));
                }
                assert (Transports.assertNotTransportThread("parsing the _source can get slow"));
                XContentParser parser = sourceType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)source.streamInput(), this.include, null);
                try {
                    parser.nextToken();
                    if (parser.currentToken() == null) {
                        throw new IllegalArgumentException("Error extracting routing: source didn't contain any routing fields");
                    }
                    int hash = ExtractFromSource.extractObject(parser);
                    XContentParserUtils.ensureExpectedToken(null, parser.nextToken(), parser);
                    n = this.hashToShardId(hash);
                    if (parser == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ParsingException e) {
                        throw new IllegalArgumentException("Error extracting routing: " + e.getMessage(), e);
                    }
                }
                parser.close();
            }
            return n;
        }

        private static int extractObject(XContentParser source) throws IOException {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, source.nextToken(), source);
            String firstFieldName = source.currentName();
            source.nextToken();
            int firstHash = ExtractFromSource.extractItem(source);
            if (source.currentToken() == XContentParser.Token.END_OBJECT) {
                return Murmur3HashFunction.hash(firstFieldName) ^ firstHash;
            }
            ArrayList<NameAndHash> hashes = new ArrayList<NameAndHash>();
            hashes.add(new NameAndHash(firstFieldName, firstHash));
            do {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, source.currentToken(), source);
                String fieldName = source.currentName();
                source.nextToken();
                hashes.add(new NameAndHash(fieldName, ExtractFromSource.extractItem(source)));
            } while (source.currentToken() != XContentParser.Token.END_OBJECT);
            Collections.sort(hashes, Comparator.comparing(nameAndHash -> nameAndHash.name));
            int hash = 0;
            for (NameAndHash nameAndHash2 : hashes) {
                int thisHash = Murmur3HashFunction.hash(nameAndHash2.name) ^ nameAndHash2.hash;
                hash = 31 * hash + thisHash;
            }
            return hash;
        }

        private static int extractItem(XContentParser source) throws IOException {
            if (source.currentToken() == XContentParser.Token.START_OBJECT) {
                int hash = ExtractFromSource.extractObject(source);
                source.nextToken();
                return hash;
            }
            if (source.currentToken() == XContentParser.Token.VALUE_STRING) {
                int hash = Murmur3HashFunction.hash(source.text());
                source.nextToken();
                return hash;
            }
            throw new ParsingException(source.getTokenLocation(), "Routing values must be strings but found [{}]", source.currentToken());
        }

        @Override
        public int updateShard(String id, @Nullable String routing) {
            throw new IllegalArgumentException(this.error("update"));
        }

        @Override
        public int deleteShard(String id, @Nullable String routing) {
            throw new IllegalArgumentException(this.error("delete"));
        }

        @Override
        public int getShard(String id, @Nullable String routing) {
            throw new IllegalArgumentException(this.error("get"));
        }

        @Override
        public void collectSearchShards(String routing, IntConsumer consumer) {
            throw new IllegalArgumentException(this.error("searching with a specified routing"));
        }

        private String error(String operation) {
            return operation + " is not supported because the destination index [" + this.indexName + "] is in time series mode";
        }
    }

    private static class Partitioned
    extends IdAndRoutingOnly {
        private final int routingPartitionSize;

        Partitioned(int routingNumShards, int routingFactor, int routingPartitionSize) {
            super(routingNumShards, routingFactor);
            this.routingPartitionSize = routingPartitionSize;
        }

        @Override
        protected int shardId(String id, @Nullable String routing) {
            if (routing == null) {
                throw new IllegalArgumentException("A routing value is required for gets from a partitioned index");
            }
            int offset = Math.floorMod(IndexRouting.effectiveRoutingToHash(id), this.routingPartitionSize);
            return this.hashToShardId(IndexRouting.effectiveRoutingToHash(routing) + offset);
        }

        @Override
        public void collectSearchShards(String routing, IntConsumer consumer) {
            int hash = IndexRouting.effectiveRoutingToHash(routing);
            for (int i = 0; i < this.routingPartitionSize; ++i) {
                consumer.accept(this.hashToShardId(hash + i));
            }
        }
    }

    private static class Unpartitioned
    extends IdAndRoutingOnly {
        Unpartitioned(int routingNumShards, int routingFactor) {
            super(routingNumShards, routingFactor);
        }

        @Override
        protected int shardId(String id, @Nullable String routing) {
            return this.hashToShardId(IndexRouting.effectiveRoutingToHash(routing == null ? id : routing));
        }

        @Override
        public void collectSearchShards(String routing, IntConsumer consumer) {
            consumer.accept(this.hashToShardId(IndexRouting.effectiveRoutingToHash(routing)));
        }
    }

    private static class NameAndHash {
        private final String name;
        private final int hash;

        NameAndHash(String name, int hash) {
            this.name = name;
            this.hash = hash;
        }
    }

    private static abstract class IdAndRoutingOnly
    extends IndexRouting {
        IdAndRoutingOnly(int routingNumShards, int routingFactor) {
            super(routingNumShards, routingFactor);
        }

        protected abstract int shardId(String var1, @Nullable String var2);

        @Override
        public int indexShard(String id, @Nullable String routing, XContentType sourceType, BytesReference source) {
            return this.shardId(id, routing);
        }

        @Override
        public int updateShard(String id, @Nullable String routing) {
            return this.shardId(id, routing);
        }

        @Override
        public int deleteShard(String id, @Nullable String routing) {
            return this.shardId(id, routing);
        }

        @Override
        public int getShard(String id, @Nullable String routing) {
            return this.shardId(id, routing);
        }
    }
}

