/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Nullable;

public class BlobPath {
    public static final BlobPath EMPTY = new BlobPath(Collections.emptyList());
    private static final String SEPARATOR = "/";
    private final List<String> paths;

    private BlobPath(List<String> paths) {
        this.paths = paths;
    }

    public List<String> parts() {
        return this.paths;
    }

    public BlobPath add(String path) {
        return new BlobPath(CollectionUtils.appendToCopy(this.paths, path));
    }

    public String buildAsString() {
        String p = String.join((CharSequence)SEPARATOR, this.paths);
        if (p.isEmpty() || p.endsWith(SEPARATOR)) {
            return p;
        }
        return p + SEPARATOR;
    }

    @Nullable
    public BlobPath parent() {
        int size = this.paths.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return EMPTY;
            }
        }
        return new BlobPath(List.copyOf(this.paths.subList(0, size - 1)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String path : this.paths) {
            sb.append('[').append(path).append(']');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlobPath other = (BlobPath)o;
        return this.paths.equals(other.paths);
    }

    public int hashCode() {
        return Objects.hash(this.paths);
    }
}

