/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.coordination.PeersResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.ConfiguredHostsResolver;
import org.elasticsearch.discovery.PeersRequest;
import org.elasticsearch.discovery.ProbeConnectionResult;
import org.elasticsearch.discovery.TransportAddressConnector;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public abstract class PeerFinder {
    private static final Logger logger = LogManager.getLogger(PeerFinder.class);
    public static final String REQUEST_PEERS_ACTION_NAME = "internal:discovery/request_peers";
    public static final Setting<TimeValue> DISCOVERY_FIND_PEERS_INTERVAL_SETTING = Setting.timeSetting("discovery.find_peers_interval", TimeValue.timeValueMillis((long)1000L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> DISCOVERY_REQUEST_PEERS_TIMEOUT_SETTING = Setting.timeSetting("discovery.request_peers_timeout", TimeValue.timeValueMillis((long)3000L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> VERBOSITY_INCREASE_TIMEOUT_SETTING = Setting.timeSetting("discovery.find_peers_warning_timeout", TimeValue.timeValueMinutes((long)5L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    private final TimeValue findPeersInterval;
    private final TimeValue requestPeersTimeout;
    private final TimeValue verbosityIncreaseTimeout;
    private final Object mutex = new Object();
    private final TransportService transportService;
    private final TransportAddressConnector transportAddressConnector;
    private final ConfiguredHostsResolver configuredHostsResolver;
    private volatile long currentTerm;
    private boolean active;
    private long activatedAtMillis;
    private DiscoveryNodes lastAcceptedNodes;
    private final Map<TransportAddress, Peer> peersByAddress = new LinkedHashMap<TransportAddress, Peer>();
    private Optional<DiscoveryNode> leader = Optional.empty();
    private volatile List<TransportAddress> lastResolvedAddresses = Collections.emptyList();

    public PeerFinder(Settings settings, TransportService transportService, TransportAddressConnector transportAddressConnector, ConfiguredHostsResolver configuredHostsResolver) {
        this.findPeersInterval = DISCOVERY_FIND_PEERS_INTERVAL_SETTING.get(settings);
        this.requestPeersTimeout = DISCOVERY_REQUEST_PEERS_TIMEOUT_SETTING.get(settings);
        this.verbosityIncreaseTimeout = VERBOSITY_INCREASE_TIMEOUT_SETTING.get(settings);
        this.transportService = transportService;
        this.transportAddressConnector = transportAddressConnector;
        this.configuredHostsResolver = configuredHostsResolver;
        transportService.registerRequestHandler(REQUEST_PEERS_ACTION_NAME, "generic", false, false, PeersRequest::new, (request, channel, task) -> channel.sendResponse(this.handlePeersRequest((PeersRequest)request)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(DiscoveryNodes lastAcceptedNodes) {
        logger.trace("activating with {}", (Object)lastAcceptedNodes);
        Object object = this.mutex;
        synchronized (object) {
            assert (this.assertInactiveWithNoKnownPeers());
            this.active = true;
            this.activatedAtMillis = this.transportService.getThreadPool().relativeTimeInMillis();
            this.lastAcceptedNodes = lastAcceptedNodes;
            this.leader = Optional.empty();
            this.handleWakeUp();
        }
        this.onFoundPeersUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(DiscoveryNode leader) {
        boolean peersRemoved;
        List connectionReferences;
        Object object = this.mutex;
        synchronized (object) {
            logger.trace("deactivating and setting leader to {}", (Object)leader);
            this.active = false;
            connectionReferences = this.peersByAddress.values().stream().map(Peer::getConnectionReference).collect(Collectors.toList());
            peersRemoved = this.handleWakeUp();
            this.leader = Optional.of(leader);
            assert (this.assertInactiveWithNoKnownPeers());
        }
        if (peersRemoved) {
            this.onFoundPeersUpdated();
        }
        assert (peersRemoved || connectionReferences.isEmpty()) : connectionReferences;
        Releasables.close(connectionReferences);
    }

    protected final boolean holdsLock() {
        return Thread.holdsLock(this.mutex);
    }

    private boolean assertInactiveWithNoKnownPeers() {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        assert (!this.active);
        assert (this.peersByAddress.isEmpty()) : this.peersByAddress.keySet();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeersResponse handlePeersRequest(PeersRequest peersRequest) {
        Object object = this.mutex;
        synchronized (object) {
            List<DiscoveryNode> knownPeers;
            assert (!peersRequest.getSourceNode().equals(this.getLocalNode()));
            if (this.active) {
                assert (!this.leader.isPresent()) : this.leader;
                if (peersRequest.getSourceNode().isMasterNode()) {
                    this.startProbe(peersRequest.getSourceNode().getAddress());
                }
                peersRequest.getKnownPeers().stream().map(DiscoveryNode::getAddress).forEach(this::startProbe);
                knownPeers = this.getFoundPeersUnderLock();
            } else {
                assert (this.leader.isPresent() || this.lastAcceptedNodes == null);
                knownPeers = Collections.emptyList();
            }
            return new PeersResponse(this.leader, knownPeers, this.currentTerm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<DiscoveryNode> getLeader() {
        Object object = this.mutex;
        synchronized (object) {
            return this.leader;
        }
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    public void setCurrentTerm(long currentTerm) {
        this.currentTerm = currentTerm;
    }

    private DiscoveryNode getLocalNode() {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        assert (localNode != null);
        return localNode;
    }

    protected abstract void onActiveMasterFound(DiscoveryNode var1, long var2);

    protected abstract void onFoundPeersUpdated();

    public List<TransportAddress> getLastResolvedAddresses() {
        return this.lastResolvedAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<DiscoveryNode> getFoundPeers() {
        Object object = this.mutex;
        synchronized (object) {
            return this.getFoundPeersUnderLock();
        }
    }

    private List<DiscoveryNode> getFoundPeersUnderLock() {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        return this.peersByAddress.values().stream().map(Peer::getDiscoveryNode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private boolean handleWakeUp() {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        boolean peersRemoved = this.peersByAddress.values().removeIf(Peer::handleWakeUp);
        if (!this.active) {
            logger.trace("not active");
            return peersRemoved;
        }
        logger.trace("probing master nodes from cluster state: {}", (Object)this.lastAcceptedNodes);
        for (DiscoveryNode discoveryNode : this.lastAcceptedNodes.getMasterNodes().values()) {
            this.startProbe(discoveryNode.getAddress());
        }
        this.configuredHostsResolver.resolveConfiguredHosts(providedAddresses -> {
            Object object = this.mutex;
            synchronized (object) {
                this.lastResolvedAddresses = providedAddresses;
                logger.trace("probing resolved transport addresses {}", providedAddresses);
                providedAddresses.forEach(this::startProbe);
            }
        });
        this.transportService.getThreadPool().scheduleUnlessShuttingDown(this.findPeersInterval, "generic", new AbstractRunnable(){

            @Override
            public boolean isForceExecution() {
                return true;
            }

            @Override
            public void onFailure(Exception e) {
                assert (false) : e;
                logger.debug("unexpected exception in wakeup", (Throwable)e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doRun() {
                Object object = PeerFinder.this.mutex;
                synchronized (object) {
                    if (!PeerFinder.this.handleWakeUp()) {
                        return;
                    }
                }
                PeerFinder.this.onFoundPeersUpdated();
            }

            public String toString() {
                return "PeerFinder handling wakeup";
            }
        });
        return peersRemoved;
    }

    protected void startProbe(TransportAddress transportAddress) {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        if (!this.active) {
            logger.trace("startProbe({}) not running", (Object)transportAddress);
            return;
        }
        if (transportAddress.equals(this.getLocalNode().getAddress())) {
            logger.trace("startProbe({}) not probing local node", (Object)transportAddress);
            return;
        }
        if (!this.peersByAddress.containsKey(transportAddress)) {
            Peer peer = new Peer(transportAddress);
            this.peersByAddress.put(transportAddress, peer);
            peer.establishConnection();
        }
    }

    private class Peer {
        private final TransportAddress transportAddress;
        private final SetOnce<ProbeConnectionResult> probeConnectionResult = new SetOnce();
        private volatile boolean peersRequestInFlight;

        Peer(TransportAddress transportAddress) {
            this.transportAddress = transportAddress;
        }

        @Nullable
        DiscoveryNode getDiscoveryNode() {
            return Optional.ofNullable((ProbeConnectionResult)this.probeConnectionResult.get()).map(ProbeConnectionResult::getDiscoveryNode).orElse(null);
        }

        private boolean isActive() {
            return PeerFinder.this.active && PeerFinder.this.peersByAddress.get(this.transportAddress) == this;
        }

        boolean handleWakeUp() {
            assert (PeerFinder.this.holdsLock()) : "PeerFinder mutex not held";
            if (!this.isActive()) {
                return true;
            }
            DiscoveryNode discoveryNode = this.getDiscoveryNode();
            if (discoveryNode != null) {
                if (PeerFinder.this.transportService.nodeConnected(discoveryNode)) {
                    if (!this.peersRequestInFlight) {
                        this.requestPeers();
                    }
                } else {
                    logger.trace("{} no longer connected", (Object)this);
                    return true;
                }
            }
            return false;
        }

        void establishConnection() {
            assert (PeerFinder.this.holdsLock()) : "PeerFinder mutex not held";
            assert (this.getDiscoveryNode() == null) : "unexpectedly connected to " + this.getDiscoveryNode();
            assert (this.isActive());
            final boolean verboseFailureLogging = PeerFinder.this.transportService.getThreadPool().relativeTimeInMillis() - PeerFinder.this.activatedAtMillis > PeerFinder.this.verbosityIncreaseTimeout.millis();
            logger.trace("{} attempting connection", (Object)this);
            PeerFinder.this.transportAddressConnector.connectToRemoteMasterNode(this.transportAddress, new ActionListener<ProbeConnectionResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(ProbeConnectionResult connectResult) {
                    assert (!PeerFinder.this.holdsLock()) : "PeerFinder mutex is held in error";
                    DiscoveryNode remoteNode = connectResult.getDiscoveryNode();
                    assert (remoteNode.isMasterNode()) : remoteNode + " is not master-eligible";
                    assert (!remoteNode.equals(PeerFinder.this.getLocalNode())) : remoteNode + " is the local node";
                    boolean retainConnection = false;
                    try {
                        Object object = PeerFinder.this.mutex;
                        synchronized (object) {
                            block13: {
                                if (Peer.this.isActive()) break block13;
                                return;
                            }
                            assert (Peer.this.probeConnectionResult.get() == null) : "connection result unexpectedly already set to " + Peer.this.probeConnectionResult.get();
                            Peer.this.probeConnectionResult.set((Object)connectResult);
                            Peer.this.requestPeers();
                        }
                        PeerFinder.this.onFoundPeersUpdated();
                        retainConnection = true;
                    }
                    finally {
                        if (!retainConnection) {
                            Releasables.close((Releasable)connectResult);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Exception e) {
                    if (verboseFailureLogging) {
                        if (logger.isDebugEnabled()) {
                            logger.warn((Message)new ParameterizedMessage("{} connection failed", (Object)Peer.this), (Throwable)e);
                        } else {
                            StringBuilder messageBuilder = new StringBuilder();
                            for (Throwable cause = e; cause != null && messageBuilder.length() <= 1024; cause = cause.getCause()) {
                                messageBuilder.append(": ").append(cause.getMessage());
                            }
                            String message = messageBuilder.length() < 1024 ? messageBuilder.toString() : messageBuilder.substring(0, 1023) + "...";
                            logger.warn("{} connection failed{}", (Object)Peer.this, (Object)message);
                        }
                    } else {
                        logger.debug((Message)new ParameterizedMessage("{} connection failed", (Object)Peer.this), (Throwable)e);
                    }
                    Object object = PeerFinder.this.mutex;
                    synchronized (object) {
                        assert (Peer.this.probeConnectionResult.get() == null) : "discoveryNode unexpectedly already set to " + Peer.this.probeConnectionResult.get();
                        if (Peer.this.isActive()) {
                            PeerFinder.this.peersByAddress.remove(Peer.this.transportAddress);
                        }
                    }
                }
            });
        }

        private void requestPeers() {
            assert (PeerFinder.this.holdsLock()) : "PeerFinder mutex not held";
            assert (!this.peersRequestInFlight) : "PeersRequest already in flight";
            assert (this.isActive());
            final DiscoveryNode discoveryNode = this.getDiscoveryNode();
            assert (discoveryNode != null) : "cannot request peers without first connecting";
            if (discoveryNode.equals(PeerFinder.this.getLocalNode())) {
                logger.trace("{} not requesting peers from local node", (Object)this);
                return;
            }
            logger.trace("{} requesting peers", (Object)this);
            this.peersRequestInFlight = true;
            List<DiscoveryNode> knownNodes = PeerFinder.this.getFoundPeersUnderLock();
            TransportResponseHandler<PeersResponse> peersResponseHandler = new TransportResponseHandler<PeersResponse>(){

                @Override
                public PeersResponse read(StreamInput in) throws IOException {
                    return new PeersResponse(in);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleResponse(PeersResponse response) {
                    logger.trace("{} received {}", (Object)Peer.this, (Object)response);
                    Object object = PeerFinder.this.mutex;
                    synchronized (object) {
                        if (!Peer.this.isActive()) {
                            return;
                        }
                        Peer.this.peersRequestInFlight = false;
                        response.getMasterNode().map(DiscoveryNode::getAddress).ifPresent(PeerFinder.this::startProbe);
                        response.getKnownPeers().stream().map(DiscoveryNode::getAddress).forEach(PeerFinder.this::startProbe);
                    }
                    if (response.getMasterNode().equals(Optional.of(discoveryNode))) {
                        assert (!PeerFinder.this.holdsLock()) : "PeerFinder mutex is held in error";
                        PeerFinder.this.onActiveMasterFound(discoveryNode, response.getTerm());
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    Peer.this.peersRequestInFlight = false;
                    logger.warn((Message)new ParameterizedMessage("{} peers request failed", (Object)Peer.this), (Throwable)exp);
                }

                @Override
                public String executor() {
                    return "generic";
                }
            };
            PeerFinder.this.transportService.sendRequest(discoveryNode, PeerFinder.REQUEST_PEERS_ACTION_NAME, (TransportRequest)new PeersRequest(PeerFinder.this.getLocalNode(), knownNodes), TransportRequestOptions.timeout(PeerFinder.this.requestPeersTimeout), peersResponseHandler);
        }

        @Nullable
        Releasable getConnectionReference() {
            assert (PeerFinder.this.holdsLock()) : "PeerFinder mutex not held";
            return (Releasable)this.probeConnectionResult.get();
        }

        public String toString() {
            return "address [" + this.transportAddress + "], node [" + this.getDiscoveryNode() + "], requesting [" + this.peersRequestInFlight + "]";
        }
    }
}

