/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class MetaStateService {
    private static final Logger logger = LogManager.getLogger(MetaStateService.class);
    public final NodeEnvironment nodeEnv;
    public final NamedXContentRegistry namedXContentRegistry;

    public MetaStateService(NodeEnvironment nodeEnv, NamedXContentRegistry namedXContentRegistry) {
        this.nodeEnv = nodeEnv;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public Tuple<Manifest, Metadata> loadFullState() throws IOException {
        Metadata.Builder metadataBuilder;
        Manifest manifest = Manifest.FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        if (manifest == null) {
            return this.loadFullStateBWC();
        }
        if (manifest.isGlobalGenerationMissing()) {
            metadataBuilder = Metadata.builder();
        } else {
            Metadata globalMetadata = Metadata.FORMAT.loadGeneration(logger, this.namedXContentRegistry, manifest.getGlobalGeneration(), this.nodeEnv.nodeDataPaths());
            if (globalMetadata != null) {
                metadataBuilder = Metadata.builder(globalMetadata);
            } else {
                throw new IOException("failed to find global metadata [generation: " + manifest.getGlobalGeneration() + "]");
            }
        }
        for (Map.Entry<Index, Long> entry : manifest.getIndexGenerations().entrySet()) {
            String indexFolderName;
            Index index = entry.getKey();
            long generation = entry.getValue();
            IndexMetadata indexMetadata = IndexMetadata.FORMAT.loadGeneration(logger, this.namedXContentRegistry, generation, this.nodeEnv.resolveIndexFolder(indexFolderName = index.getUUID()));
            if (indexMetadata != null) {
                metadataBuilder.put(indexMetadata, false);
                continue;
            }
            throw new IOException("failed to find metadata for existing index " + index.getName() + " [location: " + indexFolderName + ", generation: " + generation + "]");
        }
        return new Tuple((Object)manifest, (Object)metadataBuilder.build());
    }

    private Tuple<Manifest, Metadata> loadFullStateBWC() throws IOException {
        IndexGraveyard indexGraveyard;
        Metadata.Builder metadataBuilder;
        HashMap<Index, Long> indices = new HashMap<Index, Long>();
        Tuple<Metadata, Long> metadataAndGeneration = Metadata.FORMAT.loadLatestStateWithGeneration(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        Metadata globalMetadata = (Metadata)metadataAndGeneration.v1();
        long globalStateGeneration = (Long)metadataAndGeneration.v2();
        if (globalMetadata != null) {
            metadataBuilder = Metadata.builder(globalMetadata);
            indexGraveyard = (IndexGraveyard)globalMetadata.custom("index-graveyard");
        } else {
            metadataBuilder = Metadata.builder();
            indexGraveyard = IndexGraveyard.builder().build();
        }
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            Tuple<IndexMetadata, Long> indexMetadataAndGeneration = IndexMetadata.FORMAT.loadLatestStateWithGeneration(logger, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            IndexMetadata indexMetadata = (IndexMetadata)indexMetadataAndGeneration.v1();
            long generation = (Long)indexMetadataAndGeneration.v2();
            if (indexMetadata != null) {
                if (indexGraveyard.containsIndex(indexMetadata.getIndex())) {
                    logger.debug("[{}] found metadata for deleted index [{}]", (Object)indexFolderName, (Object)indexMetadata.getIndex());
                    continue;
                }
                indices.put(indexMetadata.getIndex(), generation);
                metadataBuilder.put(indexMetadata, false);
                continue;
            }
            logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        Manifest manifest = Manifest.unknownCurrentTermAndVersion(globalStateGeneration, indices);
        return new Tuple((Object)manifest, (Object)metadataBuilder.build());
    }

    @Nullable
    public IndexMetadata loadIndexState(Index index) throws IOException {
        return IndexMetadata.FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.indexPaths(index));
    }

    List<IndexMetadata> loadIndicesStates(Predicate<String> excludeIndexPathIdsPredicate) throws IOException {
        ArrayList<IndexMetadata> indexMetadataList = new ArrayList<IndexMetadata>();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders(excludeIndexPathIdsPredicate)) {
            assert (!excludeIndexPathIdsPredicate.test(indexFolderName)) : "unexpected folder " + indexFolderName + " which should have been excluded";
            IndexMetadata indexMetadata = IndexMetadata.FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            if (indexMetadata != null) {
                String indexPathId = indexMetadata.getIndex().getUUID();
                if (indexFolderName.equals(indexPathId)) {
                    indexMetadataList.add(indexMetadata);
                    continue;
                }
                throw new IllegalStateException("[" + indexFolderName + "] invalid index folder name, rename to [" + indexPathId + "]");
            }
            logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        return indexMetadataList;
    }

    Metadata loadGlobalState() throws IOException {
        return Metadata.FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
    }

    public void unreferenceAll() throws IOException {
        Manifest.FORMAT.writeAndCleanup(Manifest.empty(), this.nodeEnv.nodeDataPaths());
        Metadata.FORMAT.cleanupOldFiles(Long.MAX_VALUE, this.nodeEnv.nodeDataPaths());
    }

    public void deleteAll() throws IOException {
        this.unreferenceAll();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            MetadataStateFormat.deleteMetaState(this.nodeEnv.resolveIndexFolder(indexFolderName));
        }
        Manifest.FORMAT.cleanupOldFiles(Long.MAX_VALUE, this.nodeEnv.nodeDataPaths());
    }
}

