/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.ReloadableCustomAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String SINGLE_MAPPING_NAME = "_doc";
    public static final String TYPE_FIELD_NAME = "_type";
    public static final Setting<Long> INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_fields.limit", 50L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_objects.limit", 10000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.total_fields.limit", 1000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_DEPTH_LIMIT_SETTING = Setting.longSetting("index.mapping.depth.limit", 20L, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING = Setting.longSetting("index.mapping.field_name_length.limit", Long.MAX_VALUE, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_DIMENSION_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.dimension_fields.limit", 16L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private final IndexAnalyzers indexAnalyzers;
    private final MappingParser mappingParser;
    private final DocumentParser documentParser;
    private final Version indexVersionCreated;
    private final MapperRegistry mapperRegistry;
    private final Supplier<MappingParserContext> parserContextSupplier;
    private volatile DocumentMapper mapper;

    public MapperService(IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, NamedXContentRegistry xContentRegistry, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<SearchExecutionContext> searchExecutionContextSupplier, BooleanSupplier idFieldDataEnabled, ScriptCompiler scriptCompiler) {
        super(indexSettings);
        this.indexVersionCreated = indexSettings.getIndexVersionCreated();
        this.indexAnalyzers = indexAnalyzers;
        this.mapperRegistry = mapperRegistry;
        Function<DateFormatter, MappingParserContext> parserContextFunction = dateFormatter -> new MappingParserContext(similarityService::getSimilarity, mapperRegistry.getMapperParsers()::get, mapperRegistry.getRuntimeFieldParsers()::get, this.indexVersionCreated, searchExecutionContextSupplier, (DateFormatter)dateFormatter, scriptCompiler, indexAnalyzers, indexSettings, idFieldDataEnabled);
        this.documentParser = new DocumentParser(xContentRegistry, dateFormatter -> new MappingParserContext.DynamicTemplateParserContext((MappingParserContext)parserContextFunction.apply((DateFormatter)dateFormatter)), indexSettings, indexAnalyzers);
        Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = mapperRegistry.getMetadataMapperParsers(indexSettings.getIndexVersionCreated());
        this.parserContextSupplier = () -> (MappingParserContext)parserContextFunction.apply(null);
        this.mappingParser = new MappingParser(this.parserContextSupplier, metadataMapperParsers, this::getMetadataMappers, this::resolveDocumentType);
    }

    public boolean hasNested() {
        return this.mappingLookup().hasNested();
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public NamedAnalyzer getNamedAnalyzer(String analyzerName) {
        return this.indexAnalyzers.get(analyzerName);
    }

    public MappingParserContext parserContext() {
        return this.parserContextSupplier.get();
    }

    public DocumentParser documentParser() {
        return this.documentParser;
    }

    Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> getMetadataMappers() {
        DocumentMapper existingMapper = this.mapper;
        Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = this.mapperRegistry.getMetadataMapperParsers(this.indexSettings.getIndexVersionCreated());
        LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        if (existingMapper == null) {
            for (MetadataFieldMapper.TypeParser parser : metadataMapperParsers.values()) {
                MetadataFieldMapper metadataFieldMapper = parser.getDefault(this.parserContext());
                metadataMappers.put(metadataFieldMapper.getClass(), metadataFieldMapper);
            }
        } else {
            metadataMappers.putAll(existingMapper.mapping().getMetadataMappersMap());
        }
        return metadataMappers;
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, String mappingSource) throws IOException {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mappingSource);){
            Map map = parser.map();
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) throws IOException {
        assert (newIndexMetadata.getIndex().equals(this.index())) : "index mismatch: expected " + this.index() + " but was " + newIndexMetadata.getIndex();
        if (currentIndexMetadata != null && currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
            assert (this.assertNoUpdateRequired(newIndexMetadata));
            return;
        }
        MappingMetadata newMappingMetadata = newIndexMetadata.mapping();
        if (newMappingMetadata != null) {
            String op;
            DocumentMapper previousMapper;
            String type = newMappingMetadata.type();
            CompressedXContent incomingMappingSource = newMappingMetadata.source();
            Mapping incomingMapping = this.parseMapping(type, incomingMappingSource);
            MapperService mapperService = this;
            synchronized (mapperService) {
                previousMapper = this.mapper;
                assert (this.assertRefreshIsNotNeeded(previousMapper, type, incomingMapping));
                this.mapper = this.newDocumentMapper(incomingMapping, MergeReason.MAPPING_RECOVERY);
            }
            String string = op = previousMapper != null ? "updated" : "added";
            if (this.logger.isDebugEnabled() && incomingMappingSource.compressed().length < 512) {
                this.logger.debug("[{}] {} mapping, source [{}]", (Object)this.index(), (Object)op, (Object)incomingMappingSource.string());
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] {} mapping, source [{}]", (Object)this.index(), (Object)op, (Object)incomingMappingSource.string());
            } else {
                this.logger.debug("[{}] {} mapping (source suppressed due to length, use TRACE level if needed)", (Object)this.index(), (Object)op);
            }
        }
    }

    private boolean assertRefreshIsNotNeeded(DocumentMapper currentMapper, String type, Mapping incomingMapping) {
        CompressedXContent incomingMappingSource;
        CompressedXContent mergedMappingSource;
        Mapping mergedMapping = MapperService.mergeMappings(currentMapper, incomingMapping, MergeReason.MAPPING_RECOVERY);
        ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("skip_runtime", "true"));
        try {
            mergedMappingSource = new CompressedXContent((ToXContent)mergedMapping, XContentType.JSON, (ToXContent.Params)params);
        }
        catch (Exception e) {
            throw new AssertionError("failed to serialize source for type [" + type + "]", e);
        }
        try {
            incomingMappingSource = new CompressedXContent((ToXContent)incomingMapping, XContentType.JSON, (ToXContent.Params)params);
        }
        catch (Exception e) {
            throw new AssertionError("failed to serialize source for type [" + type + "]", e);
        }
        assert (mergedMappingSource.equals(incomingMappingSource)) : "[" + this.index() + "] parsed mapping, and got different sources\nincoming:\n" + incomingMappingSource + "\nmerged:\n" + mergedMappingSource;
        return true;
    }

    boolean assertNoUpdateRequired(IndexMetadata newIndexMetadata) {
        MappingMetadata mapping = newIndexMetadata.mapping();
        if (mapping != null) {
            CompressedXContent newSource;
            Mapping newMapping = this.parseMapping(mapping.type(), mapping.source());
            CompressedXContent currentSource = this.mapper.mappingSource();
            if (!Objects.equals(currentSource, newSource = newMapping.toCompressedXContent())) {
                throw new IllegalStateException("expected current mapping [" + currentSource + "] to be the same as new mapping [" + newSource + "]");
            }
        }
        return true;
    }

    public void merge(String type, Map<String, Object> mappings, MergeReason reason) throws IOException {
        CompressedXContent content = new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(mappings)));
        this.mergeAndApplyMappings(type, content, reason);
    }

    public void merge(IndexMetadata indexMetadata, MergeReason reason) {
        assert (reason != MergeReason.MAPPING_UPDATE_PREFLIGHT);
        MappingMetadata mappingMetadata = indexMetadata.mapping();
        if (mappingMetadata != null) {
            this.mergeAndApplyMappings(mappingMetadata.type(), mappingMetadata.source(), reason);
        }
    }

    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason) {
        return this.mergeAndApplyMappings(type, mappingSource, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentMapper mergeAndApplyMappings(String mappingType, CompressedXContent mappingSource, MergeReason reason) {
        DocumentMapper currentMapper = this.mapper;
        if (currentMapper != null && currentMapper.mappingSource().equals(mappingSource)) {
            return currentMapper;
        }
        MapperService mapperService = this;
        synchronized (mapperService) {
            Mapping incomingMapping = this.parseMapping(mappingType, mappingSource);
            Mapping mapping = MapperService.mergeMappings(this.mapper, incomingMapping, reason);
            DocumentMapper newMapper = this.newDocumentMapper(mapping, reason);
            if (reason == MergeReason.MAPPING_UPDATE_PREFLIGHT) {
                return newMapper;
            }
            this.mapper = newMapper;
            assert (this.assertSerialization(newMapper));
            return newMapper;
        }
    }

    private DocumentMapper newDocumentMapper(Mapping mapping, MergeReason reason) {
        DocumentMapper newMapper = new DocumentMapper(this.documentParser, mapping);
        newMapper.mapping().getRoot().fixRedundantIncludes();
        newMapper.validate(this.indexSettings, reason != MergeReason.MAPPING_RECOVERY);
        return newMapper;
    }

    public Mapping parseMapping(String mappingType, CompressedXContent mappingSource) {
        try {
            return this.mappingParser.parse(mappingType, mappingSource);
        }
        catch (Exception e) {
            throw new MapperParsingException("Failed to parse mapping: {}", (Throwable)e, e.getMessage());
        }
    }

    public static Mapping mergeMappings(DocumentMapper currentMapper, Mapping incomingMapping, MergeReason reason) {
        Mapping newMapping = currentMapper == null ? incomingMapping : currentMapper.mapping().merge(incomingMapping, reason);
        return newMapping;
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        Mapping newMapping = this.parseMapping(mapper.type(), mappingSource);
        if (!newMapping.toCompressedXContent().equals(mappingSource)) {
            throw new IllegalStateException("Mapping serialization result is different from source. \n--> Source [" + mappingSource + "]\n--> Result [" + newMapping.toCompressedXContent() + "]");
        }
        return true;
    }

    public DocumentMapper documentMapper() {
        return this.mapper;
    }

    public static boolean isMappingSourceTyped(String type, Map<String, Object> mapping) {
        return mapping.size() == 1 && mapping.keySet().iterator().next().equals(type);
    }

    private String resolveDocumentType(String type) {
        if (SINGLE_MAPPING_NAME.equals(type) && this.mapper != null) {
            return this.mapper.type();
        }
        return type;
    }

    public MappedFieldType fieldType(String fullName) {
        return this.mappingLookup().fieldTypesLookup().get(fullName);
    }

    public MappingLookup mappingLookup() {
        DocumentMapper mapper = this.mapper;
        return mapper == null ? MappingLookup.EMPTY : mapper.mappers();
    }

    public Iterable<MappedFieldType> getEagerGlobalOrdinalsFields() {
        DocumentMapper mapper = this.mapper;
        if (mapper == null) {
            return Collections.emptySet();
        }
        MappingLookup mappingLookup = mapper.mappers();
        return mappingLookup.getMatchingFieldNames("*").stream().map(mappingLookup::getFieldType).filter(MappedFieldType::eagerGlobalOrdinals).collect(Collectors.toList());
    }

    public NamedAnalyzer indexAnalyzer(String field, Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
        return this.mappingLookup().indexAnalyzer(field, unindexedFieldAnalyzer);
    }

    @Override
    public void close() throws IOException {
        this.indexAnalyzers.close();
    }

    @Deprecated
    public static boolean isMetadataFieldStatic(String fieldName) {
        if (IndicesModule.getBuiltInMetadataFields().contains(fieldName)) {
            return true;
        }
        return fieldName.equals("_size");
    }

    public boolean isMetadataField(String field) {
        return this.mapperRegistry.getMetadataMapperParsers(this.indexVersionCreated).containsKey(field);
    }

    public synchronized List<String> reloadSearchAnalyzers(AnalysisRegistry registry) throws IOException {
        this.logger.info("reloading search analyzers");
        Map<String, TokenizerFactory> tokenizerFactories = registry.buildTokenizerFactories(this.indexSettings);
        Map<String, CharFilterFactory> charFilterFactories = registry.buildCharFilterFactories(this.indexSettings);
        Map<String, TokenFilterFactory> tokenFilterFactories = registry.buildTokenFilterFactories(this.indexSettings);
        Map<String, Settings> settings = this.indexSettings.getSettings().getGroups("index.analysis.analyzer");
        ArrayList<String> reloadedAnalyzers = new ArrayList<String>();
        for (NamedAnalyzer namedAnalyzer : this.indexAnalyzers.getAnalyzers().values()) {
            if (!(namedAnalyzer.analyzer() instanceof ReloadableCustomAnalyzer)) continue;
            ReloadableCustomAnalyzer analyzer = (ReloadableCustomAnalyzer)namedAnalyzer.analyzer();
            String analyzerName = namedAnalyzer.name();
            Settings analyzerSettings = settings.get(analyzerName);
            analyzer.reload(analyzerName, analyzerSettings, tokenizerFactories, charFilterFactories, tokenFilterFactories);
            reloadedAnalyzers.add(analyzerName);
        }
        return reloadedAnalyzers;
    }

    public static enum MergeReason {
        MAPPING_UPDATE_PREFLIGHT,
        MAPPING_UPDATE,
        INDEX_TEMPLATE,
        MAPPING_RECOVERY;

    }
}

