/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.lucene.util.CombinedBitSet;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.internal.CancellableBulkScorer;
import org.elasticsearch.search.internal.ExitableDirectoryReader;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.ProfileWeight;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.profile.query.QueryTimingType;

public class ContextIndexSearcher
extends IndexSearcher
implements Releasable {
    private static int CHECK_CANCELLED_SCORER_INTERVAL = 2048;
    private AggregatedDfs aggregatedDfs;
    private QueryProfiler profiler;
    private MutableQueryTimeout cancellable;

    public ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, boolean wrapWithExitableDirectoryReader) throws IOException {
        this(reader, similarity, queryCache, queryCachingPolicy, new MutableQueryTimeout(), wrapWithExitableDirectoryReader);
    }

    private ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, MutableQueryTimeout cancellable, boolean wrapWithExitableDirectoryReader) throws IOException {
        super((IndexReader)(wrapWithExitableDirectoryReader ? new ExitableDirectoryReader((DirectoryReader)reader, cancellable) : reader));
        this.setSimilarity(similarity);
        this.setQueryCache(queryCache);
        this.setQueryCachingPolicy(queryCachingPolicy);
        this.cancellable = cancellable;
    }

    public void setProfiler(QueryProfiler profiler) {
        this.profiler = profiler;
    }

    public Runnable addQueryCancellation(Runnable action) {
        return this.cancellable.add(action);
    }

    public void removeQueryCancellation(Runnable action) {
        this.cancellable.remove(action);
    }

    public void close() {
        this.cancellable.clear();
    }

    public boolean hasCancellations() {
        return this.cancellable.isEnabled();
    }

    public void setAggregatedDfs(AggregatedDfs aggregatedDfs) {
        this.aggregatedDfs = aggregatedDfs;
    }

    public Query rewrite(Query original) throws IOException {
        if (this.profiler != null) {
            this.profiler.startRewriteTime();
        }
        try {
            Query query = super.rewrite(original);
            return query;
        }
        finally {
            if (this.profiler != null) {
                this.profiler.stopAndAddRewriteTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        if (this.profiler != null) {
            Weight weight;
            QueryProfileBreakdown profile = (QueryProfileBreakdown)this.profiler.getQueryBreakdown(query);
            Timer timer = profile.getTimer(QueryTimingType.CREATE_WEIGHT);
            timer.start();
            try {
                weight = query.createWeight((IndexSearcher)this, scoreMode, boost);
            }
            finally {
                timer.stop();
                this.profiler.pollLastElement();
            }
            return new ProfileWeight(query, weight, profile);
        }
        return super.createWeight(query, scoreMode, boost);
    }

    public void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        for (LeafReaderContext ctx : leaves) {
            this.searchLeaf(ctx, weight, collector);
        }
    }

    private void searchLeaf(LeafReaderContext ctx, Weight weight, Collector collector) throws IOException {
        LeafCollector leafCollector;
        this.cancellable.checkCancelled();
        weight = this.wrapWeight(weight);
        try {
            leafCollector = collector.getLeafCollector(ctx);
        }
        catch (CollectionTerminatedException e) {
            return;
        }
        Bits liveDocs = ctx.reader().getLiveDocs();
        BitSet liveDocsBitSet = ContextIndexSearcher.getSparseBitSetOrNull(liveDocs);
        if (liveDocsBitSet == null) {
            BulkScorer bulkScorer = weight.bulkScorer(ctx);
            if (bulkScorer != null) {
                try {
                    bulkScorer.score(leafCollector, liveDocs);
                }
                catch (CollectionTerminatedException collectionTerminatedException) {}
            }
        } else {
            Scorer scorer = weight.scorer(ctx);
            if (scorer != null) {
                try {
                    ContextIndexSearcher.intersectScorerAndBitSet(scorer, liveDocsBitSet, leafCollector, this.cancellable.isEnabled() ? this.cancellable::checkCancelled : () -> {});
                }
                catch (CollectionTerminatedException collectionTerminatedException) {
                    // empty catch block
                }
            }
        }
    }

    private Weight wrapWeight(final Weight weight) {
        if (this.cancellable.isEnabled()) {
            return new Weight(weight.getQuery()){

                public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    throw new UnsupportedOperationException();
                }

                public Scorer scorer(LeafReaderContext context) throws IOException {
                    return weight.scorer(context);
                }

                public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                    BulkScorer in = weight.bulkScorer(context);
                    if (in != null) {
                        return new CancellableBulkScorer(in, ContextIndexSearcher.this.cancellable::checkCancelled);
                    }
                    return null;
                }
            };
        }
        return weight;
    }

    private static BitSet getSparseBitSetOrNull(Bits liveDocs) {
        if (liveDocs instanceof SparseFixedBitSet) {
            return (BitSet)liveDocs;
        }
        if (liveDocs instanceof CombinedBitSet && ((CombinedBitSet)liveDocs).getFirst() instanceof SparseFixedBitSet) {
            return (BitSet)liveDocs;
        }
        return null;
    }

    static void intersectScorerAndBitSet(Scorer scorer, BitSet acceptDocs, LeafCollector collector, Runnable checkCancelled) throws IOException {
        collector.setScorer((Scorable)scorer);
        DocIdSetIterator iterator = ConjunctionUtils.intersectIterators(Arrays.asList(new BitSetIterator(acceptDocs, (long)acceptDocs.approximateCardinality()), scorer.iterator()));
        int seen = 0;
        checkCancelled.run();
        int docId = iterator.nextDoc();
        while (docId < Integer.MAX_VALUE) {
            if (++seen % CHECK_CANCELLED_SCORER_INTERVAL == 0) {
                checkCancelled.run();
            }
            collector.collect(docId);
            docId = iterator.nextDoc();
        }
        checkCancelled.run();
    }

    public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.termStatistics(term, docFreq, totalTermFreq);
        }
        TermStatistics termStatistics = (TermStatistics)this.aggregatedDfs.termStatistics().get((Object)term);
        if (termStatistics == null) {
            return super.termStatistics(term, docFreq, totalTermFreq);
        }
        return termStatistics;
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.collectionStatistics(field);
        }
        CollectionStatistics collectionStatistics = (CollectionStatistics)this.aggregatedDfs.fieldStatistics().get((Object)field);
        if (collectionStatistics == null) {
            return super.collectionStatistics(field);
        }
        return collectionStatistics;
    }

    public DirectoryReader getDirectoryReader() {
        IndexReader reader = this.getIndexReader();
        assert (reader instanceof DirectoryReader) : "expected an instance of DirectoryReader, got " + reader.getClass();
        return (DirectoryReader)reader;
    }

    private static class MutableQueryTimeout
    implements ExitableDirectoryReader.QueryCancellation {
        private final Set<Runnable> runnables = new HashSet<Runnable>();

        private MutableQueryTimeout() {
        }

        private Runnable add(Runnable action) {
            Objects.requireNonNull(action, "cancellation runnable should not be null");
            if (!this.runnables.add(action)) {
                throw new IllegalArgumentException("Cancellation runnable already added");
            }
            return action;
        }

        private void remove(Runnable action) {
            this.runnables.remove(action);
        }

        @Override
        public void checkCancelled() {
            for (Runnable timeout : this.runnables) {
                timeout.run();
            }
        }

        @Override
        public boolean isEnabled() {
            return !this.runnables.isEmpty();
        }

        public void clear() {
            this.runnables.clear();
        }
    }
}

