/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.upgrades;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.migration.TransportGetFeatureUpgradeStatusAction;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.ShardsAcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.upgrades.MigrationResultsUpdateTask;
import org.elasticsearch.upgrades.SingleFeatureMigrationResult;
import org.elasticsearch.upgrades.SystemIndexMigrationInfo;
import org.elasticsearch.upgrades.SystemIndexMigrationTaskParams;
import org.elasticsearch.upgrades.SystemIndexMigrationTaskState;
import org.elasticsearch.xcontent.ToXContent;

public class SystemIndexMigrator
extends AllocatedPersistentTask {
    private static final Logger logger = LogManager.getLogger(SystemIndexMigrator.class);
    private static final Version READY_FOR_MIGRATION_VERSION = Version.V_7_16_0;
    private final ParentTaskAssigningClient baseClient;
    private final ClusterService clusterService;
    private final SystemIndices systemIndices;
    private final MetadataUpdateSettingsService metadataUpdateSettingsService;
    private final MetadataCreateIndexService metadataCreateIndexService;
    private final IndexScopedSettings indexScopedSettings;
    private final Queue<SystemIndexMigrationInfo> migrationQueue = new LinkedList<SystemIndexMigrationInfo>();
    private final AtomicReference<Map<String, Object>> currentFeatureCallbackMetadata = new AtomicReference();

    public SystemIndexMigrator(Client client, long id, String type, String action, TaskId parentTask, SystemIndexMigrationTaskParams params, Map<String, String> headers, ClusterService clusterService, SystemIndices systemIndices, MetadataUpdateSettingsService metadataUpdateSettingsService, MetadataCreateIndexService metadataCreateIndexService, IndexScopedSettings indexScopedSettings) {
        super(id, type, action, "system-index-migrator", parentTask, headers);
        this.baseClient = new ParentTaskAssigningClient(client, parentTask);
        this.clusterService = clusterService;
        this.systemIndices = systemIndices;
        this.metadataUpdateSettingsService = metadataUpdateSettingsService;
        this.metadataCreateIndexService = metadataCreateIndexService;
        this.indexScopedSettings = indexScopedSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SystemIndexMigrationTaskState taskState) {
        String stateFeatureName;
        String stateIndexName;
        ClusterState clusterState = this.clusterService.state();
        if (taskState != null) {
            this.currentFeatureCallbackMetadata.set(taskState.getFeatureCallbackMetadata());
            stateIndexName = taskState.getCurrentIndex();
            stateFeatureName = taskState.getCurrentFeature();
            SystemIndices.Feature feature2 = this.systemIndices.getFeatures().get(stateFeatureName);
            if (feature2 == null) {
                this.markAsFailed(new IllegalStateException("cannot migrate feature [" + stateFeatureName + "] because that feature is not installed on this node"));
                return;
            }
            if (stateIndexName != null && !clusterState.metadata().hasIndex(stateIndexName)) {
                this.markAsFailed(new IndexNotFoundException(stateIndexName, "cannot migrate because that index does not exist"));
                return;
            }
        } else {
            stateIndexName = null;
            stateFeatureName = null;
        }
        Queue<SystemIndexMigrationInfo> queue = this.migrationQueue;
        synchronized (queue) {
            if (!this.migrationQueue.isEmpty() && taskState == null) {
                this.markAsFailed(new IllegalStateException("migration is already in progress, cannot start new migration"));
                return;
            }
            this.systemIndices.getFeatures().values().stream().flatMap(feature -> SystemIndexMigrationInfo.fromFeature(feature, clusterState.metadata(), this.indexScopedSettings)).filter(migrationInfo -> this.needsToBeMigrated(clusterState.metadata().index(migrationInfo.getCurrentIndexName()))).sorted().collect(Collectors.toCollection(() -> this.migrationQueue));
            List closedIndices = this.migrationQueue.stream().filter(SystemIndexMigrationInfo::isCurrentIndexClosed).map(SystemIndexMigrationInfo::getCurrentIndexName).collect(Collectors.toList());
            if (!closedIndices.isEmpty()) {
                this.markAsFailed(new IllegalStateException(new ParameterizedMessage("indices must be open to be migrated, but indices {} are closed", closedIndices).getFormattedMessage()));
                return;
            }
            if (stateIndexName != null && stateFeatureName != null && !this.migrationQueue.isEmpty()) {
                SystemIndexMigrationInfo nextMigrationInfo = this.migrationQueue.peek();
                assert (nextMigrationInfo.getFeatureName().equals(stateFeatureName) && nextMigrationInfo.getCurrentIndexName().equals(stateIndexName)) : "index name [" + stateIndexName + "] or feature name [" + stateFeatureName + "] from task state did not match first index [" + nextMigrationInfo.getCurrentIndexName() + "] and feature [" + nextMigrationInfo.getFeatureName() + "] of locally computed queue, see logs";
                if (!nextMigrationInfo.getCurrentIndexName().equals(stateIndexName)) {
                    if (!clusterState.metadata().hasIndex(stateIndexName)) {
                        this.markAsFailed(new IllegalStateException(new ParameterizedMessage("failed to resume system index migration from index [{}], that index is not present in the cluster", (Object)stateIndexName).getFormattedMessage()));
                    }
                    logger.warn((Message)new ParameterizedMessage("resuming system index migration with index [{}], which does not match index given in last task state [{}]", (Object)nextMigrationInfo.getCurrentIndexName(), (Object)stateIndexName));
                }
            }
        }
        this.cleanUpPreviousMigration(taskState, clusterState, state -> this.prepareNextIndex((ClusterState)state, state2 -> this.migrateSingleIndex((ClusterState)state2, this::finishIndexAndLoop), stateFeatureName));
    }

    private void cleanUpPreviousMigration(SystemIndexMigrationTaskState taskState, ClusterState currentState, Consumer<ClusterState> listener) {
        logger.debug("cleaning up previous migration, task state: [{}]", (Object)(taskState == null ? "null" : Strings.toString((ToXContent)taskState)));
        if (taskState != null && taskState.getCurrentIndex() != null) {
            SystemIndexMigrationInfo migrationInfo;
            try {
                migrationInfo = SystemIndexMigrationInfo.fromTaskState(taskState, this.systemIndices, currentState.metadata(), this.indexScopedSettings);
            }
            catch (Exception e) {
                this.markAsFailed(e);
                return;
            }
            String newIndexName = migrationInfo.getNextIndexName();
            logger.info("removing index [{}] from previous incomplete migration", (Object)newIndexName);
            migrationInfo.createClient(this.baseClient).admin().indices().prepareDelete(newIndexName).execute(ActionListener.wrap(ackedResponse -> {
                if (ackedResponse.isAcknowledged()) {
                    logger.debug("successfully removed index [{}]", (Object)newIndexName);
                    SystemIndexMigrator.clearResults(this.clusterService, ActionListener.wrap(listener::accept, this::markAsFailed));
                }
            }, this::markAsFailed));
        } else {
            logger.debug("no incomplete index to remove");
            SystemIndexMigrator.clearResults(this.clusterService, ActionListener.wrap(listener::accept, this::markAsFailed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishIndexAndLoop(BulkByScrollResponse bulkResponse) {
        assert (!(bulkResponse.isTimedOut() || bulkResponse.getBulkFailures() != null && !bulkResponse.getBulkFailures().isEmpty() || bulkResponse.getSearchFailures() != null && !bulkResponse.getSearchFailures().isEmpty())) : "If this assertion gets triggered it means the validation in migrateSingleIndex isn't working right";
        SystemIndexMigrationInfo lastMigrationInfo = this.currentMigrationInfo();
        logger.info("finished migrating old index [{}] from feature [{}] to new index [{}]", (Object)lastMigrationInfo.getCurrentIndexName(), (Object)lastMigrationInfo.getFeatureName(), (Object)lastMigrationInfo.getNextIndexName());
        assert (this.migrationQueue != null && !this.migrationQueue.isEmpty());
        Queue<SystemIndexMigrationInfo> queue = this.migrationQueue;
        synchronized (queue) {
            this.migrationQueue.remove();
        }
        SystemIndexMigrationInfo nextMigrationInfo = this.currentMigrationInfo();
        if (nextMigrationInfo == null || !nextMigrationInfo.getFeatureName().equals(lastMigrationInfo.getFeatureName())) {
            lastMigrationInfo.indicesMigrationComplete(this.currentFeatureCallbackMetadata.get(), this.clusterService, this.baseClient, ActionListener.wrap(successful -> {
                if (!successful.booleanValue()) {
                    logger.warn("post-migration hook for feature [{}] indicated failure; feature migration metadata prior to failure was [{}]", (Object)lastMigrationInfo.getFeatureName(), this.currentFeatureCallbackMetadata.get());
                }
                this.recordIndexMigrationSuccess(lastMigrationInfo);
            }, this::markAsFailed));
        } else {
            this.prepareNextIndex(this.clusterService.state(), state2 -> this.migrateSingleIndex((ClusterState)state2, this::finishIndexAndLoop), lastMigrationInfo.getFeatureName());
        }
    }

    private void recordIndexMigrationSuccess(SystemIndexMigrationInfo lastMigrationInfo) {
        MigrationResultsUpdateTask updateTask = MigrationResultsUpdateTask.upsert(lastMigrationInfo.getFeatureName(), SingleFeatureMigrationResult.success(), ActionListener.wrap(state -> this.prepareNextIndex((ClusterState)state, clusterState -> this.migrateSingleIndex((ClusterState)clusterState, this::finishIndexAndLoop), lastMigrationInfo.getFeatureName()), this::markAsFailed));
        updateTask.submit(this.clusterService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNextIndex(ClusterState clusterState, Consumer<ClusterState> listener, String lastFeatureName) {
        Queue<SystemIndexMigrationInfo> queue = this.migrationQueue;
        synchronized (queue) {
            assert (this.migrationQueue != null);
            if (this.migrationQueue.isEmpty()) {
                logger.info("finished migrating feature indices");
                this.markAsCompleted();
                return;
            }
        }
        SystemIndexMigrationInfo migrationInfo = this.currentMigrationInfo();
        assert (migrationInfo != null) : "the queue of indices to migrate should have been checked for emptiness before calling this method";
        logger.info("preparing to migrate old index [{}] from feature [{}] to new index [{}]", (Object)migrationInfo.getCurrentIndexName(), (Object)migrationInfo.getFeatureName(), (Object)migrationInfo.getNextIndexName());
        if (!migrationInfo.getFeatureName().equals(lastFeatureName)) {
            migrationInfo.prepareForIndicesMigration(this.clusterService, this.baseClient, ActionListener.wrap(newMetadata -> {
                this.currentFeatureCallbackMetadata.set((Map<String, Object>)newMetadata);
                this.updateTaskState(migrationInfo, listener, (Map<String, Object>)newMetadata);
            }, this::markAsFailed));
        } else {
            this.updateTaskState(migrationInfo, listener, this.currentFeatureCallbackMetadata.get());
        }
    }

    private void updateTaskState(SystemIndexMigrationInfo migrationInfo, Consumer<ClusterState> listener, Map<String, Object> metadata) {
        SystemIndexMigrationTaskState newTaskState = new SystemIndexMigrationTaskState(migrationInfo.getCurrentIndexName(), migrationInfo.getFeatureName(), metadata);
        logger.debug("updating task state to [{}]", (Object)Strings.toString((ToXContent)newTaskState));
        this.currentFeatureCallbackMetadata.set(metadata);
        this.updatePersistentTaskState(newTaskState, ActionListener.wrap(task -> {
            assert (newTaskState.equals(task.getState())) : "task state returned by update method did not match submitted task state";
            logger.debug("new task state [{}] accepted", (Object)Strings.toString((ToXContent)newTaskState));
            listener.accept(this.clusterService.state());
        }, this::markAsFailed));
    }

    private boolean needsToBeMigrated(IndexMetadata indexMetadata) {
        assert (indexMetadata != null) : "null IndexMetadata should be impossible, we're not consistently using the same cluster state";
        if (indexMetadata == null) {
            return false;
        }
        return indexMetadata.isSystem() && indexMetadata.getCreationVersion().before(TransportGetFeatureUpgradeStatusAction.NO_UPGRADE_REQUIRED_VERSION);
    }

    private void migrateSingleIndex(ClusterState clusterState, Consumer<BulkByScrollResponse> listener) {
        SystemIndexMigrationInfo migrationInfo = this.currentMigrationInfo();
        String oldIndexName = migrationInfo.getCurrentIndexName();
        IndexMetadata imd = clusterState.metadata().index(oldIndexName);
        if (imd.getState().equals((Object)IndexMetadata.State.CLOSE)) {
            logger.error("unable to migrate index [{}] from feature [{}] because it is closed", (Object)oldIndexName, (Object)migrationInfo.getFeatureName());
            this.markAsFailed(new IllegalStateException("unable to migrate index [" + oldIndexName + "] because it is closed"));
            return;
        }
        Index oldIndex = imd.getIndex();
        String newIndexName = migrationInfo.getNextIndexName();
        logger.info("migrating index [{}] from feature [{}] to new index [{}]", (Object)oldIndexName, (Object)migrationInfo.getFeatureName(), (Object)newIndexName);
        ActionListener<BulkByScrollResponse> innerListener = ActionListener.wrap(listener::accept, this::markAsFailed);
        try {
            Exception versionException = SystemIndexMigrator.checkNodeVersionsReadyForMigration(clusterState);
            if (versionException != null) {
                this.markAsFailed(versionException);
                return;
            }
            this.createIndex(migrationInfo, ActionListener.wrap(shardsAcknowledgedResponse -> {
                logger.debug("while migrating [{}] , got create index response: [{}]", (Object)oldIndexName, (Object)Strings.toString((ToXContent)shardsAcknowledgedResponse));
                this.setWriteBlock(oldIndex, true, ActionListener.wrap(setReadOnlyResponse -> this.reindex(migrationInfo, ActionListener.wrap(bulkByScrollResponse -> {
                    logger.debug("while migrating [{}], got reindex response: [{}]", (Object)oldIndexName, (Object)Strings.toString((ToXContent)bulkByScrollResponse));
                    if (bulkByScrollResponse.getBulkFailures() != null && !bulkByScrollResponse.getBulkFailures().isEmpty() || bulkByScrollResponse.getSearchFailures() != null && !bulkByScrollResponse.getSearchFailures().isEmpty()) {
                        this.removeReadOnlyBlockOnReindexFailure(oldIndex, innerListener, this.logAndThrowExceptionForFailures((BulkByScrollResponse)bulkByScrollResponse));
                    } else {
                        this.setWriteBlock(oldIndex, false, ActionListener.wrap(this.setAliasAndRemoveOldIndex(migrationInfo, (BulkByScrollResponse)bulkByScrollResponse, innerListener), innerListener::onFailure));
                    }
                }, e -> {
                    logger.error((Message)new ParameterizedMessage("error occurred while reindexing index [{}] from feature [{}] to destination index [{}]", new Object[]{oldIndexName, migrationInfo.getFeatureName(), newIndexName}), (Throwable)e);
                    this.removeReadOnlyBlockOnReindexFailure(oldIndex, innerListener, (Exception)e);
                })), innerListener::onFailure));
            }, innerListener::onFailure));
        }
        catch (Exception ex) {
            logger.error((Message)new ParameterizedMessage("error occurred while migrating index [{}] from feature [{}] to new index [{}]", new Object[]{oldIndexName, migrationInfo.getFeatureName(), newIndexName}), (Throwable)ex);
            this.removeReadOnlyBlockOnReindexFailure(oldIndex, innerListener, ex);
            innerListener.onFailure(ex);
        }
    }

    private void createIndex(SystemIndexMigrationInfo migrationInfo, ActionListener<ShardsAcknowledgedResponse> listener) {
        CreateIndexClusterStateUpdateRequest createRequest = new CreateIndexClusterStateUpdateRequest("migrate-system-index", migrationInfo.getNextIndexName(), migrationInfo.getNextIndexName());
        createRequest.waitForActiveShards(ActiveShardCount.ALL).mappings(migrationInfo.getMappings()).settings(Objects.requireNonNullElse(migrationInfo.getSettings(), Settings.EMPTY));
        this.metadataCreateIndexService.createIndex(createRequest, listener);
    }

    private CheckedConsumer<AcknowledgedResponse, Exception> setAliasAndRemoveOldIndex(SystemIndexMigrationInfo migrationInfo, BulkByScrollResponse bulkByScrollResponse, ActionListener<BulkByScrollResponse> listener) {
        IndicesAliasesRequestBuilder aliasesRequest = migrationInfo.createClient(this.baseClient).admin().indices().prepareAliases();
        aliasesRequest.removeIndex(migrationInfo.getCurrentIndexName());
        aliasesRequest.addAlias(migrationInfo.getNextIndexName(), migrationInfo.getCurrentIndexName());
        IndexMetadata imd = this.clusterService.state().metadata().index(migrationInfo.getCurrentIndexName());
        imd.getAliases().values().forEach(aliasToAdd -> aliasesRequest.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(migrationInfo.getNextIndexName()).alias(aliasToAdd.alias()).indexRouting(aliasToAdd.indexRouting()).searchRouting(aliasToAdd.searchRouting()).filter(aliasToAdd.filter() == null ? null : aliasToAdd.filter().string()).writeIndex(null)));
        return unsetReadOnlyResponse -> aliasesRequest.execute(ActionListener.wrap(deleteIndexResponse -> listener.onResponse(bulkByScrollResponse), listener::onFailure));
    }

    private void setWriteBlock(Index index, boolean readOnlyValue, ActionListener<AcknowledgedResponse> listener) {
        Settings readOnlySettings = Settings.builder().put(IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.getKey(), readOnlyValue).build();
        UpdateSettingsClusterStateUpdateRequest updateSettingsRequest = ((UpdateSettingsClusterStateUpdateRequest)new UpdateSettingsClusterStateUpdateRequest().indices(new Index[]{index})).settings(readOnlySettings).setPreserveExisting(false);
        this.metadataUpdateSettingsService.updateSettings(updateSettingsRequest, listener);
    }

    private void reindex(SystemIndexMigrationInfo migrationInfo, ActionListener<BulkByScrollResponse> listener) {
        ReindexRequest reindexRequest = new ReindexRequest();
        reindexRequest.setSourceIndices(migrationInfo.getCurrentIndexName());
        reindexRequest.setDestIndex(migrationInfo.getNextIndexName());
        reindexRequest.setRefresh(true);
        migrationInfo.createClient(this.baseClient).execute(ReindexAction.INSTANCE, reindexRequest, listener);
    }

    private void removeReadOnlyBlockOnReindexFailure(Index index, ActionListener<BulkByScrollResponse> listener, Exception ex) {
        logger.info("removing read only block on [{}] because reindex failed [{}]", (Object)index, (Object)ex);
        this.setWriteBlock(index, false, ActionListener.wrap(unsetReadOnlyResponse -> listener.onFailure(ex), e1 -> listener.onFailure(ex)));
    }

    private ElasticsearchException logAndThrowExceptionForFailures(BulkByScrollResponse bulkByScrollResponse) {
        String bulkFailures = bulkByScrollResponse.getBulkFailures() != null ? Strings.collectionToCommaDelimitedString(bulkByScrollResponse.getBulkFailures()) : "";
        String searchFailures = bulkByScrollResponse.getSearchFailures() != null ? Strings.collectionToCommaDelimitedString(bulkByScrollResponse.getSearchFailures()) : "";
        logger.error("error occurred while reindexing, bulk failures [{}], search failures [{}]", (Object)bulkFailures, (Object)searchFailures);
        return new ElasticsearchException("error occurred while reindexing, bulk failures [{}], search failures [{}]", bulkFailures, searchFailures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsFailed(Exception e) {
        SystemIndexMigrationInfo migrationInfo = this.currentMigrationInfo();
        Queue<SystemIndexMigrationInfo> queue = this.migrationQueue;
        synchronized (queue) {
            this.migrationQueue.clear();
        }
        String featureName = Optional.ofNullable(migrationInfo).map(SystemIndexMigrationInfo::getFeatureName).orElse("<unknown feature>");
        String indexName = Optional.ofNullable(migrationInfo).map(SystemIndexMigrationInfo::getCurrentIndexName).orElse("<unknown index>");
        MigrationResultsUpdateTask.upsert(featureName, SingleFeatureMigrationResult.failure(indexName, e), ActionListener.wrap(state -> super.markAsFailed(e), exception -> super.markAsFailed(e))).submit(this.clusterService);
        super.markAsFailed(e);
    }

    private static Exception checkNodeVersionsReadyForMigration(ClusterState state) {
        Version minNodeVersion = state.nodes().getMinNodeVersion();
        if (minNodeVersion.before(READY_FOR_MIGRATION_VERSION)) {
            return new IllegalStateException("all nodes must be on version [" + READY_FOR_MIGRATION_VERSION + "] or later to migrate feature indices but lowest node version currently in cluster is [" + minNodeVersion + "]");
        }
        return null;
    }

    private static void clearResults(ClusterService clusterService, final ActionListener<ClusterState> listener) {
        clusterService.submitStateUpdateTask("clear migration results", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                if (currentState.metadata().custom("system_index_migration") != null) {
                    return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).removeCustom("system_index_migration")).build();
                }
                return currentState;
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(newState);
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.error("failed to clear migration results when starting new migration", (Throwable)e);
                listener.onFailure(e);
            }
        });
        logger.debug("submitted update task to clear migration results");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SystemIndexMigrationInfo currentMigrationInfo() {
        Queue<SystemIndexMigrationInfo> queue = this.migrationQueue;
        synchronized (queue) {
            return this.migrationQueue.peek();
        }
    }
}

