/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.analytics.AnalyticsFeatureSetUsage;
import org.elasticsearch.xpack.core.analytics.action.AnalyticsStatsAction;

public class AnalyticsUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final Client client;

    @Inject
    public AnalyticsUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(XPackUsageFeatureAction.ANALYTICS.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.client = client;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        AnalyticsStatsAction.Request statsRequest = new AnalyticsStatsAction.Request();
        statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.client.execute((ActionType)AnalyticsStatsAction.INSTANCE, (ActionRequest)statsRequest, ActionListener.wrap(r -> listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)new AnalyticsFeatureSetUsage(true, true, r))), arg_0 -> listener.onFailure(arg_0)));
    }
}

