/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.CommonAsyncHelper;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

@InternalUseOnly
final class AsyncHelper
implements CommonAsyncHelper,
IntermediateResponseListener {
    private static final long serialVersionUID = 7186731025240177443L;
    @NotNull
    private final AsyncRequestID asyncRequestID;
    @Nullable
    private final AsyncResultListener resultListener;
    @NotNull
    private final AtomicBoolean responseReturned;
    @NotNull
    private final OperationType operationType;
    @Nullable
    private final IntermediateResponseListener intermediateResponseListener;
    @NotNull
    private final LDAPConnection connection;
    private final long createTime;

    @InternalUseOnly
    AsyncHelper(@NotNull LDAPConnection connection, @NotNull OperationType operationType, int messageID, @Nullable AsyncResultListener resultListener, @Nullable IntermediateResponseListener intermediateResponseListener) {
        this.connection = connection;
        this.operationType = operationType;
        this.resultListener = resultListener;
        this.intermediateResponseListener = intermediateResponseListener;
        this.asyncRequestID = new AsyncRequestID(messageID, connection);
        this.responseReturned = new AtomicBoolean(false);
        this.createTime = System.nanoTime();
    }

    @Override
    @NotNull
    public AsyncRequestID getAsyncRequestID() {
        return this.asyncRequestID;
    }

    @Override
    @NotNull
    public LDAPConnection getConnection() {
        return this.connection;
    }

    @Override
    public long getCreateTimeNanos() {
        return this.createTime;
    }

    @Override
    @NotNull
    public OperationType getOperationType() {
        return this.operationType;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(@Nullable LDAPResponse response) throws LDAPException {
        ConnectionClosedResponse ccr;
        String msg;
        if (!this.responseReturned.compareAndSet(false, true)) {
            return;
        }
        long responseTime = System.nanoTime() - this.createTime;
        LDAPResult result = response instanceof ConnectionClosedResponse ? ((msg = (ccr = (ConnectionClosedResponse)response).getMessage()) == null ? new LDAPResult(this.asyncRequestID.getMessageID(), ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE.get(), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS) : new LDAPResult(this.asyncRequestID.getMessageID(), ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE_WITH_MESSAGE.get(msg), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS)) : (LDAPResult)response;
        switch (this.operationType) {
            case ADD: {
                this.connection.getConnectionStatistics().incrementNumAddResponses(responseTime);
                break;
            }
            case DELETE: {
                this.connection.getConnectionStatistics().incrementNumDeleteResponses(responseTime);
                break;
            }
            case MODIFY: {
                this.connection.getConnectionStatistics().incrementNumModifyResponses(responseTime);
                break;
            }
            case MODIFY_DN: {
                this.connection.getConnectionStatistics().incrementNumModifyDNResponses(responseTime);
            }
        }
        this.resultListener.ldapResultReceived(this.asyncRequestID, result);
        this.asyncRequestID.setResult(result);
    }

    @Override
    @InternalUseOnly
    public void intermediateResponseReturned(@NotNull IntermediateResponse intermediateResponse) {
        if (this.intermediateResponseListener == null) {
            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(intermediateResponse)));
        } else {
            this.intermediateResponseListener.intermediateResponseReturned(intermediateResponse);
        }
    }
}

