/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassType;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaElementType;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ObjectClassDefinition
extends SchemaElement {
    private static final long serialVersionUID = -3024333376249332728L;
    private final boolean isObsolete;
    @NotNull
    private final Map<String, String[]> extensions;
    @Nullable
    private final ObjectClassType objectClassType;
    @Nullable
    private final String description;
    @NotNull
    private final String objectClassString;
    @NotNull
    private final String oid;
    @NotNull
    private final String[] names;
    @NotNull
    private final String[] optionalAttributes;
    @NotNull
    private final String[] requiredAttributes;
    @NotNull
    private final String[] superiorClasses;

    public ObjectClassDefinition(@NotNull String s) throws LDAPException {
        String descr;
        ObjectClassType ocType;
        Boolean obsolete;
        LinkedHashMap<String, String[]> exts;
        ArrayList<String> optAttrs;
        ArrayList<String> reqAttrs;
        ArrayList<String> supList;
        ArrayList<String> nameList;
        block26: {
            String token;
            Validator.ensureNotNull(s);
            this.objectClassString = s.trim();
            int length = this.objectClassString.length();
            if (length == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_EMPTY.get());
            }
            if (this.objectClassString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_NO_OPENING_PAREN.get(this.objectClassString));
            }
            int pos = ObjectClassDefinition.skipSpaces(this.objectClassString, 1, length);
            StringBuilder buffer = new StringBuilder();
            pos = ObjectClassDefinition.readOID(this.objectClassString, pos, length, buffer);
            this.oid = buffer.toString();
            nameList = new ArrayList<String>(1);
            supList = new ArrayList<String>(1);
            reqAttrs = new ArrayList<String>(20);
            optAttrs = new ArrayList<String>(20);
            exts = new LinkedHashMap<String, String[]>(StaticUtils.computeMapCapacity(5));
            obsolete = null;
            ocType = null;
            descr = null;
            while (true) {
                String lowerToken;
                int tokenStartPos = pos = ObjectClassDefinition.skipSpaces(this.objectClassString, pos, length);
                while (pos < length && this.objectClassString.charAt(pos) != ' ') {
                    ++pos;
                }
                token = this.objectClassString.substring(tokenStartPos, pos);
                if (token.length() > 1 && token.endsWith(")")) {
                    token = token.substring(0, token.length() - 1);
                    --pos;
                }
                if ((lowerToken = StaticUtils.toLowerCase(token)).equals(")")) {
                    if (pos < length) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_CLOSE_NOT_AT_END.get(this.objectClassString));
                    }
                    break block26;
                }
                if (lowerToken.equals("name")) {
                    if (nameList.isEmpty()) {
                        pos = ObjectClassDefinition.skipSpaces(this.objectClassString, pos, length);
                        pos = ObjectClassDefinition.readQDStrings(this.objectClassString, pos, length, token, nameList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "NAME"));
                }
                if (lowerToken.equals("desc")) {
                    if (descr == null) {
                        pos = ObjectClassDefinition.skipSpaces(this.objectClassString, pos, length);
                        buffer = new StringBuilder();
                        pos = ObjectClassDefinition.readQDString(this.objectClassString, pos, length, token, buffer);
                        descr = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "DESC"));
                }
                if (lowerToken.equals("obsolete")) {
                    if (obsolete == null) {
                        obsolete = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "OBSOLETE"));
                }
                if (lowerToken.equals("sup")) {
                    if (supList.isEmpty()) {
                        pos = ObjectClassDefinition.skipSpaces(this.objectClassString, pos, length);
                        pos = ObjectClassDefinition.readOIDs(this.objectClassString, pos, length, token, supList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "SUP"));
                }
                if (lowerToken.equals("abstract")) {
                    if (ocType == null) {
                        ocType = ObjectClassType.ABSTRACT;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_OC_TYPES.get(this.objectClassString));
                }
                if (lowerToken.equals("structural")) {
                    if (ocType == null) {
                        ocType = ObjectClassType.STRUCTURAL;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_OC_TYPES.get(this.objectClassString));
                }
                if (lowerToken.equals("auxiliary")) {
                    if (ocType == null) {
                        ocType = ObjectClassType.AUXILIARY;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_OC_TYPES.get(this.objectClassString));
                }
                if (lowerToken.equals("must")) {
                    if (reqAttrs.isEmpty()) {
                        pos = ObjectClassDefinition.skipSpaces(this.objectClassString, pos, length);
                        pos = ObjectClassDefinition.readOIDs(this.objectClassString, pos, length, token, reqAttrs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "MUST"));
                }
                if (lowerToken.equals("may")) {
                    if (optAttrs.isEmpty()) {
                        pos = ObjectClassDefinition.skipSpaces(this.objectClassString, pos, length);
                        pos = ObjectClassDefinition.readOIDs(this.objectClassString, pos, length, token, optAttrs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "MAY"));
                }
                if (!lowerToken.startsWith("x-")) break;
                pos = ObjectClassDefinition.skipSpaces(this.objectClassString, pos, length);
                ArrayList<String> valueList = new ArrayList<String>(5);
                pos = ObjectClassDefinition.readQDStrings(this.objectClassString, pos, length, token, valueList);
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                if (exts.containsKey(token)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_DUP_EXT.get(this.objectClassString, token));
                }
                exts.put(token, values);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_UNEXPECTED_TOKEN.get(this.objectClassString, token));
        }
        this.description = descr;
        this.names = new String[nameList.size()];
        nameList.toArray(this.names);
        this.superiorClasses = new String[supList.size()];
        supList.toArray(this.superiorClasses);
        this.requiredAttributes = new String[reqAttrs.size()];
        reqAttrs.toArray(this.requiredAttributes);
        this.optionalAttributes = new String[optAttrs.size()];
        optAttrs.toArray(this.optionalAttributes);
        this.isObsolete = obsolete != null;
        this.objectClassType = ocType;
        this.extensions = Collections.unmodifiableMap(exts);
    }

    public ObjectClassDefinition(@NotNull String oid, @Nullable String name, @Nullable String description, @Nullable String superiorClass, @Nullable ObjectClassType objectClassType, @Nullable String[] requiredAttributes, @Nullable String[] optionalAttributes, @Nullable Map<String, String[]> extensions) {
        String[] stringArray;
        String[] stringArray2;
        if (name == null) {
            stringArray2 = null;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = name;
        }
        if (superiorClass == null) {
            stringArray = null;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = superiorClass;
        }
        this(oid, stringArray2, description, false, stringArray, objectClassType, requiredAttributes, optionalAttributes, extensions);
    }

    public ObjectClassDefinition(@NotNull String oid, @Nullable String name, @Nullable String description, @Nullable String superiorClass, @Nullable ObjectClassType objectClassType, @Nullable Collection<String> requiredAttributes, @Nullable Collection<String> optionalAttributes, @Nullable Map<String, String[]> extensions) {
        String[] stringArray;
        String[] stringArray2;
        if (name == null) {
            stringArray2 = null;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = name;
        }
        if (superiorClass == null) {
            stringArray = null;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = superiorClass;
        }
        this(oid, stringArray2, description, false, stringArray, objectClassType, ObjectClassDefinition.toArray(requiredAttributes), ObjectClassDefinition.toArray(optionalAttributes), extensions);
    }

    public ObjectClassDefinition(@NotNull String oid, @Nullable String[] names, @Nullable String description, boolean isObsolete, @Nullable String[] superiorClasses, @Nullable ObjectClassType objectClassType, @Nullable String[] requiredAttributes, @Nullable String[] optionalAttributes, @Nullable Map<String, String[]> extensions) {
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.isObsolete = isObsolete;
        this.description = description;
        this.objectClassType = objectClassType;
        this.names = names == null ? StaticUtils.NO_STRINGS : names;
        this.superiorClasses = superiorClasses == null ? StaticUtils.NO_STRINGS : superiorClasses;
        this.requiredAttributes = requiredAttributes == null ? StaticUtils.NO_STRINGS : requiredAttributes;
        this.optionalAttributes = optionalAttributes == null ? StaticUtils.NO_STRINGS : optionalAttributes;
        this.extensions = extensions == null ? Collections.emptyMap() : Collections.unmodifiableMap(extensions);
        StringBuilder buffer = new StringBuilder();
        this.createDefinitionString(buffer);
        this.objectClassString = buffer.toString();
    }

    private void createDefinitionString(@NotNull StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.oid);
        if (this.names.length == 1) {
            buffer.append(" NAME '");
            buffer.append(this.names[0]);
            buffer.append('\'');
        } else if (this.names.length > 1) {
            buffer.append(" NAME (");
            for (String name : this.names) {
                buffer.append(" '");
                buffer.append(name);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        if (this.description != null) {
            buffer.append(" DESC '");
            ObjectClassDefinition.encodeValue(this.description, buffer);
            buffer.append('\'');
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (this.superiorClasses.length == 1) {
            buffer.append(" SUP ");
            buffer.append(this.superiorClasses[0]);
        } else if (this.superiorClasses.length > 1) {
            buffer.append(" SUP (");
            for (int i = 0; i < this.superiorClasses.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.superiorClasses[i]);
            }
            buffer.append(" )");
        }
        if (this.objectClassType != null) {
            buffer.append(' ');
            buffer.append(this.objectClassType.getName());
        }
        if (this.requiredAttributes.length == 1) {
            buffer.append(" MUST ");
            buffer.append(this.requiredAttributes[0]);
        } else if (this.requiredAttributes.length > 1) {
            buffer.append(" MUST (");
            for (int i = 0; i < this.requiredAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.requiredAttributes[i]);
            }
            buffer.append(" )");
        }
        if (this.optionalAttributes.length == 1) {
            buffer.append(" MAY ");
            buffer.append(this.optionalAttributes[0]);
        } else if (this.optionalAttributes.length > 1) {
            buffer.append(" MAY (");
            for (int i = 0; i < this.optionalAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.optionalAttributes[i]);
            }
            buffer.append(" )");
        }
        for (Map.Entry<String, String[]> e : this.extensions.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            if (values.length == 1) {
                buffer.append(' ');
                buffer.append(name);
                buffer.append(" '");
                ObjectClassDefinition.encodeValue(values[0], buffer);
                buffer.append('\'');
                continue;
            }
            buffer.append(' ');
            buffer.append(name);
            buffer.append(" (");
            for (String value : values) {
                buffer.append(" '");
                ObjectClassDefinition.encodeValue(value, buffer);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        buffer.append(" )");
    }

    @NotNull
    public String getOID() {
        return this.oid;
    }

    @NotNull
    public String[] getNames() {
        return this.names;
    }

    @NotNull
    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(@NotNull String s) {
        for (String name : this.names) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return s.equalsIgnoreCase(this.oid);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    @NotNull
    public String[] getSuperiorClasses() {
        return this.superiorClasses;
    }

    @NotNull
    public Set<ObjectClassDefinition> getSuperiorClasses(@NotNull Schema schema, boolean recursive) {
        LinkedHashSet<ObjectClassDefinition> ocSet = new LinkedHashSet<ObjectClassDefinition>(StaticUtils.computeMapCapacity(10));
        for (String s : this.superiorClasses) {
            ObjectClassDefinition d = schema.getObjectClass(s);
            if (d == null) continue;
            ocSet.add(d);
            if (!recursive) continue;
            ObjectClassDefinition.getSuperiorClasses(schema, d, ocSet);
        }
        return Collections.unmodifiableSet(ocSet);
    }

    private static void getSuperiorClasses(@NotNull Schema schema, @NotNull ObjectClassDefinition oc, @NotNull Set<ObjectClassDefinition> ocSet) {
        for (String s : oc.superiorClasses) {
            ObjectClassDefinition d = schema.getObjectClass(s);
            if (d == null) continue;
            ocSet.add(d);
            ObjectClassDefinition.getSuperiorClasses(schema, d, ocSet);
        }
    }

    @Nullable
    public ObjectClassType getObjectClassType() {
        return this.objectClassType;
    }

    @NotNull
    public ObjectClassType getObjectClassType(@NotNull Schema schema) {
        if (this.objectClassType == null) {
            return ObjectClassType.STRUCTURAL;
        }
        return this.objectClassType;
    }

    @NotNull
    public String[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    @NotNull
    public Set<AttributeTypeDefinition> getRequiredAttributes(@NotNull Schema schema, boolean includeSuperiorClasses) {
        SchemaElement d;
        HashSet<AttributeTypeDefinition> attrSet = new HashSet<AttributeTypeDefinition>(StaticUtils.computeMapCapacity(20));
        for (String s : this.requiredAttributes) {
            d = schema.getAttributeType(s);
            if (d == null) continue;
            attrSet.add((AttributeTypeDefinition)d);
        }
        if (includeSuperiorClasses) {
            for (String s : this.superiorClasses) {
                d = schema.getObjectClass(s);
                if (d == null) continue;
                ObjectClassDefinition.getSuperiorRequiredAttributes(schema, (ObjectClassDefinition)d, attrSet);
            }
        }
        return Collections.unmodifiableSet(attrSet);
    }

    private static void getSuperiorRequiredAttributes(@NotNull Schema schema, @NotNull ObjectClassDefinition oc, @NotNull Set<AttributeTypeDefinition> attrSet) {
        SchemaElement d;
        for (String s : oc.requiredAttributes) {
            d = schema.getAttributeType(s);
            if (d == null) continue;
            attrSet.add((AttributeTypeDefinition)d);
        }
        for (String s : oc.superiorClasses) {
            d = schema.getObjectClass(s);
            if (d == null) continue;
            ObjectClassDefinition.getSuperiorRequiredAttributes(schema, (ObjectClassDefinition)d, attrSet);
        }
    }

    @NotNull
    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    @NotNull
    public Set<AttributeTypeDefinition> getOptionalAttributes(@NotNull Schema schema, boolean includeSuperiorClasses) {
        HashSet<AttributeTypeDefinition> attrSet = new HashSet<AttributeTypeDefinition>(StaticUtils.computeMapCapacity(20));
        for (String s : this.optionalAttributes) {
            AttributeTypeDefinition d = schema.getAttributeType(s);
            if (d == null) continue;
            attrSet.add(d);
        }
        if (includeSuperiorClasses) {
            Set<AttributeTypeDefinition> requiredAttrs = this.getRequiredAttributes(schema, true);
            for (AttributeTypeDefinition d : requiredAttrs) {
                attrSet.remove(d);
            }
            for (String s : this.superiorClasses) {
                ObjectClassDefinition d = schema.getObjectClass(s);
                if (d == null) continue;
                ObjectClassDefinition.getSuperiorOptionalAttributes(schema, d, attrSet, requiredAttrs);
            }
        }
        return Collections.unmodifiableSet(attrSet);
    }

    private static void getSuperiorOptionalAttributes(@NotNull Schema schema, @NotNull ObjectClassDefinition oc, @NotNull Set<AttributeTypeDefinition> attrSet, @NotNull Set<AttributeTypeDefinition> requiredSet) {
        SchemaElement d;
        for (String s : oc.optionalAttributes) {
            d = schema.getAttributeType(s);
            if (d == null || requiredSet.contains(d)) continue;
            attrSet.add((AttributeTypeDefinition)d);
        }
        for (String s : oc.superiorClasses) {
            d = schema.getObjectClass(s);
            if (d == null) continue;
            ObjectClassDefinition.getSuperiorOptionalAttributes(schema, (ObjectClassDefinition)d, attrSet, requiredSet);
        }
    }

    @NotNull
    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    @NotNull
    public SchemaElementType getSchemaElementType() {
        return SchemaElementType.OBJECT_CLASS;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectClassDefinition)) {
            return false;
        }
        ObjectClassDefinition d = (ObjectClassDefinition)o;
        return this.oid.equals(d.oid) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, d.names) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.requiredAttributes, d.requiredAttributes) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.optionalAttributes, d.optionalAttributes) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.superiorClasses, d.superiorClasses) && StaticUtils.bothNullOrEqual((Object)this.objectClassType, (Object)d.objectClassType) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, d.description) && this.isObsolete == d.isObsolete && ObjectClassDefinition.extensionsEqual(this.extensions, d.extensions);
    }

    @Override
    @NotNull
    public String toString() {
        return this.objectClassString;
    }
}

