/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.HitsThresholdChecker;
import org.apache.lucene.search.LRUQueryCache;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MaxScoreAccumulator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.QueueSizeBasedExecutor;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SliceExecutor;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ThreadInterruptedException;
import org.apache.lucene.util.automaton.ByteRunAutomaton;

public class IndexSearcher {
    static int maxClauseCount = 1024;
    private static QueryCache DEFAULT_QUERY_CACHE;
    private static QueryCachingPolicy DEFAULT_CACHING_POLICY;
    private static final int TOTAL_HITS_THRESHOLD = 1000;
    private static final int MAX_DOCS_PER_SLICE = 250000;
    private static final int MAX_SEGMENTS_PER_SLICE = 5;
    final IndexReader reader;
    protected final IndexReaderContext readerContext;
    protected final List<LeafReaderContext> leafContexts;
    private final LeafSlice[] leafSlices;
    private final Executor executor;
    private final SliceExecutor sliceExecutor;
    private static final Similarity defaultSimilarity;
    private QueryCache queryCache = DEFAULT_QUERY_CACHE;
    private QueryCachingPolicy queryCachingPolicy = DEFAULT_CACHING_POLICY;
    private Similarity similarity = defaultSimilarity;

    public static Similarity getDefaultSimilarity() {
        return defaultSimilarity;
    }

    public static QueryCache getDefaultQueryCache() {
        return DEFAULT_QUERY_CACHE;
    }

    public static void setDefaultQueryCache(QueryCache defaultQueryCache) {
        DEFAULT_QUERY_CACHE = defaultQueryCache;
    }

    public static QueryCachingPolicy getDefaultQueryCachingPolicy() {
        return DEFAULT_CACHING_POLICY;
    }

    public static void setDefaultQueryCachingPolicy(QueryCachingPolicy defaultQueryCachingPolicy) {
        DEFAULT_CACHING_POLICY = defaultQueryCachingPolicy;
    }

    public IndexSearcher(IndexReader r) {
        this(r, null);
    }

    public IndexSearcher(IndexReader r, Executor executor) {
        this(r.getContext(), executor);
    }

    public IndexSearcher(IndexReaderContext context, Executor executor) {
        this(context, executor, IndexSearcher.getSliceExecutionControlPlane(executor));
    }

    IndexSearcher(IndexReaderContext context, Executor executor, SliceExecutor sliceExecutor) {
        assert (context.isTopLevel) : "IndexSearcher's ReaderContext must be topLevel for reader" + context.reader();
        assert (sliceExecutor == null == (executor == null));
        this.reader = context.reader();
        this.executor = executor;
        this.sliceExecutor = sliceExecutor;
        this.readerContext = context;
        this.leafContexts = context.leaves();
        this.leafSlices = executor == null ? null : this.slices(this.leafContexts);
    }

    public IndexSearcher(IndexReaderContext context) {
        this(context, null);
    }

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("maxClauseCount must be >= 1");
        }
        maxClauseCount = value;
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public void setQueryCachingPolicy(QueryCachingPolicy queryCachingPolicy) {
        this.queryCachingPolicy = Objects.requireNonNull(queryCachingPolicy);
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.queryCachingPolicy;
    }

    protected LeafSlice[] slices(List<LeafReaderContext> leaves) {
        return IndexSearcher.slices(leaves, 250000, 5);
    }

    public static LeafSlice[] slices(List<LeafReaderContext> leaves, int maxDocsPerSlice, int maxSegmentsPerSlice) {
        ArrayList<LeafReaderContext> sortedLeaves = new ArrayList<LeafReaderContext>(leaves);
        Collections.sort(sortedLeaves, Collections.reverseOrder(Comparator.comparingInt(l -> l.reader().maxDoc())));
        ArrayList<List<LeafReaderContext>> groupedLeaves = new ArrayList<List<LeafReaderContext>>();
        long docSum = 0L;
        ArrayList<LeafReaderContext> group = null;
        for (LeafReaderContext ctx : sortedLeaves) {
            if (ctx.reader().maxDoc() > maxDocsPerSlice) {
                assert (group == null);
                groupedLeaves.add(Collections.singletonList(ctx));
                continue;
            }
            if (group == null) {
                group = new ArrayList<LeafReaderContext>();
                group.add(ctx);
                groupedLeaves.add(group);
            } else {
                group.add(ctx);
            }
            if (group.size() < maxSegmentsPerSlice && (docSum += (long)ctx.reader().maxDoc()) <= (long)maxDocsPerSlice) continue;
            group = null;
            docSum = 0L;
        }
        LeafSlice[] slices = new LeafSlice[groupedLeaves.size()];
        int upto = 0;
        for (List list : groupedLeaves) {
            slices[upto] = new LeafSlice(list);
            ++upto;
        }
        return slices;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public Document doc(int docID) throws IOException {
        return this.reader.document(docID);
    }

    public void doc(int docID, StoredFieldVisitor fieldVisitor) throws IOException {
        this.reader.document(docID, fieldVisitor);
    }

    public Document doc(int docID, Set<String> fieldsToLoad) throws IOException {
        return this.reader.document(docID, fieldsToLoad);
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public int count(Query query) throws IOException {
        query = this.rewrite(query);
        final Weight weight = this.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        CollectorManager<ShortcutHitCountCollector, Integer> shortcutCollectorManager = new CollectorManager<ShortcutHitCountCollector, Integer>(){

            @Override
            public ShortcutHitCountCollector newCollector() throws IOException {
                return new ShortcutHitCountCollector(weight);
            }

            @Override
            public Integer reduce(Collection<ShortcutHitCountCollector> collectors) throws IOException {
                int totalHitCount = 0;
                for (ShortcutHitCountCollector c : collectors) {
                    totalHitCount += c.weightCount + c.totalHitCountCollector.getTotalHits();
                }
                return totalHitCount;
            }
        };
        return this.search(weight, shortcutCollectorManager, new ShortcutHitCountCollector(weight));
    }

    public LeafSlice[] getSlices() {
        return this.leafSlices;
    }

    public TopDocs searchAfter(final ScoreDoc after, Query query, final int numHits) throws IOException {
        int limit = Math.max(1, this.reader.maxDoc());
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        final int cappedNumHits = Math.min(numHits, limit);
        CollectorManager<TopScoreDocCollector, TopDocs> manager = new CollectorManager<TopScoreDocCollector, TopDocs>(){
            private final HitsThresholdChecker hitsThresholdChecker;
            private final MaxScoreAccumulator minScoreAcc;
            {
                this.hitsThresholdChecker = IndexSearcher.this.executor == null || IndexSearcher.this.leafSlices.length <= 1 ? HitsThresholdChecker.create(Math.max(1000, numHits)) : HitsThresholdChecker.createShared(Math.max(1000, numHits));
                this.minScoreAcc = IndexSearcher.this.executor == null || IndexSearcher.this.leafSlices.length <= 1 ? null : new MaxScoreAccumulator();
            }

            @Override
            public TopScoreDocCollector newCollector() throws IOException {
                return TopScoreDocCollector.create(cappedNumHits, after, this.hitsThresholdChecker, this.minScoreAcc);
            }

            @Override
            public TopDocs reduce(Collection<TopScoreDocCollector> collectors) throws IOException {
                TopDocs[] topDocs = new TopDocs[collectors.size()];
                int i = 0;
                for (TopScoreDocCollector collector : collectors) {
                    topDocs[i++] = collector.topDocs();
                }
                return TopDocs.merge(0, cappedNumHits, topDocs);
            }
        };
        return this.search(query, manager);
    }

    public TopDocs search(Query query, int n) throws IOException {
        return this.searchAfter(null, query, n);
    }

    public void search(Query query, Collector results) throws IOException {
        query = this.rewrite(query);
        this.search(this.leafContexts, this.createWeight(query, results.scoreMode(), 1.0f), results);
    }

    public TopFieldDocs search(Query query, int n, Sort sort, boolean doDocScores) throws IOException {
        return this.searchAfter(null, query, n, sort, doDocScores);
    }

    public TopFieldDocs search(Query query, int n, Sort sort) throws IOException {
        return this.searchAfter(null, query, n, sort, false);
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, int n, Sort sort) throws IOException {
        return this.searchAfter(after, query, n, sort, false);
    }

    public TopFieldDocs searchAfter(ScoreDoc after, Query query, int numHits, Sort sort, boolean doDocScores) throws IOException {
        if (after != null && !(after instanceof FieldDoc)) {
            throw new IllegalArgumentException("after must be a FieldDoc; got " + after);
        }
        return this.searchAfter((FieldDoc)after, query, numHits, sort, doDocScores);
    }

    private TopFieldDocs searchAfter(final FieldDoc after, Query query, final int numHits, Sort sort, boolean doDocScores) throws IOException {
        int limit = Math.max(1, this.reader.maxDoc());
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        final int cappedNumHits = Math.min(numHits, limit);
        final Sort rewrittenSort = sort.rewrite(this);
        CollectorManager<TopFieldCollector, TopFieldDocs> manager = new CollectorManager<TopFieldCollector, TopFieldDocs>(){
            private final HitsThresholdChecker hitsThresholdChecker;
            private final MaxScoreAccumulator minScoreAcc;
            {
                this.hitsThresholdChecker = IndexSearcher.this.executor == null || IndexSearcher.this.leafSlices.length <= 1 ? HitsThresholdChecker.create(Math.max(1000, numHits)) : HitsThresholdChecker.createShared(Math.max(1000, numHits));
                this.minScoreAcc = IndexSearcher.this.executor == null || IndexSearcher.this.leafSlices.length <= 1 ? null : new MaxScoreAccumulator();
            }

            @Override
            public TopFieldCollector newCollector() throws IOException {
                return TopFieldCollector.create(rewrittenSort, cappedNumHits, after, this.hitsThresholdChecker, this.minScoreAcc);
            }

            @Override
            public TopFieldDocs reduce(Collection<TopFieldCollector> collectors) throws IOException {
                TopFieldDocs[] topDocs = new TopFieldDocs[collectors.size()];
                int i = 0;
                for (TopFieldCollector collector : collectors) {
                    topDocs[i++] = collector.topDocs();
                }
                return TopDocs.merge(rewrittenSort, 0, cappedNumHits, topDocs);
            }
        };
        TopFieldDocs topDocs = this.search(query, manager);
        if (doDocScores) {
            TopFieldCollector.populateScores(topDocs.scoreDocs, this, query);
        }
        return topDocs;
    }

    public <C extends Collector, T> T search(Query query, CollectorManager<C, T> collectorManager) throws IOException {
        C firstCollector = collectorManager.newCollector();
        query = this.rewrite(query);
        Weight weight = this.createWeight(query, firstCollector.scoreMode(), 1.0f);
        return this.search(weight, collectorManager, firstCollector);
    }

    private <C extends Collector, T> T search(Weight weight, CollectorManager<C, T> collectorManager, C firstCollector) throws IOException {
        if (this.executor == null || this.leafSlices.length <= 1) {
            this.search(this.leafContexts, weight, firstCollector);
            return collectorManager.reduce(Collections.singletonList(firstCollector));
        }
        ArrayList<Object> collectors = new ArrayList<Object>(this.leafSlices.length);
        collectors.add(firstCollector);
        ScoreMode scoreMode = firstCollector.scoreMode();
        for (int i = 1; i < this.leafSlices.length; ++i) {
            Object collector = collectorManager.newCollector();
            collectors.add(collector);
            if (scoreMode == collector.scoreMode()) continue;
            throw new IllegalStateException("CollectorManager does not always produce collectors with the same score mode");
        }
        ArrayList<FutureTask<Collector>> listTasks = new ArrayList<FutureTask<Collector>>();
        for (int i = 0; i < this.leafSlices.length; ++i) {
            LeafReaderContext[] leaves = this.leafSlices[i].leaves;
            Collector collector = (Collector)collectors.get(i);
            FutureTask<Collector> task = new FutureTask<Collector>(() -> {
                this.search(Arrays.asList(leaves), weight, collector);
                return collector;
            });
            listTasks.add(task);
        }
        this.sliceExecutor.invokeAll(listTasks);
        ArrayList<Collector> collectedCollectors = new ArrayList<Collector>();
        for (Future future : listTasks) {
            try {
                collectedCollectors.add((Collector)future.get());
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return collectorManager.reduce(collectedCollectors);
    }

    protected void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        for (LeafReaderContext ctx : leaves) {
            LeafCollector leafCollector;
            try {
                leafCollector = collector.getLeafCollector(ctx);
            }
            catch (CollectionTerminatedException e) {
                continue;
            }
            BulkScorer scorer = weight.bulkScorer(ctx);
            if (scorer == null) continue;
            try {
                scorer.score(leafCollector, ctx.reader().getLiveDocs());
            }
            catch (CollectionTerminatedException collectionTerminatedException) {}
        }
    }

    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this.reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this.reader);
        }
        query.visit(IndexSearcher.getNumClausesCheckVisitor());
        return query;
    }

    private static QueryVisitor getNumClausesCheckVisitor() {
        return new QueryVisitor(){
            int numClauses;

            @Override
            public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
                return this;
            }

            @Override
            public void visitLeaf(Query query) {
                if (this.numClauses > maxClauseCount) {
                    throw new TooManyNestedClauses();
                }
                ++this.numClauses;
            }

            @Override
            public void consumeTerms(Query query, Term ... terms) {
                if (this.numClauses > maxClauseCount) {
                    throw new TooManyNestedClauses();
                }
                ++this.numClauses;
            }

            @Override
            public void consumeTermsMatching(Query query, String field, Supplier<ByteRunAutomaton> automaton) {
                if (this.numClauses > maxClauseCount) {
                    throw new TooManyNestedClauses();
                }
                ++this.numClauses;
            }
        };
    }

    public Explanation explain(Query query, int doc) throws IOException {
        query = this.rewrite(query);
        return this.explain(this.createWeight(query, ScoreMode.COMPLETE, 1.0f), doc);
    }

    protected Explanation explain(Weight weight, int doc) throws IOException {
        int n = ReaderUtil.subIndex(doc, this.leafContexts);
        LeafReaderContext ctx = this.leafContexts.get(n);
        int deBasedDoc = doc - ctx.docBase;
        Bits liveDocs = ctx.reader().getLiveDocs();
        if (liveDocs != null && !liveDocs.get(deBasedDoc)) {
            return Explanation.noMatch("Document " + doc + " is deleted", new Explanation[0]);
        }
        return weight.explain(ctx, deBasedDoc);
    }

    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        QueryCache queryCache = this.queryCache;
        Weight weight = query.createWeight(this, scoreMode, boost);
        if (!scoreMode.needsScores() && queryCache != null) {
            weight = queryCache.doCache(weight, this.queryCachingPolicy);
        }
        return weight;
    }

    public IndexReaderContext getTopReaderContext() {
        return this.readerContext;
    }

    public String toString() {
        return "IndexSearcher(" + this.reader + "; executor=" + this.executor + "; sliceExecutionControlPlane " + this.sliceExecutor + ")";
    }

    public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
        return new TermStatistics(term.bytes(), docFreq, totalTermFreq);
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        assert (field != null);
        long docCount = 0L;
        long sumTotalTermFreq = 0L;
        long sumDocFreq = 0L;
        for (LeafReaderContext leaf : this.reader.leaves()) {
            Terms terms = leaf.reader().terms(field);
            if (terms == null) continue;
            docCount += (long)terms.getDocCount();
            sumTotalTermFreq += terms.getSumTotalTermFreq();
            sumDocFreq += terms.getSumDocFreq();
        }
        if (docCount == 0L) {
            return null;
        }
        return new CollectionStatistics(field, this.reader.maxDoc(), docCount, sumTotalTermFreq, sumDocFreq);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    private static SliceExecutor getSliceExecutionControlPlane(Executor executor) {
        if (executor == null) {
            return null;
        }
        if (executor instanceof ThreadPoolExecutor) {
            return new QueueSizeBasedExecutor((ThreadPoolExecutor)executor);
        }
        return new SliceExecutor(executor);
    }

    static {
        DEFAULT_CACHING_POLICY = new UsageTrackingQueryCachingPolicy();
        int maxCachedQueries = 1000;
        long maxRamBytesUsed = Math.min(0x2000000L, Runtime.getRuntime().maxMemory() / 20L);
        DEFAULT_QUERY_CACHE = new LRUQueryCache(1000, maxRamBytesUsed);
        defaultSimilarity = new BM25Similarity();
    }

    public static class LeafSlice {
        public final LeafReaderContext[] leaves;

        public LeafSlice(List<LeafReaderContext> leavesList) {
            Collections.sort(leavesList, Comparator.comparingInt(l -> l.docBase));
            this.leaves = leavesList.toArray(new LeafReaderContext[0]);
        }
    }

    private static class ShortcutHitCountCollector
    implements Collector {
        private final Weight weight;
        private final TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
        private int weightCount;

        ShortcutHitCountCollector(Weight weight) {
            this.weight = weight;
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            int count = this.weight.count(context);
            if (count == -1) {
                return this.totalHitCountCollector.getLeafCollector(context);
            }
            this.weightCount += count;
            throw new CollectionTerminatedException();
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    }

    public static class TooManyNestedClauses
    extends TooManyClauses {
        public TooManyNestedClauses() {
            super("Query contains too many nested clauses; maxClauseCount is set to " + IndexSearcher.getMaxClauseCount());
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
        private final int maxClauseCount = IndexSearcher.getMaxClauseCount();

        public TooManyClauses(String msg) {
            super(msg);
        }

        public TooManyClauses() {
            this("maxClauseCount is set to " + IndexSearcher.getMaxClauseCount());
        }

        public int getMaxClauseCount() {
            return this.maxClauseCount;
        }
    }
}

