/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class VersionStats
implements ToXContentFragment,
Writeable {
    private final Set<SingleVersionStats> versionStats;

    public static VersionStats of(Metadata metadata, List<ClusterStatsNodeResponse> nodeResponses) {
        HashMap<Version, Integer> indexCounts = new HashMap<Version, Integer>();
        HashMap<Version, Integer> primaryShardCounts = new HashMap<Version, Integer>();
        HashMap<Version, Long> primaryByteCounts = new HashMap<Version, Long>();
        HashMap<String, List> indexPrimaryShardStats = new HashMap<String, List>();
        for (ClusterStatsNodeResponse clusterStatsNodeResponse : nodeResponses) {
            for (ShardStats shardStats : clusterStatsNodeResponse.shardsStats()) {
                if (!shardStats.getShardRouting().primary()) continue;
                indexPrimaryShardStats.compute(shardStats.getShardRouting().getIndexName(), (name, stats) -> {
                    if (stats == null) {
                        ArrayList<ShardStats> newStats = new ArrayList<ShardStats>();
                        newStats.add(shardStats);
                        return newStats;
                    }
                    stats.add(shardStats);
                    return stats;
                });
            }
        }
        for (ObjectObjectCursor objectObjectCursor : metadata.indices()) {
            IndexMetadata indexMetadata = (IndexMetadata)objectObjectCursor.value;
            indexCounts.compute(indexMetadata.getCreationVersion(), (v, i) -> {
                if (i == null) {
                    return 1;
                }
                return i + 1;
            });
            primaryShardCounts.compute(indexMetadata.getCreationVersion(), (v, i) -> {
                if (i == null) {
                    return indexMetadata.getNumberOfShards();
                }
                return i + indexMetadata.getNumberOfShards();
            });
            primaryByteCounts.compute(indexMetadata.getCreationVersion(), (v, i) -> {
                String indexName = indexMetadata.getIndex().getName();
                long indexPrimarySize = indexPrimaryShardStats.getOrDefault(indexName, Collections.emptyList()).stream().mapToLong(stats -> stats.getStats().getStore().sizeInBytes()).sum();
                if (i == null) {
                    return indexPrimarySize;
                }
                return i + indexPrimarySize;
            });
        }
        ArrayList<SingleVersionStats> calculatedStats = new ArrayList<SingleVersionStats>(indexCounts.size());
        for (Map.Entry indexVersionCount : indexCounts.entrySet()) {
            Version v2 = (Version)indexVersionCount.getKey();
            SingleVersionStats singleStats = new SingleVersionStats(v2, (Integer)indexVersionCount.getValue(), primaryShardCounts.getOrDefault(v2, 0), primaryByteCounts.getOrDefault(v2, 0L));
            calculatedStats.add(singleStats);
        }
        return new VersionStats(calculatedStats);
    }

    VersionStats(Collection<SingleVersionStats> versionStats) {
        this.versionStats = Collections.unmodifiableSet(new TreeSet<SingleVersionStats>(versionStats));
    }

    VersionStats(StreamInput in) throws IOException {
        this.versionStats = Collections.unmodifiableSet(new TreeSet<SingleVersionStats>(in.readList(SingleVersionStats::new)));
    }

    public Set<SingleVersionStats> versionStats() {
        return this.versionStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("versions");
        for (SingleVersionStats stat : this.versionStats) {
            stat.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.versionStats);
    }

    public int hashCode() {
        return this.versionStats.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionStats other = (VersionStats)obj;
        return this.versionStats.equals(other.versionStats);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static class SingleVersionStats
    implements ToXContentObject,
    Writeable,
    Comparable<SingleVersionStats> {
        public final Version version;
        public final int indexCount;
        public final int primaryShardCount;
        public final long totalPrimaryByteCount;

        SingleVersionStats(Version version, int indexCount, int primaryShardCount, long totalPrimaryByteCount) {
            this.version = version;
            this.indexCount = indexCount;
            this.primaryShardCount = primaryShardCount;
            this.totalPrimaryByteCount = totalPrimaryByteCount;
        }

        SingleVersionStats(StreamInput in) throws IOException {
            this.version = Version.readVersion(in);
            this.indexCount = in.readVInt();
            this.primaryShardCount = in.readVInt();
            this.totalPrimaryByteCount = in.readVLong();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("version", this.version.toString());
            builder.field("index_count", this.indexCount);
            builder.field("primary_shard_count", this.primaryShardCount);
            builder.humanReadableField("total_primary_bytes", "total_primary_size", new ByteSizeValue(this.totalPrimaryByteCount));
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            Version.writeVersion(this.version, out);
            out.writeVInt(this.indexCount);
            out.writeVInt(this.primaryShardCount);
            out.writeVLong(this.totalPrimaryByteCount);
        }

        @Override
        public int compareTo(SingleVersionStats o) {
            if (this.equals(o)) {
                return 0;
            }
            if (this.version.equals(o.version)) {
                return -1;
            }
            return this.version.compareTo(o.version);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.indexCount, this.primaryShardCount, this.totalPrimaryByteCount);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SingleVersionStats other = (SingleVersionStats)obj;
            return this.version.equals(other.version) && this.indexCount == other.indexCount && this.primaryShardCount == other.primaryShardCount && this.totalPrimaryByteCount == other.totalPrimaryByteCount;
        }

        public String toString() {
            return Strings.toString(this);
        }
    }
}

