/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.StringBuilders;

public class ESLogMessage
extends MapMessage<ESLogMessage, Object> {
    private final List<Object> arguments = new ArrayList<Object>();
    private String messagePattern;

    public ESLogMessage(final String messagePattern, Object ... args) {
        super(new LinkedHashMap());
        Collections.addAll(this.arguments, args);
        this.messagePattern = messagePattern;
        Object message = new Object(){

            public String toString() {
                return ParameterizedMessage.format(messagePattern, ESLogMessage.this.arguments.toArray());
            }
        };
        this.with("message", message);
    }

    public ESLogMessage() {
        super(new LinkedHashMap());
    }

    public ESLogMessage argAndField(String key, Object value) {
        this.arguments.add(value);
        super.with(key, value);
        return this;
    }

    public ESLogMessage field(String key, Object value) {
        super.with(key, value);
        return this;
    }

    public ESLogMessage withFields(Map<String, Object> prepareMap) {
        prepareMap.forEach(this::field);
        return this;
    }

    protected void addJsonNoBrackets(StringBuilder sb) {
        for (int i = 0; i < this.getIndexedReadOnlyStringMap().size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('\"');
            int start = sb.length();
            sb.append(this.getIndexedReadOnlyStringMap().getKeyAt(i));
            StringBuilders.escapeJson(sb, start);
            sb.append('\"').append(':').append('\"');
            start = sb.length();
            Object value = this.getIndexedReadOnlyStringMap().getValueAt(i);
            sb.append(value);
            StringBuilders.escapeJson(sb, start);
            sb.append('\"');
        }
    }

    public static String inQuotes(String s) {
        if (s == null) {
            return ESLogMessage.inQuotes("");
        }
        return "\"" + s + "\"";
    }

    public static String inQuotes(Object s) {
        if (s == null) {
            return ESLogMessage.inQuotes("");
        }
        return ESLogMessage.inQuotes(s.toString());
    }

    public static String asJsonArray(Stream<String> stream) {
        return "[" + stream.map(ESLogMessage::inQuotes).collect(Collectors.joining(", ")) + "]";
    }

    public Object[] getArguments() {
        return this.arguments.toArray();
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }
}

