/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90Codec;
import org.apache.lucene.codecs.lucene90.Lucene90DocValuesFormat;
import org.elasticsearch.index.mapper.MapperService;

public class PerFieldMapperCodec
extends Lucene90Codec {
    private final MapperService mapperService;
    private final DocValuesFormat docValuesFormat = new Lucene90DocValuesFormat();
    static final /* synthetic */ boolean $assertionsDisabled;

    public PerFieldMapperCodec(Lucene90Codec.Mode compressionMode, MapperService mapperService) {
        super(compressionMode);
        this.mapperService = mapperService;
    }

    @Override
    public PostingsFormat getPostingsFormatForField(String field) {
        PostingsFormat format = this.mapperService.mappingLookup().getPostingsFormat(field);
        if (format == null) {
            return super.getPostingsFormatForField(field);
        }
        return format;
    }

    @Override
    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        KnnVectorsFormat format = this.mapperService.mappingLookup().getKnnVectorsFormatForField(field);
        if (format == null) {
            return super.getKnnVectorsFormatForField(field);
        }
        return format;
    }

    @Override
    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.docValuesFormat;
    }

    static {
        boolean bl = $assertionsDisabled = !PerFieldMapperCodec.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Codec.forName("Lucene90").getClass().isAssignableFrom(PerFieldMapperCodec.class)) {
            throw new AssertionError((Object)"PerFieldMapperCodec must subclass the latest lucene codec: Lucene90");
        }
    }
}

