/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.List;
import org.elasticsearch.index.fielddata.SortingBinaryDocValues;
import org.elasticsearch.script.StringFieldScript;

public final class StringScriptDocValues
extends SortingBinaryDocValues {
    private final StringFieldScript script;

    StringScriptDocValues(StringFieldScript script) {
        this.script = script;
    }

    @Override
    public boolean advanceExact(int docId) {
        List<String> results = this.script.resultsForDoc(docId);
        this.count = results.size();
        if (this.count == 0) {
            return false;
        }
        this.grow();
        int i = 0;
        for (String value : results) {
            this.values[i++].copyChars(value);
        }
        this.sort();
        return true;
    }
}

