/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.License;
import org.elasticsearch.license.PostStartTrialAction;
import org.elasticsearch.license.PostStartTrialRequest;
import org.elasticsearch.license.PostStartTrialResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestPostStartTrialLicense
extends BaseRestHandler {
    RestPostStartTrialLicense() {
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder(RestRequest.Method.POST, "/_license/start_trial").replaces(RestRequest.Method.POST, "/_xpack/license/start_trial", RestApiVersion.V_7).build());
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final PostStartTrialRequest startTrialRequest = new PostStartTrialRequest();
        startTrialRequest.setType(request.param("type", License.LicenseType.TRIAL.getTypeName()));
        startTrialRequest.acknowledge(request.paramAsBoolean("acknowledge", false));
        return channel -> client.execute(PostStartTrialAction.INSTANCE, startTrialRequest, new RestBuilderListener<PostStartTrialResponse>(channel){

            @Override
            public RestResponse buildResponse(PostStartTrialResponse response, XContentBuilder builder) throws Exception {
                PostStartTrialResponse.Status status = response.getStatus();
                builder.startObject();
                builder.field("acknowledged", startTrialRequest.isAcknowledged());
                if (status.isTrialStarted()) {
                    builder.field("trial_was_started", true);
                    builder.field("type", startTrialRequest.getType());
                } else {
                    builder.field("trial_was_started", false);
                    builder.field("error_message", status.getErrorMessage());
                }
                Map<String, String[]> acknowledgementMessages = response.getAcknowledgementMessages();
                if (!acknowledgementMessages.isEmpty()) {
                    builder.startObject("acknowledge");
                    builder.field("message", response.getAcknowledgementMessage());
                    for (Map.Entry<String, String[]> entry : acknowledgementMessages.entrySet()) {
                        builder.startArray(entry.getKey());
                        for (String message : entry.getValue()) {
                            builder.value(message);
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(status.getRestStatus(), builder);
            }
        });
    }

    @Override
    public String getName() {
        return "post_start_trial";
    }
}

