/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public abstract class AggregatorFactory {
    protected final String name;
    protected final AggregatorFactory parent;
    protected final AggregatorFactories factories;
    protected final Map<String, Object> metadata;
    protected final AggregationContext context;

    public AggregatorFactory(String name, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        this.name = name;
        this.context = context;
        this.parent = parent;
        this.factories = subFactoriesBuilder.build(context, this);
        this.metadata = metadata;
    }

    public String name() {
        return this.name;
    }

    public void doValidate() {
    }

    protected abstract Aggregator createInternal(Aggregator var1, CardinalityUpperBound var2, Map<String, Object> var3) throws IOException;

    public final Aggregator create(Aggregator parent, CardinalityUpperBound cardinality) throws IOException {
        return this.createInternal(parent, cardinality, this.metadata);
    }

    public AggregatorFactory getParent() {
        return this.parent;
    }

    public String getStatsSubtype() {
        return "other";
    }
}

