/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.QueryToFilterAdapter;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.runtime.AbstractScriptFieldQuery;

public class FilterByFilterAggregator
extends FiltersAggregator {
    private int segmentsWithDeletedDocs;
    private int segmentsWithDocCountField;
    private int segmentsCollected;
    private int segmentsCounted;

    private FilterByFilterAggregator(String name, AggregatorFactories factories, List<QueryToFilterAdapter<?>> filters, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, filters, keyed, null, context, parent, cardinality, metadata);
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        assert (!this.scoreMode().needsScores());
        if (this.filters().size() == 0) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        Bits live = ctx.reader().getLiveDocs();
        if (!this.docCountProvider.alwaysOne()) {
            ++this.segmentsWithDocCountField;
        }
        if (this.subAggregators.length == 0) {
            ++this.segmentsCounted;
            this.collectCount(ctx, live);
        } else {
            ++this.segmentsCollected;
            this.collectSubs(ctx, live, sub);
        }
        return LeafBucketCollector.NO_OP_COLLECTOR;
    }

    private void collectCount(LeafReaderContext ctx, Bits live) throws IOException {
        FiltersAggregator.Counter counter = new FiltersAggregator.Counter(this.docCountProvider);
        for (int filterOrd = 0; filterOrd < this.filters().size(); ++filterOrd) {
            this.incrementBucketDocCount(filterOrd, this.filters().get(filterOrd).count(ctx, counter, live));
        }
    }

    private void collectSubs(LeafReaderContext ctx, Bits live, final LeafBucketCollector sub) throws IOException {
        class MatchCollector
        implements LeafCollector {
            LeafBucketCollector subCollector;
            int filterOrd;

            MatchCollector() {
                this.subCollector = sub;
            }

            @Override
            public void collect(int docId) throws IOException {
                FilterByFilterAggregator.this.collectBucket(this.subCollector, docId, this.filterOrd);
            }

            @Override
            public void setScorer(Scorable scorer) throws IOException {
            }
        }
        MatchCollector collector = new MatchCollector();
        this.filters().get(0).collect(ctx, collector, live);
        for (int filterOrd = 1; filterOrd < this.filters().size(); ++filterOrd) {
            collector.subCollector = this.collectableSubAggregators.getLeafCollector(ctx);
            collector.filterOrd = filterOrd;
            this.filters().get(filterOrd).collect(ctx, collector, live);
        }
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("segments_counted", this.segmentsCounted);
        add.accept("segments_collected", this.segmentsCollected);
        add.accept("segments_with_deleted_docs", this.segmentsWithDeletedDocs);
        add.accept("segments_with_doc_count_field", this.segmentsWithDocCountField);
    }

    CheckedSupplier<Boolean, IOException> canUseMetadata(final LeafReaderContext ctx) {
        return new CheckedSupplier<Boolean, IOException>(){
            Boolean canUse;

            @Override
            public Boolean get() throws IOException {
                if (this.canUse == null) {
                    this.canUse = this.canUse();
                }
                return this.canUse;
            }

            private boolean canUse() throws IOException {
                if (ctx.reader().getLiveDocs() != null) {
                    return false;
                }
                FilterByFilterAggregator.this.docCountProvider.setLeafReaderContext(ctx);
                return FilterByFilterAggregator.this.docCountProvider.alwaysOne();
            }
        };
    }

    public static abstract class AdapterBuilder<T> {
        private final String name;
        private final List<QueryToFilterAdapter<?>> filters = new ArrayList();
        private final boolean keyed;
        private final AggregationContext context;
        private final Aggregator parent;
        private final CardinalityUpperBound cardinality;
        private final Map<String, Object> metadata;
        private final Query rewrittenTopLevelQuery;
        private boolean valid = true;

        public AdapterBuilder(String name, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            this.name = name;
            this.keyed = keyed;
            this.context = context;
            this.parent = parent;
            this.cardinality = cardinality;
            this.metadata = metadata;
            this.rewrittenTopLevelQuery = context.searcher().rewrite(context.query());
            this.valid = parent == null && otherBucketKey == null;
        }

        protected abstract T adapt(CheckedFunction<AggregatorFactories, FilterByFilterAggregator, IOException> var1) throws IOException;

        public final void add(String key, Query query) throws IOException {
            if (!this.valid) {
                return;
            }
            if (query instanceof AbstractScriptFieldQuery) {
                this.valid = false;
                return;
            }
            this.add(QueryToFilterAdapter.build(this.context.searcher(), key, query));
        }

        final void add(QueryToFilterAdapter<?> filter) throws IOException {
            QueryToFilterAdapter<?> mergedFilter = filter.union(this.rewrittenTopLevelQuery);
            if (mergedFilter.isInefficientUnion()) {
                this.valid = false;
                return;
            }
            this.filters.add(mergedFilter);
        }

        public final T build() throws IOException {
            if (!this.valid) {
                return null;
            }
            class AdapterBuild
            implements CheckedFunction<AggregatorFactories, FilterByFilterAggregator, IOException> {
                private FilterByFilterAggregator agg;

                AdapterBuild() {
                }

                @Override
                public FilterByFilterAggregator apply(AggregatorFactories subAggregators) throws IOException {
                    this.agg = new FilterByFilterAggregator(AdapterBuilder.this.name, subAggregators, AdapterBuilder.this.filters, AdapterBuilder.this.keyed, AdapterBuilder.this.context, AdapterBuilder.this.parent, AdapterBuilder.this.cardinality, AdapterBuilder.this.metadata);
                    return this.agg;
                }
            }
            AdapterBuild adapterBuild = new AdapterBuild();
            T result = this.adapt(adapterBuild);
            if (adapterBuild.agg.scoreMode().needsScores()) {
                return null;
            }
            return result;
        }
    }
}

