/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.AbstractSortingNumericDocValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;

abstract class CellValues
extends AbstractSortingNumericDocValues {
    private MultiGeoPointValues geoValues;
    protected int precision;

    protected CellValues(MultiGeoPointValues geoValues, int precision) {
        this.geoValues = geoValues;
        this.precision = precision;
    }

    @Override
    public boolean advanceExact(int docId) throws IOException {
        if (this.geoValues.advanceExact(docId)) {
            int docValueCount = this.geoValues.docValueCount();
            this.resize(docValueCount);
            int j = 0;
            for (int i = 0; i < docValueCount; ++i) {
                j = this.advanceValue(this.geoValues.nextValue(), j);
            }
            this.resize(j);
            this.sort();
            return true;
        }
        return false;
    }

    abstract int advanceValue(GeoPoint var1, int var2);
}

