/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.DateIntervalConsumer;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DateIntervalWrapper
implements ToXContentFragment,
Writeable {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(DateHistogramAggregationBuilder.class);
    private static final String DEPRECATION_TEXT = "[interval] on [date_histogram] is deprecated, use [fixed_interval] or [calendar_interval] in the future.";
    private static final ParseField FIXED_INTERVAL_FIELD = new ParseField("fixed_interval", new String[0]);
    private static final ParseField CALENDAR_INTERVAL_FIELD = new ParseField("calendar_interval", new String[0]);
    private DateHistogramInterval dateHistogramInterval;
    private IntervalTypeEnum intervalType = IntervalTypeEnum.NONE;

    public static <T extends DateIntervalConsumer<T>> void declareIntervalFields(ObjectParser<T, String> parser) {
        parser.declareField((wrapper, interval) -> {
            DEPRECATION_LOGGER.critical(DeprecationCategory.AGGREGATIONS, "date-interval-getter", DEPRECATION_TEXT, new Object[0]);
            if (interval instanceof Long) {
                wrapper.fixedInterval(new DateHistogramInterval(interval + "ms"));
            } else if (interval != null && DateHistogramAggregationBuilder.DATE_FIELD_UNITS.containsKey(interval.toString())) {
                wrapper.calendarInterval((DateHistogramInterval)interval);
            } else {
                wrapper.fixedInterval((DateHistogramInterval)interval);
            }
        }, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return new DateHistogramInterval(p.text());
        }, Histogram.INTERVAL_FIELD.forRestApiVersion(RestApiVersion.equalTo(RestApiVersion.V_7)), ObjectParser.ValueType.LONG);
        parser.declareField(DateIntervalConsumer::calendarInterval, p -> new DateHistogramInterval(p.text()), CALENDAR_INTERVAL_FIELD, ObjectParser.ValueType.STRING);
        parser.declareField(DateIntervalConsumer::fixedInterval, p -> new DateHistogramInterval(p.text()), FIXED_INTERVAL_FIELD, ObjectParser.ValueType.STRING);
    }

    public DateIntervalWrapper() {
    }

    public DateIntervalWrapper(StreamInput in) throws IOException {
        this.dateHistogramInterval = in.readOptionalWriteable(DateHistogramInterval::new);
        this.intervalType = IntervalTypeEnum.fromStream(in);
    }

    public IntervalTypeEnum getIntervalType() {
        return this.intervalType;
    }

    public DateHistogramInterval getAsCalendarInterval() {
        if (this.intervalType.equals(IntervalTypeEnum.CALENDAR)) {
            return this.dateHistogramInterval;
        }
        throw new IllegalStateException("Cannot convert [" + this.intervalType.toString() + "] interval type into calendar interval");
    }

    public void calendarInterval(DateHistogramInterval interval) {
        if (interval == null || Strings.isNullOrEmpty(interval.toString())) {
            throw new IllegalArgumentException("[interval] must not be null: [date_histogram]");
        }
        if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(interval.toString()) == null) {
            throw new IllegalArgumentException("The supplied interval [" + interval + "] could not be parsed as a calendar interval.");
        }
        this.setIntervalType(IntervalTypeEnum.CALENDAR);
        this.dateHistogramInterval = interval;
    }

    public DateHistogramInterval getAsFixedInterval() {
        if (this.intervalType.equals(IntervalTypeEnum.FIXED) || this.tryIntervalAsFixedUnit() != null) {
            return this.dateHistogramInterval;
        }
        throw new IllegalStateException("Cannot convert [" + this.intervalType.toString() + "] interval type into fixed interval");
    }

    public void fixedInterval(DateHistogramInterval interval) {
        if (interval == null || Strings.isNullOrEmpty(interval.toString())) {
            throw new IllegalArgumentException("[interval] must not be null: [date_histogram]");
        }
        this.setIntervalType(IntervalTypeEnum.FIXED);
        TimeValue.parseTimeValue(interval.toString(), "date_histogram.fixedInterval");
        this.dateHistogramInterval = interval;
    }

    Rounding.DateTimeUnit tryIntervalAsCalendarUnit() {
        if (this.intervalType.equals(IntervalTypeEnum.CALENDAR)) {
            return DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(this.dateHistogramInterval.toString());
        }
        return null;
    }

    TimeValue tryIntervalAsFixedUnit() {
        if (this.dateHistogramInterval == null || Strings.isNullOrEmpty(this.dateHistogramInterval.toString())) {
            return null;
        }
        try {
            return TimeValue.parseTimeValue(this.dateHistogramInterval.toString(), null, this.getClass().getSimpleName() + ".interval");
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Rounding createRounding(ZoneId timeZone, long offset) {
        Rounding.Builder tzRoundingBuilder;
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Invalid interval specified, must be non-null and non-empty");
        }
        IntervalTypeEnum intervalType = this.getIntervalType();
        if (intervalType.equals(IntervalTypeEnum.FIXED)) {
            tzRoundingBuilder = Rounding.builder(this.tryIntervalAsFixedUnit());
        } else if (intervalType.equals(IntervalTypeEnum.CALENDAR)) {
            tzRoundingBuilder = Rounding.builder(this.tryIntervalAsCalendarUnit());
        } else {
            throw new IllegalArgumentException("Unable to parse interval [" + this.dateHistogramInterval + "]");
        }
        if (timeZone != null) {
            tzRoundingBuilder.timeZone(timeZone);
        }
        tzRoundingBuilder.offset(offset);
        return tzRoundingBuilder.build();
    }

    private void setIntervalType(IntervalTypeEnum type) {
        if (this.intervalType.equals(IntervalTypeEnum.NONE) || type.equals(this.intervalType)) {
            this.intervalType = type;
            return;
        }
        if (!type.isValid() || !this.intervalType.isValid()) {
            throw new IllegalArgumentException("Unknown interval type.");
        }
        throw new IllegalArgumentException("Cannot use [" + type.getPreferredName() + "] with [" + this.intervalType.getPreferredName() + "] configuration option.");
    }

    public boolean isEmpty() {
        if (this.intervalType.equals(IntervalTypeEnum.NONE)) {
            return true;
        }
        return this.dateHistogramInterval == null || Strings.isNullOrEmpty(this.dateHistogramInterval.toString());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.dateHistogramInterval);
        this.intervalType.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.intervalType.equals(IntervalTypeEnum.FIXED)) {
            builder.field(FIXED_INTERVAL_FIELD.getPreferredName(), this.dateHistogramInterval.toString());
        } else if (this.intervalType.equals(IntervalTypeEnum.CALENDAR)) {
            builder.field(CALENDAR_INTERVAL_FIELD.getPreferredName(), this.dateHistogramInterval.toString());
        }
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateIntervalWrapper that = (DateIntervalWrapper)other;
        if (this.tryIntervalAsCalendarUnit() != null && that.tryIntervalAsCalendarUnit() == null) {
            return false;
        }
        if (this.tryIntervalAsCalendarUnit() == null && that.tryIntervalAsCalendarUnit() != null) {
            return false;
        }
        return Objects.equals(this.dateHistogramInterval, that.dateHistogramInterval);
    }

    public int hashCode() {
        boolean isCalendar = this.tryIntervalAsCalendarUnit() != null;
        return Objects.hash(this.dateHistogramInterval, isCalendar);
    }

    public static enum IntervalTypeEnum implements Writeable
    {
        NONE("none"),
        FIXED(FIXED_INTERVAL_FIELD.getPreferredName()),
        CALENDAR(CALENDAR_INTERVAL_FIELD.getPreferredName()),
        LEGACY_INTERVAL(null),
        LEGACY_DATE_HISTO(null);

        private String preferredName;

        public static IntervalTypeEnum fromString(String name) {
            return IntervalTypeEnum.valueOf(name.trim().toUpperCase(Locale.ROOT));
        }

        public static IntervalTypeEnum fromStream(StreamInput in) throws IOException {
            return in.readEnum(IntervalTypeEnum.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isValid() {
            return this.preferredName != null;
        }

        public String getPreferredName() {
            if (this.preferredName == null) {
                throw new IllegalStateException("Invalid use of legacy date histogram interval");
            }
            return this.preferredName;
        }

        private IntervalTypeEnum(String preferredName) {
            this.preferredName = preferredName;
        }
    }
}

