/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.MaxScoreCollector;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.ScriptScoreQuery;
import org.elasticsearch.common.util.CachedSupplier;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.search.ESToParentBlockJoinQuery;
import org.elasticsearch.lucene.grouping.SinglePassGroupingCollector;
import org.elasticsearch.lucene.grouping.TopFieldGroups;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.EarlyTerminatingCollector;
import org.elasticsearch.search.query.QueryCollectorContext;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.sort.SortAndFormats;

abstract class TopDocsCollectorContext
extends QueryCollectorContext {
    protected final int numHits;

    TopDocsCollectorContext(String profilerName, int numHits) {
        super(profilerName);
        this.numHits = numHits;
    }

    final int numHits() {
        return this.numHits;
    }

    boolean shouldRescore() {
        return false;
    }

    static int shortcutTotalHitCount(IndexReader reader, Query query) throws IOException {
        while (true) {
            if (query instanceof ConstantScoreQuery) {
                query = ((ConstantScoreQuery)query).getQuery();
                continue;
            }
            if (!(query instanceof BoostQuery)) break;
            query = ((BoostQuery)query).getQuery();
        }
        if (query.getClass() == MatchAllDocsQuery.class) {
            return reader.numDocs();
        }
        if (query.getClass() == TermQuery.class && !reader.hasDeletions()) {
            Term term = ((TermQuery)query).getTerm();
            int count = 0;
            for (LeafReaderContext context : reader.leaves()) {
                count += context.reader().docFreq(term);
            }
            return count;
        }
        if (query.getClass() == DocValuesFieldExistsQuery.class && !reader.hasDeletions()) {
            String field = ((DocValuesFieldExistsQuery)query).getField();
            int count = 0;
            for (LeafReaderContext context : reader.leaves()) {
                FieldInfos fieldInfos = context.reader().getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                if (fieldInfo == null) continue;
                if (fieldInfo.getPointIndexDimensionCount() > 0) {
                    PointValues points = context.reader().getPointValues(field);
                    if (points == null) continue;
                    count += points.getDocCount();
                    continue;
                }
                if (fieldInfo.getIndexOptions() != IndexOptions.NONE) {
                    Terms terms = context.reader().terms(field);
                    if (terms == null) continue;
                    count += terms.getDocCount();
                    continue;
                }
                return -1;
            }
            return count;
        }
        return -1;
    }

    static TopDocsCollectorContext createTopDocsCollectorContext(SearchContext searchContext, boolean hasFilterCollector) throws IOException {
        boolean rescore;
        IndexReader reader = searchContext.searcher().getIndexReader();
        Query query = searchContext.rewrittenQuery();
        int totalNumDocs = Math.max(1, reader.numDocs());
        if (searchContext.size() == 0) {
            return new EmptyTopDocsCollectorContext(reader, query, searchContext.sort(), searchContext.trackTotalHitsUpTo(), hasFilterCollector);
        }
        if (searchContext.scrollContext() != null) {
            int trackTotalHitsUpTo = searchContext.scrollContext().totalHits != null ? -1 : Integer.MAX_VALUE;
            int numDocs = Math.min(searchContext.size(), totalNumDocs);
            return new ScrollingTopDocsCollectorContext(reader, query, searchContext.scrollContext(), searchContext.sort(), numDocs, searchContext.trackScores(), searchContext.numberOfShards(), trackTotalHitsUpTo, hasFilterCollector);
        }
        if (searchContext.collapse() != null) {
            boolean trackScores = searchContext.sort() == null ? true : searchContext.trackScores();
            int numDocs = Math.min(searchContext.from() + searchContext.size(), totalNumDocs);
            return new CollapsingTopDocsCollectorContext(searchContext.collapse(), searchContext.sort(), numDocs, trackScores, searchContext.searchAfter());
        }
        int numDocs = Math.min(searchContext.from() + searchContext.size(), totalNumDocs);
        boolean bl = rescore = !searchContext.rescore().isEmpty();
        if (rescore) {
            assert (searchContext.sort() == null);
            for (RescoreContext rescoreContext : searchContext.rescore()) {
                numDocs = Math.max(numDocs, rescoreContext.getWindowSize());
            }
        }
        return new SimpleTopDocsCollectorContext(reader, query, searchContext.sort(), searchContext.searchAfter(), numDocs, searchContext.trackScores(), searchContext.trackTotalHitsUpTo(), hasFilterCollector){

            @Override
            boolean shouldRescore() {
                return rescore;
            }
        };
    }

    static boolean hasInfMaxScore(Query query) {
        MaxScoreQueryVisitor visitor = new MaxScoreQueryVisitor();
        query.visit(visitor);
        return visitor.hasInfMaxScore;
    }

    static class EmptyTopDocsCollectorContext
    extends TopDocsCollectorContext {
        private final Sort sort;
        private final Collector collector;
        private final Supplier<TotalHits> hitCountSupplier;

        private EmptyTopDocsCollectorContext(IndexReader reader, Query query, @Nullable SortAndFormats sortAndFormats, int trackTotalHitsUpTo, boolean hasFilterCollector) throws IOException {
            super("search_count", 0);
            Sort sort = this.sort = sortAndFormats == null ? null : sortAndFormats.sort;
            if (trackTotalHitsUpTo == -1) {
                this.collector = new EarlyTerminatingCollector(new TotalHitCountCollector(), 0, false);
                this.hitCountSupplier = () -> new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
            } else {
                int hitCount;
                TotalHitCountCollector hitCountCollector = new TotalHitCountCollector();
                int n = hitCount = hasFilterCollector ? -1 : EmptyTopDocsCollectorContext.shortcutTotalHitCount(reader, query);
                if (hitCount == -1) {
                    if (trackTotalHitsUpTo == Integer.MAX_VALUE) {
                        this.collector = hitCountCollector;
                        this.hitCountSupplier = () -> new TotalHits(hitCountCollector.getTotalHits(), TotalHits.Relation.EQUAL_TO);
                    } else {
                        EarlyTerminatingCollector col = new EarlyTerminatingCollector(hitCountCollector, trackTotalHitsUpTo, false);
                        this.collector = col;
                        this.hitCountSupplier = () -> new TotalHits(hitCountCollector.getTotalHits(), col.hasEarlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO);
                    }
                } else {
                    this.collector = new EarlyTerminatingCollector(hitCountCollector, 0, false);
                    this.hitCountSupplier = () -> new TotalHits(hitCount, TotalHits.Relation.EQUAL_TO);
                }
            }
        }

        @Override
        Collector create(Collector in) {
            assert (in == null);
            return this.collector;
        }

        @Override
        void postProcess(QuerySearchResult result) {
            TotalHits totalHitCount = this.hitCountSupplier.get();
            TopDocs topDocs = this.sort != null ? new TopFieldDocs(totalHitCount, Lucene.EMPTY_SCORE_DOCS, this.sort.getSort()) : new TopDocs(totalHitCount, Lucene.EMPTY_SCORE_DOCS);
            result.topDocs(new TopDocsAndMaxScore(topDocs, Float.NaN), null);
        }
    }

    static class ScrollingTopDocsCollectorContext
    extends SimpleTopDocsCollectorContext {
        private final ScrollContext scrollContext;
        private final int numberOfShards;

        private ScrollingTopDocsCollectorContext(IndexReader reader, Query query, ScrollContext scrollContext, @Nullable SortAndFormats sortAndFormats, int numHits, boolean trackMaxScore, int numberOfShards, int trackTotalHitsUpTo, boolean hasFilterCollector) throws IOException {
            super(reader, query, sortAndFormats, scrollContext.lastEmittedDoc, numHits, trackMaxScore, trackTotalHitsUpTo, hasFilterCollector);
            this.scrollContext = Objects.requireNonNull(scrollContext);
            this.numberOfShards = numberOfShards;
        }

        @Override
        void postProcess(QuerySearchResult result) throws IOException {
            TopDocsAndMaxScore topDocs = this.newTopDocs();
            if (this.scrollContext.totalHits == null) {
                this.scrollContext.totalHits = topDocs.topDocs.totalHits;
                this.scrollContext.maxScore = topDocs.maxScore;
            } else {
                topDocs.topDocs.totalHits = this.scrollContext.totalHits;
                topDocs.maxScore = this.scrollContext.maxScore;
            }
            if (this.numberOfShards == 1 && topDocs.topDocs.scoreDocs.length > 0) {
                this.scrollContext.lastEmittedDoc = topDocs.topDocs.scoreDocs[topDocs.topDocs.scoreDocs.length - 1];
            }
            result.topDocs(topDocs, this.sortAndFormats == null ? null : this.sortAndFormats.formats);
        }
    }

    static class CollapsingTopDocsCollectorContext
    extends TopDocsCollectorContext {
        private final DocValueFormat[] sortFmt;
        private final SinglePassGroupingCollector<?> topDocsCollector;
        private final Supplier<Float> maxScoreSupplier;

        private CollapsingTopDocsCollectorContext(CollapseContext collapseContext, @Nullable SortAndFormats sortAndFormats, int numHits, boolean trackMaxScore, @Nullable FieldDoc after) {
            super("search_top_hits", numHits);
            DocValueFormat[] docValueFormatArray;
            Sort sort;
            assert (numHits > 0);
            assert (collapseContext != null);
            Sort sort2 = sort = sortAndFormats == null ? Sort.RELEVANCE : sortAndFormats.sort;
            if (sortAndFormats == null) {
                DocValueFormat[] docValueFormatArray2 = new DocValueFormat[1];
                docValueFormatArray = docValueFormatArray2;
                docValueFormatArray2[0] = DocValueFormat.RAW;
            } else {
                docValueFormatArray = sortAndFormats.formats;
            }
            this.sortFmt = docValueFormatArray;
            this.topDocsCollector = collapseContext.createTopDocs(sort, numHits, after);
            if (trackMaxScore) {
                MaxScoreCollector maxScoreCollector = new MaxScoreCollector();
                this.maxScoreSupplier = maxScoreCollector::getMaxScore;
            } else {
                this.maxScoreSupplier = () -> Float.valueOf(Float.NaN);
            }
        }

        @Override
        Collector create(Collector in) throws IOException {
            assert (in == null);
            return this.topDocsCollector;
        }

        @Override
        void postProcess(QuerySearchResult result) throws IOException {
            TopFieldGroups topDocs = this.topDocsCollector.getTopGroups(0);
            result.topDocs(new TopDocsAndMaxScore(topDocs, this.maxScoreSupplier.get().floatValue()), this.sortFmt);
        }
    }

    private static class MaxScoreQueryVisitor
    extends QueryVisitor {
        private boolean hasInfMaxScore;

        private MaxScoreQueryVisitor() {
        }

        @Override
        public void visitLeaf(Query query) {
            this.checkMaxScoreInfo(query);
        }

        @Override
        public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
            if (occur != BooleanClause.Occur.MUST) {
                return QueryVisitor.EMPTY_VISITOR;
            }
            this.checkMaxScoreInfo(parent);
            return this;
        }

        void checkMaxScoreInfo(Query query) {
            if (query instanceof FunctionScoreQuery || query instanceof ScriptScoreQuery || query instanceof SpanQuery) {
                this.hasInfMaxScore = true;
            } else if (query instanceof ESToParentBlockJoinQuery) {
                ESToParentBlockJoinQuery q = (ESToParentBlockJoinQuery)query;
                this.hasInfMaxScore |= q.getScoreMode() != ScoreMode.None;
            }
        }
    }

    static abstract class SimpleTopDocsCollectorContext
    extends TopDocsCollectorContext {
        @Nullable
        protected final SortAndFormats sortAndFormats;
        private final Collector collector;
        private final Supplier<TotalHits> totalHitsSupplier;
        private final Supplier<TopDocs> topDocsSupplier;
        private final Supplier<Float> maxScoreSupplier;

        private static TopDocsCollector<?> createCollector(@Nullable SortAndFormats sortAndFormats, int numHits, @Nullable ScoreDoc searchAfter, int hitCountThreshold) {
            if (sortAndFormats == null) {
                return TopScoreDocCollector.create(numHits, searchAfter, hitCountThreshold);
            }
            return TopFieldCollector.create(sortAndFormats.sort, numHits, (FieldDoc)searchAfter, hitCountThreshold);
        }

        private SimpleTopDocsCollectorContext(IndexReader reader, Query query, @Nullable SortAndFormats sortAndFormats, @Nullable ScoreDoc searchAfter, int numHits, boolean trackMaxScore, int trackTotalHitsUpTo, boolean hasFilterCollector) throws IOException {
            super("search_top_hits", numHits);
            TopDocsCollector<?> topDocsCollector;
            this.sortAndFormats = sortAndFormats;
            if ((sortAndFormats == null || SortField.FIELD_SCORE.equals(sortAndFormats.sort.getSort()[0])) && SimpleTopDocsCollectorContext.hasInfMaxScore(query)) {
                topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, Integer.MAX_VALUE);
                this.topDocsSupplier = new CachedSupplier<TopDocs>(topDocsCollector::topDocs);
                this.totalHitsSupplier = () -> this.topDocsSupplier.get().totalHits;
            } else if (trackTotalHitsUpTo == -1) {
                topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, 1);
                this.topDocsSupplier = new CachedSupplier<TopDocs>(topDocsCollector::topDocs);
                this.totalHitsSupplier = () -> new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
            } else {
                int hitCount;
                int n = hitCount = hasFilterCollector ? -1 : SimpleTopDocsCollectorContext.shortcutTotalHitCount(reader, query);
                if (hitCount == -1) {
                    topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, trackTotalHitsUpTo);
                    this.topDocsSupplier = new CachedSupplier<TopDocs>(topDocsCollector::topDocs);
                    this.totalHitsSupplier = () -> this.topDocsSupplier.get().totalHits;
                } else {
                    topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, 1);
                    this.topDocsSupplier = new CachedSupplier<TopDocs>(topDocsCollector::topDocs);
                    this.totalHitsSupplier = () -> new TotalHits(hitCount, TotalHits.Relation.EQUAL_TO);
                }
            }
            MaxScoreCollector maxScoreCollector = null;
            if (sortAndFormats == null) {
                this.maxScoreSupplier = () -> {
                    TopDocs topDocs = this.topDocsSupplier.get();
                    if (topDocs.scoreDocs.length == 0) {
                        return Float.valueOf(Float.NaN);
                    }
                    return Float.valueOf(topDocs.scoreDocs[0].score);
                };
            } else if (trackMaxScore) {
                maxScoreCollector = new MaxScoreCollector();
                this.maxScoreSupplier = maxScoreCollector::getMaxScore;
            } else {
                this.maxScoreSupplier = () -> Float.valueOf(Float.NaN);
            }
            this.collector = MultiCollector.wrap(topDocsCollector, maxScoreCollector);
        }

        @Override
        Collector create(Collector in) {
            assert (in == null);
            return this.collector;
        }

        TopDocsAndMaxScore newTopDocs() {
            TopDocs newTopDocs;
            TopDocs in = this.topDocsSupplier.get();
            float maxScore = this.maxScoreSupplier.get().floatValue();
            if (in instanceof TopFieldDocs) {
                TopFieldDocs fieldDocs = (TopFieldDocs)in;
                newTopDocs = new TopFieldDocs(this.totalHitsSupplier.get(), fieldDocs.scoreDocs, fieldDocs.fields);
            } else {
                newTopDocs = new TopDocs(this.totalHitsSupplier.get(), in.scoreDocs);
            }
            return new TopDocsAndMaxScore(newTopDocs, maxScore);
        }

        @Override
        void postProcess(QuerySearchResult result) throws IOException {
            TopDocsAndMaxScore topDocs = this.newTopDocs();
            result.topDocs(topDocs, this.sortAndFormats == null ? null : this.sortAndFormats.formats);
        }
    }
}

