/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.ParsedMediaType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilderExtension;
import org.elasticsearch.xcontent.XContentGenerator;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public final class XContentBuilder
implements Closeable,
Flushable {
    private static final Map<Class<?>, Writer> WRITERS;
    private static final Map<Class<?>, HumanReadableTransformer> HUMAN_READABLE_TRANSFORMERS;
    private static final Map<Class<?>, Function<Object, Object>> DATE_TRANSFORMERS;
    private final XContentGenerator generator;
    private final OutputStream bos;
    private final RestApiVersion restApiVersion;
    private final ParsedMediaType responseContentType;
    private boolean humanReadable = false;

    public static XContentBuilder builder(XContent xContent) throws IOException {
        return new XContentBuilder(xContent, new ByteArrayOutputStream());
    }

    public static XContentBuilder builder(XContent xContent, RestApiVersion restApiVersion) throws IOException {
        return new XContentBuilder(xContent, new ByteArrayOutputStream(), Collections.emptySet(), Collections.emptySet(), xContent.type().toParsedMediaType(), restApiVersion);
    }

    public static XContentBuilder builder(XContentType xContentType, Set<String> includes, Set<String> excludes) throws IOException {
        return new XContentBuilder(xContentType.xContent(), new ByteArrayOutputStream(), includes, excludes, xContentType.toParsedMediaType(), RestApiVersion.current());
    }

    public XContentBuilder(XContent xContent, OutputStream bos) throws IOException {
        this(xContent, bos, Collections.emptySet(), Collections.emptySet(), xContent.type().toParsedMediaType(), RestApiVersion.current());
    }

    public XContentBuilder(XContentType xContentType, OutputStream bos, Set<String> includes) throws IOException {
        this(xContentType.xContent(), bos, includes, Collections.emptySet(), xContentType.toParsedMediaType(), RestApiVersion.current());
    }

    public XContentBuilder(XContent xContent, OutputStream os, Set<String> includes, Set<String> excludes, ParsedMediaType responseContentType) throws IOException {
        this(xContent, os, includes, excludes, responseContentType, RestApiVersion.current());
    }

    public XContentBuilder(XContent xContent, OutputStream os, Set<String> includes, Set<String> excludes, ParsedMediaType responseContentType, RestApiVersion restApiVersion) throws IOException {
        this.bos = os;
        assert (responseContentType != null) : "generated response cannot be null";
        this.responseContentType = responseContentType;
        this.generator = xContent.createGenerator(this.bos, includes, excludes);
        this.restApiVersion = restApiVersion;
    }

    public String getResponseContentTypeString() {
        return this.responseContentType.responseContentTypeHeader();
    }

    public XContentType contentType() {
        return this.generator.contentType();
    }

    public OutputStream getOutputStream() {
        return this.bos;
    }

    public XContentBuilder prettyPrint() {
        this.generator.usePrettyPrint();
        return this;
    }

    public boolean isPrettyPrint() {
        return this.generator.isPrettyPrint();
    }

    public XContentBuilder lfAtEnd() {
        this.generator.usePrintLineFeedAtEnd();
        return this;
    }

    public XContentBuilder humanReadable(boolean isHumanReadable) {
        this.humanReadable = isHumanReadable;
        return this;
    }

    public boolean humanReadable() {
        return this.humanReadable;
    }

    public XContentBuilder object(String name, CheckedConsumer<XContentBuilder, IOException> callback) throws IOException {
        this.field(name).startObject();
        callback.accept(this);
        return this.endObject();
    }

    public XContentBuilder startObject() throws IOException {
        this.generator.writeStartObject();
        return this;
    }

    public XContentBuilder startObject(String name) throws IOException {
        return this.field(name).startObject();
    }

    public XContentBuilder endObject() throws IOException {
        this.generator.writeEndObject();
        return this;
    }

    public XContentBuilder array(String name, CheckedConsumer<XContentBuilder, IOException> callback) throws IOException {
        this.field(name).startArray();
        callback.accept(this);
        return this.endArray();
    }

    public XContentBuilder startArray() throws IOException {
        this.generator.writeStartArray();
        return this;
    }

    public XContentBuilder startArray(String name) throws IOException {
        return this.field(name).startArray();
    }

    public XContentBuilder endArray() throws IOException {
        this.generator.writeEndArray();
        return this;
    }

    public XContentBuilder field(String name) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeFieldName(name);
        return this;
    }

    public XContentBuilder nullField(String name) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNullField(name);
        return this;
    }

    public XContentBuilder nullValue() throws IOException {
        this.generator.writeNull();
        return this;
    }

    public XContentBuilder field(String name, Boolean value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (boolean)value);
    }

    public XContentBuilder field(String name, boolean value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeBooleanField(name, value);
        return this;
    }

    public XContentBuilder array(String name, boolean[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(boolean[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (boolean b : values) {
            this.value(b);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Boolean value) throws IOException {
        return value == null ? this.nullValue() : this.value((boolean)value);
    }

    public XContentBuilder value(boolean value) throws IOException {
        this.generator.writeBoolean(value);
        return this;
    }

    public XContentBuilder field(String name, Byte value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (byte)value);
    }

    public XContentBuilder field(String name, byte value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder value(Byte value) throws IOException {
        return value == null ? this.nullValue() : this.value((byte)value);
    }

    public XContentBuilder value(byte value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Double value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (double)value);
    }

    public XContentBuilder field(String name, double value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, double[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(double[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (double b : values) {
            this.value(b);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Double value) throws IOException {
        return value == null ? this.nullValue() : this.value((double)value);
    }

    public XContentBuilder value(double value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Float value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, value.floatValue());
    }

    public XContentBuilder field(String name, float value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, float[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(float[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (float f : values) {
            this.value(f);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Float value) throws IOException {
        return value == null ? this.nullValue() : this.value(value.floatValue());
    }

    public XContentBuilder value(float value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Integer value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (int)value);
    }

    public XContentBuilder field(String name, int value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, int[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(int[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (int i : values) {
            this.value(i);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Integer value) throws IOException {
        return value == null ? this.nullValue() : this.value((int)value);
    }

    public XContentBuilder value(int value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Long value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (long)value);
    }

    public XContentBuilder field(String name, long value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, long[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(long[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (long l : values) {
            this.value(l);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Long value) throws IOException {
        return value == null ? this.nullValue() : this.value((long)value);
    }

    public XContentBuilder value(long value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Short value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (short)value);
    }

    public XContentBuilder field(String name, short value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder array(String name, short[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(short[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (short s : values) {
            this.value(s);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Short value) throws IOException {
        return value == null ? this.nullValue() : this.value((short)value);
    }

    public XContentBuilder value(short value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, BigInteger value) throws IOException {
        if (value == null) {
            return this.nullField(name);
        }
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, BigInteger[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(BigInteger[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (BigInteger b : values) {
            this.value(b);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(BigInteger value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, BigDecimal value) throws IOException {
        if (value == null) {
            return this.nullField(name);
        }
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, BigDecimal[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(BigDecimal[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (BigDecimal b : values) {
            this.value(b);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(BigDecimal value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, String value) throws IOException {
        if (value == null) {
            return this.nullField(name);
        }
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeStringField(name, value);
        return this;
    }

    public XContentBuilder array(String name, String ... values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(String[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (String s : values) {
            this.value(s);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeString(value);
        return this;
    }

    public XContentBuilder field(String name, byte[] value) throws IOException {
        if (value == null) {
            return this.nullField(name);
        }
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeBinaryField(name, value);
        return this;
    }

    public XContentBuilder value(byte[] value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value);
        return this;
    }

    public XContentBuilder field(String name, byte[] value, int offset, int length) throws IOException {
        return this.field(name).value(value, offset, length);
    }

    public XContentBuilder value(byte[] value, int offset, int length) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value, offset, length);
        return this;
    }

    public XContentBuilder utf8Value(byte[] bytes, int offset, int length) throws IOException {
        this.generator.writeUTF8String(bytes, offset, length);
        return this;
    }

    public XContentBuilder timeField(String name, Object timeValue) throws IOException {
        return this.field(name).timeValue(timeValue);
    }

    public XContentBuilder timeField(String name, String readableName, long value) throws IOException {
        assert (!name.equals(readableName)) : "expected raw and readable field names to differ, but they were both: " + name;
        if (this.humanReadable) {
            Function<Object, Object> longTransformer = DATE_TRANSFORMERS.get(Long.class);
            if (longTransformer == null) {
                throw new IllegalArgumentException("cannot write time value xcontent for unknown value of type Long");
            }
            this.field(readableName).value(longTransformer.apply(value));
        }
        this.field(name, value);
        return this;
    }

    public XContentBuilder timeValue(Object timeValue) throws IOException {
        if (timeValue == null) {
            return this.nullValue();
        }
        Function<Object, Object> transformer = DATE_TRANSFORMERS.get(timeValue.getClass());
        if (transformer == null) {
            throw new IllegalArgumentException("cannot write time value xcontent for unknown value of type " + timeValue.getClass());
        }
        return this.value(transformer.apply(timeValue));
    }

    public XContentBuilder latlon(String name, double lat, double lon) throws IOException {
        return this.field(name).latlon(lat, lon);
    }

    public XContentBuilder latlon(double lat, double lon) throws IOException {
        return this.startObject().field("lat", lat).field("lon", lon).endObject();
    }

    public XContentBuilder value(Path value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value(value.toString());
    }

    public XContentBuilder field(String name, Object value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder array(String name, Object ... values) throws IOException {
        return this.field(name).values(values, true);
    }

    private XContentBuilder values(Object[] values, boolean ensureNoSelfReferences) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        return this.value(Arrays.asList(values), ensureNoSelfReferences);
    }

    public XContentBuilder value(Object value) throws IOException {
        this.unknownValue(value, true);
        return this;
    }

    private void unknownValue(Object value, boolean ensureNoSelfReferences) throws IOException {
        if (value == null) {
            this.nullValue();
            return;
        }
        Writer writer = WRITERS.get(value.getClass());
        if (writer != null) {
            writer.write(this, value);
        } else if (value instanceof Path) {
            this.value((Path)value);
        } else if (value instanceof Map) {
            Map valueMap = (Map)value;
            this.map(valueMap, ensureNoSelfReferences, true);
        } else if (value instanceof Iterable) {
            this.value((Iterable)value, ensureNoSelfReferences);
        } else if (value instanceof Object[]) {
            this.values((Object[])value, ensureNoSelfReferences);
        } else if (value instanceof ToXContent) {
            this.value((ToXContent)value);
        } else if (value instanceof Enum) {
            this.value(Objects.toString(value));
        } else {
            throw new IllegalArgumentException("cannot write xcontent for unknown value of type " + value.getClass());
        }
    }

    public XContentBuilder field(String name, ToXContent value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder field(String name, ToXContent value, ToXContent.Params params) throws IOException {
        return this.field(name).value(value, params);
    }

    private XContentBuilder value(ToXContent value) throws IOException {
        return this.value(value, ToXContent.EMPTY_PARAMS);
    }

    private XContentBuilder value(ToXContent value, ToXContent.Params params) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        value.toXContent(this, params);
        return this;
    }

    public XContentBuilder stringListField(String name, Collection<String> values) throws IOException {
        this.field(name);
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (String value : values) {
            this.value(value);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder xContentList(String name, Collection<? extends ToXContent> values) throws IOException {
        this.field(name);
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (ToXContent toXContent : values) {
            this.value(toXContent);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder xContentList(String name, ToXContent ... values) throws IOException {
        this.field(name);
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (ToXContent value : values) {
            this.value(value);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder enumSet(String name, EnumSet<?> values) throws IOException {
        this.field(name);
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (Enum value : values) {
            this.value(value);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, Map<String, Object> values) throws IOException {
        return this.field(name).map(values);
    }

    public XContentBuilder map(Map<String, ?> values) throws IOException {
        return this.map(values, true, true);
    }

    public XContentBuilder stringStringMap(String name, Map<String, String> values) throws IOException {
        this.field(name);
        if (values == null) {
            return this.nullValue();
        }
        this.startObject();
        for (Map.Entry<String, String> value : values.entrySet()) {
            this.field(value.getKey());
            this.value(value.getValue());
        }
        return this.endObject();
    }

    public XContentBuilder xContentValuesMap(String name, Map<String, ? extends ToXContent> values) throws IOException {
        this.field(name);
        if (values == null) {
            return this.nullValue();
        }
        this.startObject();
        for (Map.Entry<String, ? extends ToXContent> value : values.entrySet()) {
            this.field(value.getKey());
            this.value(value.getValue());
        }
        return this.endObject();
    }

    public XContentBuilder mapContents(Map<String, ?> values) throws IOException {
        return this.map(values, true, false);
    }

    private XContentBuilder map(Map<String, ?> values, boolean ensureNoSelfReferences, boolean writeStartAndEndHeaders) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        if (ensureNoSelfReferences) {
            XContentBuilder.ensureNoSelfReferences(values);
        }
        if (writeStartAndEndHeaders) {
            this.startObject();
        }
        for (Map.Entry<String, ?> value : values.entrySet()) {
            this.field(value.getKey());
            this.unknownValue(value.getValue(), false);
        }
        if (writeStartAndEndHeaders) {
            this.endObject();
        }
        return this;
    }

    public XContentBuilder field(String name, Iterable<?> values) throws IOException {
        return this.field(name).value(values);
    }

    private XContentBuilder value(Iterable<?> values, boolean ensureNoSelfReferences) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        if (values instanceof Path) {
            this.value((Path)values);
        } else {
            if (ensureNoSelfReferences) {
                XContentBuilder.ensureNoSelfReferences(values);
            }
            this.startArray();
            for (Object value : values) {
                this.unknownValue(value, false);
            }
            this.endArray();
        }
        return this;
    }

    public XContentBuilder humanReadableField(String rawFieldName, String readableFieldName, Object value) throws IOException {
        HumanReadableTransformer transformer;
        assert (!rawFieldName.equals(readableFieldName)) : "expected raw and readable field names to differ, but they were both: " + rawFieldName;
        if (this.humanReadable) {
            this.field(readableFieldName, Objects.toString(value));
        }
        if ((transformer = HUMAN_READABLE_TRANSFORMERS.get(value.getClass())) == null) {
            throw new IllegalArgumentException("no raw transformer found for class " + value.getClass());
        }
        Object rawValue = transformer.rawValue(value);
        this.field(rawFieldName, rawValue);
        return this;
    }

    public XContentBuilder percentageField(String rawFieldName, String readableFieldName, double percentage) throws IOException {
        assert (!rawFieldName.equals(readableFieldName)) : "expected raw and readable field names to differ, but they were both: " + rawFieldName;
        if (this.humanReadable) {
            this.field(readableFieldName, String.format(Locale.ROOT, "%1.1f%%", percentage));
        }
        this.field(rawFieldName, percentage);
        return this;
    }

    public XContentBuilder field(String name, Enum<?> value) throws IOException {
        this.field(name);
        return this.value(value == null ? null : value.toString());
    }

    @Deprecated
    public XContentBuilder rawField(String name, InputStream value) throws IOException {
        this.generator.writeRawField(name, value);
        return this;
    }

    public XContentBuilder rawField(String name, InputStream value, XContentType contentType) throws IOException {
        this.generator.writeRawField(name, value, contentType);
        return this;
    }

    public XContentBuilder rawValue(InputStream stream, XContentType contentType) throws IOException {
        this.generator.writeRawValue(stream, contentType);
        return this;
    }

    public XContentBuilder copyCurrentStructure(XContentParser parser) throws IOException {
        this.generator.copyCurrentStructure(parser);
        return this;
    }

    public XContentBuilder directFieldAsBase64(String name, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
        if (this.contentType() != XContentType.JSON) {
            assert (false) : "directFieldAsBase64 supports only JSON format";
            throw new UnsupportedOperationException("directFieldAsBase64 supports only JSON format");
        }
        this.generator.writeDirectField(name, os -> {
            os.write(34);
            FilterOutputStream noClose = new FilterOutputStream((OutputStream)os){

                @Override
                public void close() {
                }
            };
            OutputStream encodedOutput = Base64.getEncoder().wrap(noClose);
            writer.accept(encodedOutput);
            encodedOutput.close();
            os.write(34);
        });
        return this;
    }

    public RestApiVersion getRestApiVersion() {
        return this.restApiVersion;
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() {
        try {
            this.generator.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to close the XContentBuilder", e);
        }
    }

    public XContentGenerator generator() {
        return this.generator;
    }

    public static void ensureNameNotNull(String name) {
        XContentBuilder.ensureNotNull(name, "Field name cannot be null");
    }

    public static void ensureNotNull(Object value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void ensureNoSelfReferences(Object value) {
        Iterable<?> it = XContentBuilder.convert(value);
        if (it != null) {
            XContentBuilder.ensureNoSelfReferences(it, value, Collections.newSetFromMap(new IdentityHashMap()));
        }
    }

    private static Iterable<?> convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return ((Map)value).values();
        }
        if (value instanceof Iterable && !(value instanceof Path)) {
            return (Iterable)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        return null;
    }

    private static void ensureNoSelfReferences(Iterable<?> value, Object originalReference, Set<Object> ancestors) {
        if (value != null) {
            if (!ancestors.add(originalReference)) {
                throw new IllegalArgumentException("Iterable object is self-referencing itself");
            }
            for (Object o : value) {
                XContentBuilder.ensureNoSelfReferences(XContentBuilder.convert(o), o, ancestors);
            }
            ancestors.remove(originalReference);
        }
    }

    static {
        HashMap writers = new HashMap();
        writers.put(Boolean.class, (b, v) -> b.value((Boolean)v));
        writers.put(boolean[].class, (b, v) -> b.values((boolean[])v));
        writers.put(Byte.class, (b, v) -> b.value((Byte)v));
        writers.put(byte[].class, (b, v) -> b.value((byte[])v));
        writers.put(Date.class, XContentBuilder::timeValue);
        writers.put(Double.class, (b, v) -> b.value((Double)v));
        writers.put(double[].class, (b, v) -> b.values((double[])v));
        writers.put(Float.class, (b, v) -> b.value((Float)v));
        writers.put(float[].class, (b, v) -> b.values((float[])v));
        writers.put(Integer.class, (b, v) -> b.value((Integer)v));
        writers.put(int[].class, (b, v) -> b.values((int[])v));
        writers.put(Long.class, (b, v) -> b.value((Long)v));
        writers.put(long[].class, (b, v) -> b.values((long[])v));
        writers.put(Short.class, (b, v) -> b.value((Short)v));
        writers.put(short[].class, (b, v) -> b.values((short[])v));
        writers.put(String.class, (b, v) -> b.value((String)v));
        writers.put(String[].class, (b, v) -> b.values((String[])v));
        writers.put(Locale.class, (b, v) -> b.value(v.toString()));
        writers.put(Class.class, (b, v) -> b.value(v.toString()));
        writers.put(ZonedDateTime.class, (b, v) -> b.value(v.toString()));
        writers.put(Calendar.class, XContentBuilder::timeValue);
        writers.put(GregorianCalendar.class, XContentBuilder::timeValue);
        writers.put(BigInteger.class, (b, v) -> b.value((BigInteger)v));
        writers.put(BigDecimal.class, (b, v) -> b.value((BigDecimal)v));
        HashMap humanReadableTransformer = new HashMap();
        HashMap dateTransformers = new HashMap();
        dateTransformers.put(String.class, Function.identity());
        for (XContentBuilderExtension service : ServiceLoader.load(XContentBuilderExtension.class)) {
            Map<Class<?>, Writer> addlWriters = service.getXContentWriters();
            Map<Class<?>, HumanReadableTransformer> addlTransformers = service.getXContentHumanReadableTransformers();
            Map<Class<?>, Function<Object, Object>> addlDateTransformers = service.getDateTransformers();
            addlWriters.forEach((key, value) -> Objects.requireNonNull(value, "invalid null xcontent writer for class " + key));
            addlTransformers.forEach((key, value) -> Objects.requireNonNull(value, "invalid null xcontent transformer for human readable class " + key));
            dateTransformers.forEach((key, value) -> Objects.requireNonNull(value, "invalid null xcontent date transformer for class " + key));
            writers.putAll(addlWriters);
            humanReadableTransformer.putAll(addlTransformers);
            dateTransformers.putAll(addlDateTransformers);
        }
        WRITERS = Collections.unmodifiableMap(writers);
        HUMAN_READABLE_TRANSFORMERS = Collections.unmodifiableMap(humanReadableTransformer);
        DATE_TRANSFORMERS = Collections.unmodifiableMap(dateTransformers);
    }

    @FunctionalInterface
    public static interface Writer {
        public void write(XContentBuilder var1, Object var2) throws IOException;
    }

    @FunctionalInterface
    public static interface HumanReadableTransformer {
        public Object rawValue(Object var1) throws IOException;
    }
}

