/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;

public class GenerateUniqueIndexNameStep
extends ClusterStateActionStep {
    private static final Logger logger = LogManager.getLogger(GenerateUniqueIndexNameStep.class);
    public static final String NAME = "generate-index-name";
    static final String ILLEGAL_INDEXNAME_CHARS_REGEX = "[/:\"*?<>|# ,\\\\]+";
    static final int MAX_GENERATED_UUID_LENGTH = 4;
    private final String prefix;
    private final BiFunction<String, LifecycleExecutionState.Builder, LifecycleExecutionState.Builder> lifecycleStateSetter;

    public GenerateUniqueIndexNameStep(Step.StepKey key, Step.StepKey nextStepKey, String prefix, BiFunction<String, LifecycleExecutionState.Builder, LifecycleExecutionState.Builder> lifecycleStateSetter) {
        super(key, nextStepKey);
        this.prefix = prefix;
        this.lifecycleStateSetter = lifecycleStateSetter;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    String prefix() {
        return this.prefix;
    }

    BiFunction<String, LifecycleExecutionState.Builder, LifecycleExecutionState.Builder> lifecycleStateSetter() {
        return this.lifecycleStateSetter;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return clusterState;
        }
        ClusterState.Builder newClusterStateBuilder = ClusterState.builder(clusterState);
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
        LifecycleExecutionState.Builder newCustomData = LifecycleExecutionState.builder(lifecycleState);
        String policy = indexMetadata.getSettings().get("index.lifecycle.name");
        String generatedIndexName = GenerateUniqueIndexNameStep.generateValidIndexName(this.prefix, index.getName());
        ActionRequestValidationException validationException = GenerateUniqueIndexNameStep.validateGeneratedIndexName(generatedIndexName, clusterState);
        if (validationException != null) {
            logger.warn("unable to generate a valid index name as part of policy [{}] for index [{}] due to [{}]", (Object)policy, (Object)index.getName(), (Object)validationException.getMessage());
            throw validationException;
        }
        this.lifecycleStateSetter.apply(generatedIndexName, newCustomData);
        IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexMetadata);
        indexMetadataBuilder.putCustom("ilm", newCustomData.build().asMap());
        newClusterStateBuilder.metadata(Metadata.builder(clusterState.getMetadata()).put(indexMetadataBuilder).build(false));
        return newClusterStateBuilder.build();
    }

    @Nullable
    static ActionRequestValidationException validateGeneratedIndexName(String generatedIndexName, ClusterState state) {
        ActionRequestValidationException err = new ActionRequestValidationException();
        try {
            MetadataCreateIndexService.validateIndexOrAliasName(generatedIndexName, InvalidIndexNameException::new);
        }
        catch (InvalidIndexNameException e) {
            err.addValidationError(e.getMessage());
        }
        if (state.routingTable().hasIndex(generatedIndexName) || state.metadata().hasIndex(generatedIndexName)) {
            err.addValidationError("the index name we generated [" + generatedIndexName + "] already exists");
        }
        if (state.metadata().hasAlias(generatedIndexName)) {
            err.addValidationError("the index name we generated [" + generatedIndexName + "] already exists as alias");
        }
        if (err.validationErrors().size() > 0) {
            return err;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateUniqueIndexNameStep that = (GenerateUniqueIndexNameStep)o;
        return super.equals(o) && Objects.equals(this.prefix, that.prefix);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.prefix);
    }

    static String generateValidIndexName(String prefix, String indexName) {
        String randomUUID = GenerateUniqueIndexNameStep.generateValidIndexSuffix(UUIDs::randomBase64UUID);
        randomUUID = randomUUID.substring(0, Math.min(randomUUID.length(), 4));
        return prefix + randomUUID + "-" + indexName;
    }

    static String generateValidIndexSuffix(Supplier<String> randomGenerator) {
        String randomSuffix = randomGenerator.get().toLowerCase(Locale.ROOT);
        if ((randomSuffix = randomSuffix.replaceAll(ILLEGAL_INDEXNAME_CHARS_REGEX, "")).length() == 0) {
            throw new IllegalArgumentException("unable to generate random index name suffix");
        }
        return randomSuffix;
    }
}

