/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.cluster.metadata.ItemUsage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;

public class GetLifecycleAction
extends ActionType<Response> {
    public static final GetLifecycleAction INSTANCE = new GetLifecycleAction();
    public static final String NAME = "cluster:admin/ilm/get";

    protected GetLifecycleAction() {
        super(NAME, Response::new);
    }

    public static class LifecyclePolicyResponseItem
    implements Writeable {
        private final LifecyclePolicy lifecyclePolicy;
        private final long version;
        private final String modifiedDate;
        private final ItemUsage usage;

        public LifecyclePolicyResponseItem(LifecyclePolicy lifecyclePolicy, long version, String modifiedDate, ItemUsage usage) {
            this.lifecyclePolicy = lifecyclePolicy;
            this.version = version;
            this.modifiedDate = modifiedDate;
            this.usage = usage;
        }

        LifecyclePolicyResponseItem(StreamInput in) throws IOException {
            this.lifecyclePolicy = new LifecyclePolicy(in);
            this.version = in.readVLong();
            this.modifiedDate = in.readString();
            this.usage = new ItemUsage(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.lifecyclePolicy.writeTo(out);
            out.writeVLong(this.version);
            out.writeString(this.modifiedDate);
            this.usage.writeTo(out);
        }

        public LifecyclePolicy getLifecyclePolicy() {
            return this.lifecyclePolicy;
        }

        public long getVersion() {
            return this.version;
        }

        public String getModifiedDate() {
            return this.modifiedDate;
        }

        public ItemUsage getUsage() {
            return this.usage;
        }

        public int hashCode() {
            return Objects.hash(this.lifecyclePolicy, this.version, this.modifiedDate, this.usage);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LifecyclePolicyResponseItem other = (LifecyclePolicyResponseItem)obj;
            return Objects.equals(this.lifecyclePolicy, other.lifecyclePolicy) && Objects.equals(this.version, other.version) && Objects.equals(this.modifiedDate, other.modifiedDate) && Objects.equals(this.usage, other.usage);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String[] policyNames;

        public Request(String ... policyNames) {
            if (policyNames == null) {
                throw new IllegalArgumentException("ids cannot be null");
            }
            this.policyNames = policyNames;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.policyNames = in.readStringArray();
        }

        public Request() {
            this.policyNames = Strings.EMPTY_ARRAY;
        }

        public String[] getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.policyNames);
        }

        public int hashCode() {
            return Arrays.hashCode(this.policyNames);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Arrays.equals(this.policyNames, other.policyNames);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private List<LifecyclePolicyResponseItem> policies;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.policies = in.readList(LifecyclePolicyResponseItem::new);
        }

        public Response(List<LifecyclePolicyResponseItem> policies) {
            this.policies = policies;
        }

        public List<LifecyclePolicyResponseItem> getPolicies() {
            return this.policies;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            for (LifecyclePolicyResponseItem item : this.policies) {
                builder.startObject(item.getLifecyclePolicy().getName());
                builder.field("version", item.getVersion());
                builder.field("modified_date", item.getModifiedDate());
                builder.field("policy", item.getLifecyclePolicy());
                builder.field("in_use_by", item.getUsage());
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.policies);
        }

        public int hashCode() {
            return Objects.hash(this.policies);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Response other = (Response)obj;
            return Objects.equals(this.policies, other.policies);
        }

        public String toString() {
            return Strings.toString(this, true, true);
        }
    }
}

