/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.Step;

public class MoveToStepAction
extends ActionType<AcknowledgedResponse> {
    public static final MoveToStepAction INSTANCE = new MoveToStepAction();
    public static final String NAME = "cluster:admin/ilm/_move/post";

    protected MoveToStepAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        static final ParseField CURRENT_KEY_FIELD = new ParseField("current_step", new String[0]);
        static final ParseField NEXT_KEY_FIELD = new ParseField("next_step", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser<Request, String>("move_to_step_request", false, (a, index) -> {
            Step.StepKey currentStepKey = (Step.StepKey)a[0];
            PartialStepKey nextStepKey = (PartialStepKey)a[1];
            return new Request((String)index, currentStepKey, nextStepKey);
        });
        private String index;
        private Step.StepKey currentStepKey;
        private PartialStepKey nextStepKey;

        public Request(String index, Step.StepKey currentStepKey, PartialStepKey nextStepKey) {
            this.index = index;
            this.currentStepKey = currentStepKey;
            this.nextStepKey = nextStepKey;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
            this.currentStepKey = new Step.StepKey(in);
            this.nextStepKey = new PartialStepKey(in);
        }

        public Request() {
        }

        public String getIndex() {
            return this.index;
        }

        public Step.StepKey getCurrentStepKey() {
            return this.currentStepKey;
        }

        public PartialStepKey getNextStepKey() {
            return this.nextStepKey;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public static Request parseRequest(String name, XContentParser parser) {
            return PARSER.apply(parser, name);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            this.currentStepKey.writeTo(out);
            this.nextStepKey.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.currentStepKey, this.nextStepKey);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.index, other.index) && Objects.equals(this.currentStepKey, other.currentStepKey) && Objects.equals(this.nextStepKey, other.nextStepKey);
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(CURRENT_KEY_FIELD.getPreferredName(), this.currentStepKey).field(NEXT_KEY_FIELD.getPreferredName(), this.nextStepKey).endObject();
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, name) -> Step.StepKey.parse(p), CURRENT_KEY_FIELD);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, name) -> PartialStepKey.parse(p), NEXT_KEY_FIELD);
        }

        public static class PartialStepKey
        implements Writeable,
        ToXContentObject {
            private final String phase;
            private final String action;
            private final String name;
            public static final ParseField PHASE_FIELD = new ParseField("phase", new String[0]);
            public static final ParseField ACTION_FIELD = new ParseField("action", new String[0]);
            public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
            private static final ConstructingObjectParser<PartialStepKey, Void> PARSER = new ConstructingObjectParser("step_specification", a -> new PartialStepKey((String)a[0], (String)a[1], (String)a[2]));

            public PartialStepKey(String phase, @Nullable String action, @Nullable String name) {
                this.phase = phase;
                this.action = action;
                this.name = name;
                if (name != null && action == null) {
                    throw new IllegalArgumentException("phase; phase and action; or phase, action, and step must be provided, but a step name was specified without a corresponding action");
                }
            }

            public PartialStepKey(StreamInput in) throws IOException {
                this.phase = in.readString();
                this.action = in.readOptionalString();
                this.name = in.readOptionalString();
                if (this.name != null && this.action == null) {
                    throw new IllegalArgumentException("phase; phase and action; or phase, action, and step must be provided, but a step name was specified without a corresponding action");
                }
            }

            public static PartialStepKey parse(XContentParser parser) {
                return PARSER.apply(parser, null);
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.phase);
                out.writeOptionalString(this.action);
                out.writeOptionalString(this.name);
            }

            @Nullable
            public String getPhase() {
                return this.phase;
            }

            @Nullable
            public String getAction() {
                return this.action;
            }

            @Nullable
            public String getName() {
                return this.name;
            }

            public int hashCode() {
                return Objects.hash(this.phase, this.action, this.name);
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PartialStepKey other = (PartialStepKey)obj;
                return Objects.equals(this.phase, other.phase) && Objects.equals(this.action, other.action) && Objects.equals(this.name, other.name);
            }

            public String toString() {
                return Strings.toString(this);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(PHASE_FIELD.getPreferredName(), this.phase);
                if (this.action != null) {
                    builder.field(ACTION_FIELD.getPreferredName(), this.action);
                }
                if (this.name != null) {
                    builder.field(NAME_FIELD.getPreferredName(), this.name);
                }
                builder.endObject();
                return builder;
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), PHASE_FIELD);
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ACTION_FIELD);
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), NAME_FIELD);
            }
        }
    }
}

