/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.allocation.AllocationState;
import org.elasticsearch.xpack.core.ml.inference.allocation.AllocationStatus;
import org.elasticsearch.xpack.core.ml.inference.allocation.RoutingState;
import org.elasticsearch.xpack.core.ml.inference.allocation.RoutingStateAndReason;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetDeploymentStatsAction
extends ActionType<Response> {
    public static final GetDeploymentStatsAction INSTANCE = new GetDeploymentStatsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/trained_models/deployments/stats/get";

    private GetDeploymentStatsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements ToXContentObject {
        public static final ParseField DEPLOYMENT_STATS = new ParseField("deployment_stats", new String[0]);
        private final QueryPage<AllocationStats> stats;

        public Response(List<TaskOperationFailure> taskFailures, List<? extends ElasticsearchException> nodeFailures, List<AllocationStats> stats, long count) {
            super(taskFailures, nodeFailures);
            this.stats = new QueryPage<AllocationStats>(stats, count, DEPLOYMENT_STATS);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.stats = new QueryPage<AllocationStats>(in, AllocationStats::new);
        }

        public QueryPage<AllocationStats> getStats() {
            return this.stats;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.stats.doXContentBody(builder, params);
            this.toXContentCommon(builder, params);
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.stats.writeTo(out);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.stats, response.stats);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.stats);
        }

        public static class AllocationStats
        implements ToXContentObject,
        Writeable {
            private final String modelId;
            private AllocationState state;
            private AllocationStatus allocationStatus;
            private String reason;
            @Nullable
            private final ByteSizeValue modelSize;
            @Nullable
            private final Integer inferenceThreads;
            @Nullable
            private final Integer modelThreads;
            @Nullable
            private final Integer queueCapacity;
            private final Instant startTime;
            private final List<NodeStats> nodeStats;

            public AllocationStats(String modelId, @Nullable ByteSizeValue modelSize, @Nullable Integer inferenceThreads, @Nullable Integer modelThreads, @Nullable Integer queueCapacity, Instant startTime, List<NodeStats> nodeStats) {
                this.modelId = modelId;
                this.modelSize = modelSize;
                this.inferenceThreads = inferenceThreads;
                this.modelThreads = modelThreads;
                this.queueCapacity = queueCapacity;
                this.startTime = Objects.requireNonNull(startTime);
                this.nodeStats = nodeStats;
                this.state = null;
                this.reason = null;
            }

            public AllocationStats(StreamInput in) throws IOException {
                this.modelId = in.readString();
                this.modelSize = in.readOptionalWriteable(ByteSizeValue::new);
                this.inferenceThreads = in.readOptionalVInt();
                this.modelThreads = in.readOptionalVInt();
                this.queueCapacity = in.readOptionalVInt();
                this.startTime = in.readInstant();
                this.nodeStats = in.readList(NodeStats::new);
                this.state = in.readOptionalEnum(AllocationState.class);
                this.reason = in.readOptionalString();
                this.allocationStatus = in.readOptionalWriteable(AllocationStatus::new);
            }

            public String getModelId() {
                return this.modelId;
            }

            public ByteSizeValue getModelSize() {
                return this.modelSize;
            }

            @Nullable
            public Integer getInferenceThreads() {
                return this.inferenceThreads;
            }

            @Nullable
            public Integer getModelThreads() {
                return this.modelThreads;
            }

            @Nullable
            public Integer getQueueCapacity() {
                return this.queueCapacity;
            }

            public Instant getStartTime() {
                return this.startTime;
            }

            public List<NodeStats> getNodeStats() {
                return this.nodeStats;
            }

            public AllocationState getState() {
                return this.state;
            }

            public AllocationStats setState(AllocationState state) {
                this.state = state;
                return this;
            }

            public AllocationStats setAllocationStatus(AllocationStatus allocationStatus) {
                this.allocationStatus = allocationStatus;
                return this;
            }

            public String getReason() {
                return this.reason;
            }

            public AllocationStats setReason(String reason) {
                this.reason = reason;
                return this;
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("model_id", this.modelId);
                if (this.modelSize != null) {
                    builder.humanReadableField("model_size_bytes", "model_size", this.modelSize);
                }
                if (this.inferenceThreads != null) {
                    builder.field(StartTrainedModelDeploymentAction.TaskParams.INFERENCE_THREADS.getPreferredName(), this.inferenceThreads);
                }
                if (this.modelThreads != null) {
                    builder.field(StartTrainedModelDeploymentAction.TaskParams.MODEL_THREADS.getPreferredName(), this.modelThreads);
                }
                if (this.queueCapacity != null) {
                    builder.field(StartTrainedModelDeploymentAction.TaskParams.QUEUE_CAPACITY.getPreferredName(), this.queueCapacity);
                }
                if (this.state != null) {
                    builder.field("state", this.state);
                }
                if (this.reason != null) {
                    builder.field("reason", this.reason);
                }
                if (this.allocationStatus != null) {
                    builder.field("allocation_status", this.allocationStatus);
                }
                builder.timeField("start_time", "start_time_string", this.startTime.toEpochMilli());
                builder.startArray("nodes");
                for (NodeStats nodeStat : this.nodeStats) {
                    nodeStat.toXContent(builder, params);
                }
                builder.endArray();
                builder.endObject();
                return builder;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.modelId);
                out.writeOptionalWriteable(this.modelSize);
                out.writeOptionalVInt(this.inferenceThreads);
                out.writeOptionalVInt(this.modelThreads);
                out.writeOptionalVInt(this.queueCapacity);
                out.writeInstant(this.startTime);
                out.writeList(this.nodeStats);
                out.writeOptionalEnum(this.state);
                out.writeOptionalString(this.reason);
                out.writeOptionalWriteable(this.allocationStatus);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                AllocationStats that = (AllocationStats)o;
                return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.modelSize, that.modelSize) && Objects.equals(this.inferenceThreads, that.inferenceThreads) && Objects.equals(this.modelThreads, that.modelThreads) && Objects.equals(this.queueCapacity, that.queueCapacity) && Objects.equals(this.startTime, that.startTime) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.reason, that.reason) && Objects.equals(this.allocationStatus, that.allocationStatus) && Objects.equals(this.nodeStats, that.nodeStats);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.modelId, this.modelSize, this.inferenceThreads, this.modelThreads, this.queueCapacity, this.startTime, this.nodeStats, this.state, this.reason, this.allocationStatus});
            }

            public static class NodeStats
            implements ToXContentObject,
            Writeable {
                private final DiscoveryNode node;
                private final Long inferenceCount;
                private final Double avgInferenceTime;
                private final Instant lastAccess;
                private final Integer pendingCount;
                private final RoutingStateAndReason routingState;
                private final Instant startTime;

                public static NodeStats forStartedState(DiscoveryNode node, long inferenceCount, Double avgInferenceTime, int pendingCount, Instant lastAccess, Instant startTime) {
                    return new NodeStats(node, inferenceCount, avgInferenceTime, lastAccess, pendingCount, new RoutingStateAndReason(RoutingState.STARTED, null), Objects.requireNonNull(startTime));
                }

                public static NodeStats forNotStartedState(DiscoveryNode node, RoutingState state, String reason) {
                    return new NodeStats(node, null, null, null, null, new RoutingStateAndReason(state, reason), null);
                }

                private NodeStats(DiscoveryNode node, Long inferenceCount, Double avgInferenceTime, Instant lastAccess, Integer pendingCount, RoutingStateAndReason routingState, @Nullable Instant startTime) {
                    this.node = node;
                    this.inferenceCount = inferenceCount;
                    this.avgInferenceTime = avgInferenceTime;
                    this.lastAccess = lastAccess;
                    this.pendingCount = pendingCount;
                    this.routingState = routingState;
                    this.startTime = startTime;
                    assert (this.lastAccess != null || inferenceCount == null || inferenceCount == 0L);
                }

                public NodeStats(StreamInput in) throws IOException {
                    this.node = in.readOptionalWriteable(DiscoveryNode::new);
                    this.inferenceCount = in.readOptionalLong();
                    this.avgInferenceTime = in.readOptionalDouble();
                    this.lastAccess = in.readOptionalInstant();
                    this.pendingCount = in.readOptionalVInt();
                    this.routingState = in.readOptionalWriteable(RoutingStateAndReason::new);
                    this.startTime = in.readOptionalInstant();
                }

                public DiscoveryNode getNode() {
                    return this.node;
                }

                public RoutingStateAndReason getRoutingState() {
                    return this.routingState;
                }

                @Override
                public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                    builder.startObject();
                    if (this.node != null) {
                        builder.startObject("node");
                        this.node.toXContent(builder, params);
                        builder.endObject();
                    }
                    builder.field("routing_state", this.routingState);
                    if (this.inferenceCount != null) {
                        builder.field("inference_count", this.inferenceCount);
                    }
                    if (this.avgInferenceTime != null) {
                        builder.field("average_inference_time_ms", this.avgInferenceTime);
                    }
                    if (this.lastAccess != null) {
                        builder.timeField("last_access", "last_access_string", this.lastAccess.toEpochMilli());
                    }
                    if (this.pendingCount != null) {
                        builder.field("number_of_pending_requests", this.pendingCount);
                    }
                    if (this.startTime != null) {
                        builder.timeField("start_time", "start_time_string", this.startTime.toEpochMilli());
                    }
                    builder.endObject();
                    return builder;
                }

                @Override
                public void writeTo(StreamOutput out) throws IOException {
                    out.writeOptionalWriteable(this.node);
                    out.writeOptionalLong(this.inferenceCount);
                    out.writeOptionalDouble(this.avgInferenceTime);
                    out.writeOptionalInstant(this.lastAccess);
                    out.writeOptionalVInt(this.pendingCount);
                    out.writeOptionalWriteable(this.routingState);
                    out.writeOptionalInstant(this.startTime);
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    NodeStats that = (NodeStats)o;
                    return Objects.equals(this.inferenceCount, that.inferenceCount) && Objects.equals(that.avgInferenceTime, this.avgInferenceTime) && Objects.equals(this.node, that.node) && Objects.equals(this.lastAccess, that.lastAccess) && Objects.equals(this.pendingCount, that.pendingCount) && Objects.equals(this.routingState, that.routingState) && Objects.equals(this.startTime, that.startTime);
                }

                public int hashCode() {
                    return Objects.hash(this.node, this.inferenceCount, this.avgInferenceTime, this.lastAccess, this.pendingCount, this.routingState, this.startTime);
                }
            }
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        public static final String ALLOW_NO_MATCH = "allow_no_match";
        private final String deploymentId;
        private boolean allowNoMatch = true;
        private List<String> expandedIds;

        public Request(String deploymentId) {
            this.deploymentId = ExceptionsHelper.requireNonNull(deploymentId, "deployment_id");
            this.expandedIds = Collections.singletonList(deploymentId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.deploymentId = in.readString();
            this.allowNoMatch = in.readBoolean();
            this.expandedIds = in.readStringList();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.deploymentId);
            out.writeBoolean(this.allowNoMatch);
            out.writeStringCollection(this.expandedIds);
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public void setExpandedIds(List<String> expandedIds) {
            this.expandedIds = expandedIds;
        }

        public void setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
        }

        public boolean isAllowNoMatch() {
            return this.allowNoMatch;
        }

        @Override
        public boolean match(Task task) {
            return this.expandedIds.stream().anyMatch(taskId -> StartTrainedModelDeploymentAction.TaskMatcher.match(task, taskId));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.deploymentId, request.deploymentId) && this.allowNoMatch == request.allowNoMatch && Objects.equals(this.expandedIds, request.expandedIds);
        }

        public int hashCode() {
            return Objects.hash(this.deploymentId, this.allowNoMatch, this.expandedIds);
        }
    }
}

