/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAllocationAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.allocation.AllocationStatus;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlTaskParams;

public class StartTrainedModelDeploymentAction
extends ActionType<CreateTrainedModelAllocationAction.Response> {
    public static final StartTrainedModelDeploymentAction INSTANCE = new StartTrainedModelDeploymentAction();
    public static final String NAME = "cluster:admin/xpack/ml/trained_models/deployment/start";
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(20L, TimeUnit.SECONDS);

    public StartTrainedModelDeploymentAction() {
        super(NAME, CreateTrainedModelAllocationAction.Response::new);
    }

    public static interface TaskMatcher {
        public static boolean match(Task task, String expectedId) {
            if (task instanceof TaskMatcher) {
                if (Strings.isAllOrWildcard(expectedId)) {
                    return true;
                }
                String expectedDescription = MlTasks.trainedModelDeploymentTaskId(expectedId);
                return expectedDescription.equals(task.getDescription());
            }
            return false;
        }
    }

    public static class TaskParams
    implements MlTaskParams,
    Writeable,
    ToXContentObject {
        public static final Version VERSION_INTRODUCED = Version.V_8_0_0;
        private static final ParseField MODEL_BYTES = new ParseField("model_bytes", new String[0]);
        public static final ParseField MODEL_THREADS = new ParseField("model_threads", new String[0]);
        public static final ParseField INFERENCE_THREADS = new ParseField("inference_threads", new String[0]);
        public static final ParseField QUEUE_CAPACITY = new ParseField("queue_capacity", new String[0]);
        private static final ConstructingObjectParser<TaskParams, Void> PARSER = new ConstructingObjectParser("trained_model_deployment_params", true, a -> new TaskParams((String)a[0], (Long)a[1], (Integer)a[2], (Integer)a[3], (Integer)a[4]));
        private static final ByteSizeValue MEMORY_OVERHEAD;
        private final String modelId;
        private final long modelBytes;
        private final int inferenceThreads;
        private final int modelThreads;
        private final int queueCapacity;

        public static boolean mayAllocateToNode(DiscoveryNode node) {
            return node.getRoles().contains(DiscoveryNodeRole.ML_ROLE) && node.getVersion().onOrAfter(VERSION_INTRODUCED);
        }

        public static TaskParams fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public TaskParams(String modelId, long modelBytes, int inferenceThreads, int modelThreads, int queueCapacity) {
            this.modelId = Objects.requireNonNull(modelId);
            this.modelBytes = modelBytes;
            this.inferenceThreads = inferenceThreads;
            this.modelThreads = modelThreads;
            this.queueCapacity = queueCapacity;
        }

        public TaskParams(StreamInput in) throws IOException {
            this.modelId = in.readString();
            this.modelBytes = in.readLong();
            this.inferenceThreads = in.readVInt();
            this.modelThreads = in.readVInt();
            this.queueCapacity = in.readVInt();
        }

        public String getModelId() {
            return this.modelId;
        }

        public long estimateMemoryUsageBytes() {
            return MEMORY_OVERHEAD.getBytes() + 2L * this.modelBytes;
        }

        public Version getMinimalSupportedVersion() {
            return VERSION_INTRODUCED;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.modelId);
            out.writeLong(this.modelBytes);
            out.writeVInt(this.inferenceThreads);
            out.writeVInt(this.modelThreads);
            out.writeVInt(this.queueCapacity);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(TrainedModelConfig.MODEL_ID.getPreferredName(), this.modelId);
            builder.field(MODEL_BYTES.getPreferredName(), this.modelBytes);
            builder.field(INFERENCE_THREADS.getPreferredName(), this.inferenceThreads);
            builder.field(MODEL_THREADS.getPreferredName(), this.modelThreads);
            builder.field(QUEUE_CAPACITY.getPreferredName(), this.queueCapacity);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.modelId, this.modelBytes, this.inferenceThreads, this.modelThreads, this.queueCapacity);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskParams other = (TaskParams)o;
            return Objects.equals(this.modelId, other.modelId) && this.modelBytes == other.modelBytes && this.inferenceThreads == other.inferenceThreads && this.modelThreads == other.modelThreads && this.queueCapacity == other.queueCapacity;
        }

        @Override
        public String getMlId() {
            return this.modelId;
        }

        public long getModelBytes() {
            return this.modelBytes;
        }

        public int getInferenceThreads() {
            return this.inferenceThreads;
        }

        public int getModelThreads() {
            return this.modelThreads;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), TrainedModelConfig.MODEL_ID);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), MODEL_BYTES);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), INFERENCE_THREADS);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), MODEL_THREADS);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), QUEUE_CAPACITY);
            MEMORY_OVERHEAD = ByteSizeValue.ofMb(270L);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        private static final AllocationStatus.State[] VALID_WAIT_STATES = new AllocationStatus.State[]{AllocationStatus.State.STARTED, AllocationStatus.State.STARTING, AllocationStatus.State.FULLY_ALLOCATED};
        public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField WAIT_FOR = new ParseField("wait_for", new String[0]);
        public static final ParseField INFERENCE_THREADS = TaskParams.INFERENCE_THREADS;
        public static final ParseField MODEL_THREADS = TaskParams.MODEL_THREADS;
        public static final ParseField QUEUE_CAPACITY = TaskParams.QUEUE_CAPACITY;
        public static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/trained_models/deployment/start", Request::new);
        private String modelId;
        private TimeValue timeout = DEFAULT_TIMEOUT;
        private AllocationStatus.State waitForState = AllocationStatus.State.STARTED;
        private int modelThreads = 1;
        private int inferenceThreads = 1;
        private int queueCapacity = 1024;

        public static Request parseRequest(String modelId, XContentParser parser) {
            Request request = PARSER.apply(parser, null);
            if (request.getModelId() == null) {
                request.setModelId(modelId);
            } else if (!Strings.isNullOrEmpty(modelId) && !modelId.equals(request.getModelId())) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", MODEL_ID, request.getModelId(), modelId), new Object[0]);
            }
            return request;
        }

        private Request() {
        }

        public Request(String modelId) {
            this.setModelId(modelId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.timeout = in.readTimeValue();
            this.waitForState = in.readEnum(AllocationStatus.State.class);
            this.modelThreads = in.readVInt();
            this.inferenceThreads = in.readVInt();
            this.queueCapacity = in.readVInt();
        }

        public final void setModelId(String modelId) {
            this.modelId = ExceptionsHelper.requireNonNull(modelId, MODEL_ID);
        }

        public String getModelId() {
            return this.modelId;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = ExceptionsHelper.requireNonNull(timeout, TIMEOUT);
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public AllocationStatus.State getWaitForState() {
            return this.waitForState;
        }

        public Request setWaitForState(AllocationStatus.State waitForState) {
            this.waitForState = ExceptionsHelper.requireNonNull(waitForState, WAIT_FOR);
            return this;
        }

        public int getModelThreads() {
            return this.modelThreads;
        }

        public void setModelThreads(int modelThreads) {
            this.modelThreads = modelThreads;
        }

        public int getInferenceThreads() {
            return this.inferenceThreads;
        }

        public void setInferenceThreads(int inferenceThreads) {
            this.inferenceThreads = inferenceThreads;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            out.writeTimeValue(this.timeout);
            out.writeEnum(this.waitForState);
            out.writeVInt(this.modelThreads);
            out.writeVInt(this.inferenceThreads);
            out.writeVInt(this.queueCapacity);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MODEL_ID.getPreferredName(), this.modelId);
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            builder.field(WAIT_FOR.getPreferredName(), this.waitForState);
            builder.field(MODEL_THREADS.getPreferredName(), this.modelThreads);
            builder.field(INFERENCE_THREADS.getPreferredName(), this.inferenceThreads);
            builder.field(QUEUE_CAPACITY.getPreferredName(), this.queueCapacity);
            builder.endObject();
            return builder;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = new ActionRequestValidationException();
            if (!this.waitForState.isAnyOf(VALID_WAIT_STATES)) {
                validationException.addValidationError("invalid [wait_for] state [" + this.waitForState + "]; must be one of [" + Strings.arrayToCommaDelimitedString((Object[])VALID_WAIT_STATES));
            }
            if (this.modelThreads < 1) {
                validationException.addValidationError("[" + MODEL_THREADS + "] must be a positive integer");
            }
            if (this.inferenceThreads < 1) {
                validationException.addValidationError("[" + INFERENCE_THREADS + "] must be a positive integer");
            }
            if (this.queueCapacity < 1) {
                validationException.addValidationError("[" + QUEUE_CAPACITY + "] must be a positive integer");
            }
            return validationException.validationErrors().isEmpty() ? null : validationException;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.modelId, this.timeout, this.waitForState, this.modelThreads, this.inferenceThreads, this.queueCapacity});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.modelId, other.modelId) && Objects.equals(this.timeout, other.timeout) && Objects.equals((Object)this.waitForState, (Object)other.waitForState) && this.modelThreads == other.modelThreads && this.inferenceThreads == other.inferenceThreads && this.queueCapacity == other.queueCapacity;
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareString(Request::setModelId, MODEL_ID);
            PARSER.declareString((request, val) -> request.setTimeout(TimeValue.parseTimeValue(val, TIMEOUT.getPreferredName())), TIMEOUT);
            PARSER.declareString((request, waitFor) -> request.setWaitForState(AllocationStatus.State.fromString(waitFor)), WAIT_FOR);
            PARSER.declareInt(Request::setInferenceThreads, INFERENCE_THREADS);
            PARSER.declareInt(Request::setModelThreads, MODEL_THREADS);
            PARSER.declareInt(Request::setQueueCapacity, QUEUE_CAPACITY);
        }
    }
}

