/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregatorBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationFields;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationParameters;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Classification;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.PainlessScripts;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.PerClassSingleValue;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Recall
implements EvaluationMetric {
    public static final ParseField NAME = new ParseField("recall", new String[0]);
    private static final String AGG_NAME_PREFIX = "classification_recall_";
    static final String BY_ACTUAL_CLASS_AGG_NAME = "classification_recall_by_actual_class";
    static final String PER_ACTUAL_CLASS_RECALL_AGG_NAME = "classification_recall_per_actual_class_recall";
    static final String AVG_RECALL_AGG_NAME = "classification_recall_avg_recall";
    private static final ObjectParser<Recall, Void> PARSER = new ObjectParser(NAME.getPreferredName(), true, Recall::new);
    private static final int MAX_CLASSES_CARDINALITY = 1000;
    private final SetOnce<String> actualField = new SetOnce();
    private final SetOnce<Result> result = new SetOnce();

    public static Recall fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public Recall() {
    }

    public Recall(StreamInput in) throws IOException {
    }

    @Override
    public String getWriteableName() {
        return MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, NAME);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public Set<String> getRequiredFields() {
        return Sets.newHashSet(EvaluationFields.ACTUAL_FIELD.getPreferredName(), EvaluationFields.PREDICTED_FIELD.getPreferredName());
    }

    @Override
    public final Tuple<List<AggregationBuilder>, List<PipelineAggregationBuilder>> aggs(EvaluationParameters parameters, EvaluationFields fields) {
        String actualField = fields.getActualField();
        String predictedField = fields.getPredictedField();
        this.actualField.trySet(actualField);
        if (this.result.get() != null) {
            return Tuple.tuple(List.of(), List.of());
        }
        Script script = PainlessScripts.buildIsEqualScript(actualField, predictedField);
        return Tuple.tuple(List.of(((TermsAggregationBuilder)AggregationBuilders.terms(BY_ACTUAL_CLASS_AGG_NAME).field(actualField)).order(List.of(BucketOrder.count(false), BucketOrder.key(true))).size(1000).subAggregation((AggregationBuilder)AggregationBuilders.avg(PER_ACTUAL_CLASS_RECALL_AGG_NAME).script(script))), List.of(PipelineAggregatorBuilders.avgBucket(AVG_RECALL_AGG_NAME, "classification_recall_by_actual_class>classification_recall_per_actual_class_recall")));
    }

    @Override
    public void process(Aggregations aggs) {
        if (this.result.get() == null && aggs.get(BY_ACTUAL_CLASS_AGG_NAME) instanceof Terms && aggs.get(AVG_RECALL_AGG_NAME) instanceof NumericMetricsAggregation.SingleValue) {
            Terms byActualClassAgg = (Terms)aggs.get(BY_ACTUAL_CLASS_AGG_NAME);
            if (byActualClassAgg.getSumOfOtherDocCounts() > 0L) {
                throw ExceptionsHelper.badRequestException("Cannot calculate average recall. Cardinality of field [{}] is too high", this.actualField.get());
            }
            NumericMetricsAggregation.SingleValue avgRecallAgg = (NumericMetricsAggregation.SingleValue)aggs.get(AVG_RECALL_AGG_NAME);
            ArrayList<PerClassSingleValue> classes = new ArrayList<PerClassSingleValue>(byActualClassAgg.getBuckets().size());
            for (Terms.Bucket bucket : byActualClassAgg.getBuckets()) {
                String className = bucket.getKeyAsString();
                NumericMetricsAggregation.SingleValue recallAgg = (NumericMetricsAggregation.SingleValue)bucket.getAggregations().get(PER_ACTUAL_CLASS_RECALL_AGG_NAME);
                classes.add(new PerClassSingleValue(className, recallAgg.value()));
            }
            this.result.set(new Result(classes, avgRecallAgg.value()));
        }
    }

    public Optional<Result> getResult() {
        return Optional.ofNullable(this.result.get());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hashCode(NAME.getPreferredName());
    }

    public static class Result
    implements EvaluationMetricResult {
        private static final ParseField CLASSES = new ParseField("classes", new String[0]);
        private static final ParseField AVG_RECALL = new ParseField("avg_recall", new String[0]);
        private static final ConstructingObjectParser<Result, Void> PARSER = new ConstructingObjectParser("recall_result", true, a -> new Result((List)a[0], (Double)a[1]));
        private final List<PerClassSingleValue> classes;
        private final double avgRecall;

        public static Result fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public Result(List<PerClassSingleValue> classes, double avgRecall) {
            this.classes = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(classes, CLASSES));
            this.avgRecall = avgRecall;
        }

        public Result(StreamInput in) throws IOException {
            this.classes = Collections.unmodifiableList(in.readList(PerClassSingleValue::new));
            this.avgRecall = in.readDouble();
        }

        @Override
        public String getWriteableName() {
            return MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, NAME);
        }

        @Override
        public String getMetricName() {
            return NAME.getPreferredName();
        }

        public List<PerClassSingleValue> getClasses() {
            return this.classes;
        }

        public double getAvgRecall() {
            return this.avgRecall;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.classes);
            out.writeDouble(this.avgRecall);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CLASSES.getPreferredName(), this.classes);
            builder.field(AVG_RECALL.getPreferredName(), this.avgRecall);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return Objects.equals(this.classes, that.classes) && this.avgRecall == that.avgRecall;
        }

        public int hashCode() {
            return Objects.hash(this.classes, this.avgRecall);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), PerClassSingleValue.PARSER, CLASSES);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), AVG_RECALL);
        }
    }
}

