/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.stats.common;

import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.dataframe.stats.Fields;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class MemoryUsage
implements Writeable,
ToXContentObject {
    public static final String TYPE_VALUE = "analytics_memory_usage";
    public static final ParseField PEAK_USAGE_BYTES = new ParseField("peak_usage_bytes", new String[0]);
    public static final ParseField STATUS = new ParseField("status", new String[0]);
    public static final ParseField MEMORY_REESTIMATE_BYTES = new ParseField("memory_reestimate_bytes", new String[0]);
    public static final ConstructingObjectParser<MemoryUsage, Void> STRICT_PARSER = MemoryUsage.createParser(false);
    public static final ConstructingObjectParser<MemoryUsage, Void> LENIENT_PARSER = MemoryUsage.createParser(true);
    private final String jobId;
    private final Instant timestamp;
    private final long peakUsageBytes;
    private final Status status;
    @Nullable
    private final Long memoryReestimateBytes;

    private static ConstructingObjectParser<MemoryUsage, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<MemoryUsage, Void> parser = new ConstructingObjectParser<MemoryUsage, Void>(TYPE_VALUE, ignoreUnknownFields, a -> new MemoryUsage((String)a[0], (Instant)a[1], (Long)a[2], (Status)a[3], (Long)a[4]));
        parser.declareString((bucket, s) -> {}, Fields.TYPE);
        parser.declareString(ConstructingObjectParser.constructorArg(), Fields.JOB_ID);
        parser.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, Fields.TIMESTAMP.getPreferredName()), Fields.TIMESTAMP, ObjectParser.ValueType.VALUE);
        parser.declareLong(ConstructingObjectParser.constructorArg(), PEAK_USAGE_BYTES);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), Status::fromString, STATUS);
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), MEMORY_REESTIMATE_BYTES);
        return parser;
    }

    public MemoryUsage(String jobId) {
        this(jobId, null, 0L, null, null);
    }

    public MemoryUsage(String jobId, Instant timestamp, long peakUsageBytes, @Nullable Status status, @Nullable Long memoryReestimateBytes) {
        this.jobId = Objects.requireNonNull(jobId);
        this.timestamp = timestamp == null ? null : Instant.ofEpochMilli(ExceptionsHelper.requireNonNull(timestamp, Fields.TIMESTAMP).toEpochMilli());
        this.peakUsageBytes = peakUsageBytes;
        this.status = status == null ? Status.OK : status;
        this.memoryReestimateBytes = memoryReestimateBytes;
    }

    public MemoryUsage(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = in.readOptionalInstant();
        this.peakUsageBytes = in.readVLong();
        this.status = Status.readFromStream(in);
        this.memoryReestimateBytes = in.readOptionalVLong();
    }

    public long getPeakUsageBytes() {
        return this.peakUsageBytes;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeOptionalInstant(this.timestamp);
        out.writeVLong(this.peakUsageBytes);
        this.status.writeTo(out);
        out.writeOptionalVLong(this.memoryReestimateBytes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(Fields.TYPE.getPreferredName(), TYPE_VALUE);
            builder.field(Fields.JOB_ID.getPreferredName(), this.jobId);
        }
        if (this.timestamp != null) {
            builder.timeField(Fields.TIMESTAMP.getPreferredName(), Fields.TIMESTAMP.getPreferredName() + "_string", this.timestamp.toEpochMilli());
        }
        builder.field(PEAK_USAGE_BYTES.getPreferredName(), this.peakUsageBytes);
        builder.field(STATUS.getPreferredName(), this.status);
        if (this.memoryReestimateBytes != null) {
            builder.field(MEMORY_REESTIMATE_BYTES.getPreferredName(), this.memoryReestimateBytes);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryUsage other = (MemoryUsage)o;
        return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timestamp, other.timestamp) && this.peakUsageBytes == other.peakUsageBytes && Objects.equals(this.status, other.status) && Objects.equals(this.memoryReestimateBytes, other.memoryReestimateBytes);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.peakUsageBytes, this.status, this.memoryReestimateBytes);
    }

    public String toString() {
        return Strings.toString(this);
    }

    public String documentId(String jobId) {
        assert (this.timestamp != null);
        return MemoryUsage.documentIdPrefix(jobId) + this.timestamp.toEpochMilli();
    }

    public static String documentIdPrefix(String jobId) {
        return "analytics_memory_usage_" + jobId + "_";
    }

    public static enum Status implements Writeable
    {
        OK,
        HARD_LIMIT;


        public static Status fromString(String value) {
            return Status.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public static Status readFromStream(StreamInput in) throws IOException {
            return in.readEnum(Status.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

