/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.NlpInferenceResults;

public class TextEmbeddingResults
extends NlpInferenceResults {
    public static final String NAME = "text_embedding_result";
    private final String resultsField;
    private final double[] inference;

    public TextEmbeddingResults(String resultsField, double[] inference, boolean isTruncated) {
        super(isTruncated);
        this.inference = inference;
        this.resultsField = resultsField;
    }

    public TextEmbeddingResults(StreamInput in) throws IOException {
        super(in);
        this.inference = in.readDoubleArray();
        this.resultsField = in.readString();
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    public double[] getInference() {
        return this.inference;
    }

    @Override
    void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.resultsField, this.inference);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    void doWriteTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.inference);
        out.writeString(this.resultsField);
    }

    @Override
    void addMapFields(Map<String, Object> map) {
        map.put(this.resultsField, this.inference);
    }

    @Override
    public Object predictedValue() {
        throw new UnsupportedOperationException("[text_embedding_result] does not support a single predicted value");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TextEmbeddingResults that = (TextEmbeddingResults)o;
        return Objects.equals(this.resultsField, that.resultsField) && Arrays.equals(this.inference, that.inference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultsField, Arrays.hashCode(this.inference));
    }
}

