/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NerConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfigUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public class NerConfigUpdate
extends NlpConfigUpdate
implements NamedXContentObject {
    public static final String NAME = "ner";
    private static final ObjectParser<Builder, Void> STRICT_PARSER = NerConfigUpdate.createParser(false);
    private final String resultsField;

    public static NerConfigUpdate fromMap(Map<String, Object> map) {
        HashMap<String, Object> options = new HashMap<String, Object>(map);
        String resultsField = (String)options.remove(NlpConfig.RESULTS_FIELD.getPreferredName());
        if (!options.isEmpty()) {
            throw ExceptionsHelper.badRequestException("Unrecognized fields {}.", options.keySet());
        }
        return new NerConfigUpdate(resultsField);
    }

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser<Builder, Void> parser = new ObjectParser<Builder, Void>(NAME, lenient, Builder::new);
        parser.declareString(Builder::setResultsField, NlpConfig.RESULTS_FIELD);
        return parser;
    }

    public static NerConfigUpdate fromXContentStrict(XContentParser parser) {
        return STRICT_PARSER.apply(parser, null).build();
    }

    public NerConfigUpdate(String resultsField) {
        this.resultsField = resultsField;
    }

    public NerConfigUpdate(StreamInput in) throws IOException {
        this.resultsField = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.resultsField);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.resultsField != null) {
            builder.field(NlpConfig.RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public InferenceConfig apply(InferenceConfig originalConfig) {
        if (!(originalConfig instanceof NerConfig)) {
            throw ExceptionsHelper.badRequestException("Inference config of type [{}] can not be updated with a request of type [{}]", originalConfig.getName(), this.getName());
        }
        NerConfig nerConfig = (NerConfig)originalConfig;
        if (this.isNoop(nerConfig)) {
            return nerConfig;
        }
        return new NerConfig(nerConfig.getVocabularyConfig(), nerConfig.getTokenization(), nerConfig.getClassificationLabels(), Optional.ofNullable(this.resultsField).orElse(nerConfig.getResultsField()));
    }

    boolean isNoop(NerConfig originalConfig) {
        return this.resultsField == null || this.resultsField.equals(originalConfig.getResultsField());
    }

    @Override
    public boolean isSupported(InferenceConfig config) {
        return config instanceof NerConfig;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setResultsField(this.resultsField);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NerConfigUpdate that = (NerConfigUpdate)o;
        return Objects.equals(this.resultsField, that.resultsField);
    }

    public int hashCode() {
        return Objects.hash(this.resultsField);
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, NerConfigUpdate> {
        private String resultsField;

        @Override
        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        @Override
        public NerConfigUpdate build() {
            return new NerConfigUpdate(this.resultsField);
        }
    }
}

