/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ZeroShotClassificationConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public class ZeroShotClassificationConfigUpdate
extends NlpConfigUpdate
implements NamedXContentObject {
    public static final String NAME = "zero_shot_classification";
    private static final ConstructingObjectParser<ZeroShotClassificationConfigUpdate, Void> STRICT_PARSER = new ConstructingObjectParser("zero_shot_classification", a -> new ZeroShotClassificationConfigUpdate((List)a[0], (Boolean)a[1], (String)a[2]));
    private final List<String> labels;
    private final Boolean isMultiLabel;
    private final String resultsField;

    public static ZeroShotClassificationConfigUpdate fromXContentStrict(XContentParser parser) {
        return STRICT_PARSER.apply(parser, null);
    }

    public static ZeroShotClassificationConfigUpdate fromMap(Map<String, Object> map) {
        HashMap<String, Object> options = new HashMap<String, Object>(map);
        Boolean isMultiLabel = (Boolean)options.remove(ZeroShotClassificationConfig.MULTI_LABEL.getPreferredName());
        List labels = (List)options.remove(ZeroShotClassificationConfig.LABELS.getPreferredName());
        String resultsField = (String)options.remove(NlpConfig.RESULTS_FIELD.getPreferredName());
        if (!options.isEmpty()) {
            throw ExceptionsHelper.badRequestException("Unrecognized fields {}.", map.keySet());
        }
        return new ZeroShotClassificationConfigUpdate(labels, isMultiLabel, resultsField);
    }

    public ZeroShotClassificationConfigUpdate(@Nullable List<String> labels, @Nullable Boolean isMultiLabel, @Nullable String resultsField) {
        this.labels = labels;
        if (labels != null && labels.isEmpty()) {
            throw ExceptionsHelper.badRequestException("[{}] must not be empty", ZeroShotClassificationConfig.LABELS.getPreferredName());
        }
        this.isMultiLabel = isMultiLabel;
        this.resultsField = resultsField;
    }

    public ZeroShotClassificationConfigUpdate(StreamInput in) throws IOException {
        this.labels = in.readOptionalStringList();
        this.isMultiLabel = in.readOptionalBoolean();
        this.resultsField = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStringCollection(this.labels);
        out.writeOptionalBoolean(this.isMultiLabel);
        out.writeOptionalString(this.resultsField);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.labels != null) {
            builder.field(ZeroShotClassificationConfig.LABELS.getPreferredName(), this.labels);
        }
        if (this.isMultiLabel != null) {
            builder.field(ZeroShotClassificationConfig.MULTI_LABEL.getPreferredName(), this.isMultiLabel);
        }
        if (this.resultsField != null) {
            builder.field(NlpConfig.RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public InferenceConfig apply(InferenceConfig originalConfig) {
        if (!(originalConfig instanceof ZeroShotClassificationConfig)) {
            throw ExceptionsHelper.badRequestException("Inference config of type [{}] can not be updated with a inference request of type [{}]", originalConfig.getName(), this.getName());
        }
        ZeroShotClassificationConfig zeroShotConfig = (ZeroShotClassificationConfig)originalConfig;
        if ((this.labels == null || this.labels.isEmpty()) && (zeroShotConfig.getLabels() == null || zeroShotConfig.getLabels().isEmpty())) {
            throw ExceptionsHelper.badRequestException("stored configuration has no [{}] defined, supplied inference_config update must supply [{}]", ZeroShotClassificationConfig.LABELS.getPreferredName(), ZeroShotClassificationConfig.LABELS.getPreferredName());
        }
        if (this.isNoop(zeroShotConfig)) {
            return originalConfig;
        }
        return new ZeroShotClassificationConfig(zeroShotConfig.getClassificationLabels(), zeroShotConfig.getVocabularyConfig(), zeroShotConfig.getTokenization(), zeroShotConfig.getHypothesisTemplate(), Optional.ofNullable(this.isMultiLabel).orElse(zeroShotConfig.isMultiLabel()), Optional.ofNullable(this.labels).orElse(zeroShotConfig.getLabels()), Optional.ofNullable(this.resultsField).orElse(zeroShotConfig.getResultsField()));
    }

    boolean isNoop(ZeroShotClassificationConfig originalConfig) {
        return !(this.labels != null && !this.labels.equals(originalConfig.getClassificationLabels()) || this.isMultiLabel != null && !this.isMultiLabel.equals(originalConfig.isMultiLabel()) || this.resultsField != null && !this.resultsField.equals(originalConfig.getResultsField()));
    }

    @Override
    public boolean isSupported(InferenceConfig config) {
        return config instanceof ZeroShotClassificationConfig;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setLabels(this.labels).setMultiLabel(this.isMultiLabel);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZeroShotClassificationConfigUpdate that = (ZeroShotClassificationConfigUpdate)o;
        return Objects.equals(this.isMultiLabel, that.isMultiLabel) && Objects.equals(this.labels, that.labels) && Objects.equals(this.resultsField, that.resultsField);
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.isMultiLabel, this.resultsField);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    static {
        STRICT_PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), ZeroShotClassificationConfig.LABELS);
        STRICT_PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ZeroShotClassificationConfig.MULTI_LABEL);
        STRICT_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), NlpConfig.RESULTS_FIELD);
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, ZeroShotClassificationConfigUpdate> {
        private List<String> labels;
        private Boolean isMultiLabel;
        private String resultsField;

        @Override
        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setLabels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder setMultiLabel(Boolean multiLabel) {
            this.isMultiLabel = multiLabel;
            return this;
        }

        @Override
        public ZeroShotClassificationConfigUpdate build() {
            return new ZeroShotClassificationConfigUpdate(this.labels, this.isMultiLabel, this.resultsField);
        }
    }
}

