/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.rollup.job.GroupConfig;
import org.elasticsearch.xpack.core.rollup.job.MetricConfig;

public class RollupJobConfig
implements NamedWriteable,
ToXContentObject {
    private static final String NAME = "xpack/rollup/jobconfig";
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds(20L);
    private static final String ID = "id";
    private static final String TIMEOUT = "timeout";
    private static final String CRON = "cron";
    private static final String PAGE_SIZE = "page_size";
    private static final String INDEX_PATTERN = "index_pattern";
    private static final String ROLLUP_INDEX = "rollup_index";
    private final String id;
    private final String indexPattern;
    private final String rollupIndex;
    private final GroupConfig groupConfig;
    private final List<MetricConfig> metricsConfig;
    private final TimeValue timeout;
    private final String cron;
    private final int pageSize;
    private static final ConstructingObjectParser<RollupJobConfig, String> PARSER = new ConstructingObjectParser<RollupJobConfig, String>("xpack/rollup/jobconfig", false, (args, optionalId) -> {
        String id = args[0] != null ? (String)args[0] : optionalId;
        String indexPattern = (String)args[1];
        String rollupIndex = (String)args[2];
        GroupConfig groupConfig = (GroupConfig)args[3];
        List metricsConfig = (List)args[4];
        TimeValue timeout = (TimeValue)args[5];
        String cron = (String)args[6];
        int pageSize = (Integer)args[7];
        return new RollupJobConfig(id, indexPattern, rollupIndex, cron, pageSize, groupConfig, metricsConfig, timeout);
    });

    public RollupJobConfig(String id, String indexPattern, String rollupIndex, String cron, int pageSize, GroupConfig groupConfig, List<MetricConfig> metricsConfig, @Nullable TimeValue timeout) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Id must be a non-null, non-empty string");
        }
        if (indexPattern == null || indexPattern.isEmpty()) {
            throw new IllegalArgumentException("Index pattern must be a non-null, non-empty string");
        }
        if (Regex.isMatchAllPattern(indexPattern)) {
            throw new IllegalArgumentException("Index pattern must not match all indices (as it would match it's own rollup index");
        }
        if (Regex.isSimpleMatchPattern(indexPattern) && Regex.simpleMatch(indexPattern, rollupIndex)) {
            throw new IllegalArgumentException("Index pattern would match rollup index name which is not allowed");
        }
        if (indexPattern.equals(rollupIndex)) {
            throw new IllegalArgumentException("Rollup index may not be the same as the index pattern");
        }
        if (rollupIndex == null || rollupIndex.isEmpty()) {
            throw new IllegalArgumentException("Rollup index must be a non-null, non-empty string");
        }
        if (cron == null || cron.isEmpty()) {
            throw new IllegalArgumentException("Cron schedule must be a non-null, non-empty string");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page size is mandatory and  must be a positive long");
        }
        if (groupConfig == null && (metricsConfig == null || metricsConfig.isEmpty())) {
            throw new IllegalArgumentException("At least one grouping or metric must be configured");
        }
        this.id = id;
        this.indexPattern = indexPattern;
        this.rollupIndex = rollupIndex;
        this.groupConfig = groupConfig;
        this.metricsConfig = metricsConfig != null ? metricsConfig : Collections.emptyList();
        this.timeout = timeout != null ? timeout : DEFAULT_TIMEOUT;
        this.cron = cron;
        this.pageSize = pageSize;
    }

    public RollupJobConfig(StreamInput in) throws IOException {
        this.id = in.readString();
        this.indexPattern = in.readString();
        this.rollupIndex = in.readString();
        this.cron = in.readString();
        this.groupConfig = in.readOptionalWriteable(GroupConfig::new);
        this.metricsConfig = in.readList(MetricConfig::new);
        this.timeout = in.readTimeValue();
        this.pageSize = in.readInt();
    }

    public String getId() {
        return this.id;
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public List<MetricConfig> getMetricsConfig() {
        return this.metricsConfig;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public String getIndexPattern() {
        return this.indexPattern;
    }

    public String getRollupIndex() {
        return this.rollupIndex;
    }

    public String getCron() {
        return this.cron;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public Set<String> getAllFields() {
        HashSet<String> fields = new HashSet<String>();
        if (this.groupConfig != null) {
            fields.addAll(this.groupConfig.getAllFields());
        }
        if (this.metricsConfig != null) {
            for (MetricConfig metric : this.metricsConfig) {
                fields.add(metric.getField());
            }
        }
        return Collections.unmodifiableSet(fields);
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        this.groupConfig.validateMappings(fieldCapsResponse, validationException);
        for (MetricConfig m : this.metricsConfig) {
            m.validateMappings(fieldCapsResponse, validationException);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID, this.id);
        builder.field(INDEX_PATTERN, this.indexPattern);
        builder.field(ROLLUP_INDEX, this.rollupIndex);
        builder.field(CRON, this.cron);
        if (this.groupConfig != null) {
            builder.field("groups", this.groupConfig);
        }
        if (this.metricsConfig != null) {
            builder.startArray("metrics");
            for (MetricConfig metric : this.metricsConfig) {
                metric.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.timeout != null) {
            builder.field(TIMEOUT, this.timeout.getStringRep());
        }
        builder.field(PAGE_SIZE, this.pageSize);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.indexPattern);
        out.writeString(this.rollupIndex);
        out.writeString(this.cron);
        out.writeOptionalWriteable(this.groupConfig);
        out.writeList(this.metricsConfig);
        out.writeTimeValue(this.timeout);
        out.writeInt(this.pageSize);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupJobConfig that = (RollupJobConfig)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.indexPattern, that.indexPattern) && Objects.equals(this.rollupIndex, that.rollupIndex) && Objects.equals(this.cron, that.cron) && Objects.equals(this.groupConfig, that.groupConfig) && Objects.equals(this.metricsConfig, that.metricsConfig) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.pageSize, that.pageSize);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.indexPattern, this.rollupIndex, this.cron, this.groupConfig, this.metricsConfig, this.timeout, this.pageSize);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public String toJSONString() {
        return this.toString();
    }

    public static RollupJobConfig fromXContent(XContentParser parser, @Nullable String optionalJobId) throws IOException {
        return PARSER.parse(parser, optionalJobId);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(ID, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(INDEX_PATTERN, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(ROLLUP_INDEX, new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> GroupConfig.fromXContent(p), new ParseField("groups", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> MetricConfig.fromXContent(p), new ParseField("metrics", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue(p.textOrNull(), TIMEOUT), new ParseField(TIMEOUT, new String[0]), ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(CRON, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(PAGE_SIZE, new String[0]));
    }
}

