/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.util.Optional;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.xpack.core.XPackField;

public final class SecurityField {
    public static final String NAME4 = "security4";
    public static final String NIO = "security-nio";
    public static final Setting<Optional<String>> USER_SETTING = new Setting<Optional>(SecurityField.setting("user"), (String)null, Optional::ofNullable, Setting.Property.NodeScope);
    private static final String DLS_FLS_FEATURE_FAMILY = "security-dls-fls";
    public static final LicensedFeature.Momentary DOCUMENT_LEVEL_SECURITY_FEATURE = LicensedFeature.momentary("security-dls-fls", "dls", License.OperationMode.PLATINUM);
    public static final LicensedFeature.Momentary FIELD_LEVEL_SECURITY_FEATURE = LicensedFeature.momentary("security-dls-fls", "fls", License.OperationMode.PLATINUM);

    private SecurityField() {
        assert (DOCUMENT_LEVEL_SECURITY_FEATURE.getMinimumOperationMode() == FIELD_LEVEL_SECURITY_FEATURE.getMinimumOperationMode()) : "dls and fls must have the same license requirement";
        assert (DOCUMENT_LEVEL_SECURITY_FEATURE.isNeedsActive() == FIELD_LEVEL_SECURITY_FEATURE.isNeedsActive()) : "dls and fls must have the same license requirement";
    }

    public static String setting(String setting) {
        assert (setting != null && !setting.startsWith("."));
        return SecurityField.settingPrefix() + setting;
    }

    public static String settingPrefix() {
        return XPackField.featureSettingPrefix("security") + ".";
    }
}

